/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter CostCenter}. This interface is used
 * by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.field.CostCenterField CostCenterField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.link.CostCenterLink CostCenterLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#COST_CENTER COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#COMPANY_CODE COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#COST_CTR_RESPONSIBLE_PERSON_NAME
 * COST_CTR_RESPONSIBLE_PERSON_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#COST_CTR_RESPONSIBLE_USER
 * COST_CTR_RESPONSIBLE_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#COST_CENTER_CURRENCY
 * COST_CENTER_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#DEPARTMENT DEPARTMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#COSTING_SHEET
 * COSTING_SHEET}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#COUNTRY COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#REGION REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#CITY_NAME CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#COST_CENTER_STANDARD_HIER_AREA
 * COST_CENTER_STANDARD_HIER_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#COST_CENTER_CATEGORY
 * COST_CENTER_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#IS_BLKD_FOR_PRIMARY_COSTS_POSTING
 * IS_BLKD_FOR_PRIMARY_COSTS_POSTING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#IS_BLKD_FOR_SECONDARY_COSTS_POSTING
 * IS_BLKD_FOR_SECONDARY_COSTS_POSTING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#IS_BLOCKED_FOR_REVENUE_POSTING
 * IS_BLOCKED_FOR_REVENUE_POSTING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#IS_BLOCKED_FOR_COMMITMENT_POSTING
 * IS_BLOCKED_FOR_COMMITMENT_POSTING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#IS_BLOCKED_FOR_PLAN_PRIMARY_COSTS
 * IS_BLOCKED_FOR_PLAN_PRIMARY_COSTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#IS_BLOCKED_FOR_PLAN_SECONDARY_COSTS
 * IS_BLOCKED_FOR_PLAN_SECONDARY_COSTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#IS_BLOCKED_FOR_PLAN_REVENUES
 * IS_BLOCKED_FOR_PLAN_REVENUES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#CONSUMPTION_QTY_IS_RECORDED
 * CONSUMPTION_QTY_IS_RECORDED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#LANGUAGE LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#COST_CENTER_CREATED_BY_USER
 * COST_CENTER_CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#COST_CENTER_CREATION_DATE
 * COST_CENTER_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenter#TO_TEXT TO_TEXT}</li>
 * </ul>
 *
 */
public interface CostCenterSelectable extends EntitySelectable<CostCenter>
{

}
