/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterText CostCenterText}. This interface
 * is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.field.CostCenterTextField
 * CostCenterTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.link.CostCenterTextLink CostCenterTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterText#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterText#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterText#LANGUAGE LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterText#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterText#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterText#COST_CENTER_NAME
 * COST_CENTER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterText#COST_CENTER_DESCRIPTION
 * COST_CENTER_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenter.CostCenterText#TO_COST_CENTER
 * TO_COST_CENTER}</li>
 * </ul>
 *
 */
public interface CostCenterTextSelectable extends EntitySelectable<CostCenterText>
{

}
