/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.field.CostCenterActivityTypeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.link.CostCenterActivityTypeLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.selectable.CostCenterActivityTypeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Activity Type
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CostCenterActivityTypeType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CostCenterActivityType extends VdmEntity<CostCenterActivityType>
{

    /**
     * Selector for all available fields of CostCenterActivityType.
     *
     */
    public final static CostCenterActivityTypeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeField<String> CONTROLLING_AREA =
        new CostCenterActivityTypeField<String>("ControllingArea");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     *
     * @return Activity Type
     */
    @Key
    @SerializedName( "CostCtrActivityType" )
    @JsonProperty( "CostCtrActivityType" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityType" )
    private String costCtrActivityType;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityType</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeField<String> COST_CTR_ACTIVITY_TYPE =
        new CostCenterActivityTypeField<String>("CostCtrActivityType");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid To Date
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeField<LocalDateTime> VALIDITY_END_DATE =
        new CostCenterActivityTypeField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeField<LocalDateTime> VALIDITY_START_DATE =
        new CostCenterActivityTypeField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityTypeQtyUnit</b>
     * </p>
     *
     * @return Activity Unit
     */
    @SerializedName( "CostCtrActivityTypeQtyUnit" )
    @JsonProperty( "CostCtrActivityTypeQtyUnit" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityTypeQtyUnit" )
    private String costCtrActivityTypeQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityTypeQtyUnit</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeField<String> COST_CTR_ACTIVITY_TYPE_QTY_UNIT =
        new CostCenterActivityTypeField<String>("CostCtrActivityTypeQtyUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityTypeCategory</b>
     * </p>
     *
     * @return Activity Type Category
     */
    @SerializedName( "CostCtrActivityTypeCategory" )
    @JsonProperty( "CostCtrActivityTypeCategory" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityTypeCategory" )
    private String costCtrActivityTypeCategory;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityTypeCategory</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeField<String> COST_CTR_ACTIVITY_TYPE_CATEGORY =
        new CostCenterActivityTypeField<String>("CostCtrActivityTypeCategory");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AllocationCostElement</b>
     * </p>
     *
     * @return Allocation Cost Element
     */
    @SerializedName( "AllocationCostElement" )
    @JsonProperty( "AllocationCostElement" )
    @Nullable
    @ODataField( odataName = "AllocationCostElement" )
    private String allocationCostElement;
    /**
     * Use with available fluent helpers to apply the <b>AllocationCostElement</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeField<String> ALLOCATION_COST_ELEMENT =
        new CostCenterActivityTypeField<String>("AllocationCostElement");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityTypeOutpQtyUnit</b>
     * </p>
     *
     * @return Output Unit
     */
    @SerializedName( "CostCtrActivityTypeOutpQtyUnit" )
    @JsonProperty( "CostCtrActivityTypeOutpQtyUnit" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityTypeOutpQtyUnit" )
    private String costCtrActivityTypeOutpQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityTypeOutpQtyUnit</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeField<String> COST_CTR_ACTIVITY_TYPE_OUTP_QTY_UNIT =
        new CostCenterActivityTypeField<String>("CostCtrActivityTypeOutpQtyUnit");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Created on
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeField<LocalDateTime> CREATION_DATE =
        new CostCenterActivityTypeField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EnteredByUser</b>
     * </p>
     *
     * @return Entered By
     */
    @SerializedName( "EnteredByUser" )
    @JsonProperty( "EnteredByUser" )
    @Nullable
    @ODataField( odataName = "EnteredByUser" )
    private String enteredByUser;
    /**
     * Use with available fluent helpers to apply the <b>EnteredByUser</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeField<String> ENTERED_BY_USER =
        new CostCenterActivityTypeField<String>("EnteredByUser");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CostOriginGroup</b>
     * </p>
     *
     * @return Origin Group as Subdivision of Cost Element
     */
    @SerializedName( "CostOriginGroup" )
    @JsonProperty( "CostOriginGroup" )
    @Nullable
    @ODataField( odataName = "CostOriginGroup" )
    private String costOriginGroup;
    /**
     * Use with available fluent helpers to apply the <b>CostOriginGroup</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeField<String> COST_ORIGIN_GROUP =
        new CostCenterActivityTypeField<String>("CostOriginGroup");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ActlPostgCostCenterActyTypeCat</b>
     * </p>
     *
     * @return Variant Activity Type Category for Actual Postings
     */
    @SerializedName( "ActlPostgCostCenterActyTypeCat" )
    @JsonProperty( "ActlPostgCostCenterActyTypeCat" )
    @Nullable
    @ODataField( odataName = "ActlPostgCostCenterActyTypeCat" )
    private String actlPostgCostCenterActyTypeCat;
    /**
     * Use with available fluent helpers to apply the <b>ActlPostgCostCenterActyTypeCat</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeField<String> ACTL_POSTG_COST_CENTER_ACTY_TYPE_CAT =
        new CostCenterActivityTypeField<String>("ActlPostgCostCenterActyTypeCat");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>OutputQuantityFactor</b>
     * </p>
     *
     * @return Output factor
     */
    @SerializedName( "OutputQuantityFactor" )
    @JsonProperty( "OutputQuantityFactor" )
    @Nullable
    @ODataField( odataName = "OutputQuantityFactor" )
    private BigDecimal outputQuantityFactor;
    /**
     * Use with available fluent helpers to apply the <b>OutputQuantityFactor</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeField<BigDecimal> OUTPUT_QUANTITY_FACTOR =
        new CostCenterActivityTypeField<BigDecimal>("OutputQuantityFactor");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ActivityTypeIsBlocked</b>
     * </p>
     *
     * @return Lock Indicator
     */
    @SerializedName( "ActivityTypeIsBlocked" )
    @JsonProperty( "ActivityTypeIsBlocked" )
    @Nullable
    @ODataField( odataName = "ActivityTypeIsBlocked" )
    private String activityTypeIsBlocked;
    /**
     * Use with available fluent helpers to apply the <b>ActivityTypeIsBlocked</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeField<String> ACTIVITY_TYPE_IS_BLOCKED =
        new CostCenterActivityTypeField<String>("ActivityTypeIsBlocked");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FixedCostIsPredistributed</b>
     * </p>
     *
     * @return Predistribution of fixed costs for acty type/bus. process
     */
    @SerializedName( "FixedCostIsPredistributed" )
    @JsonProperty( "FixedCostIsPredistributed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "FixedCostIsPredistributed" )
    private Boolean fixedCostIsPredistributed;
    /**
     * Use with available fluent helpers to apply the <b>FixedCostIsPredistributed</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeField<Boolean> FIXED_COST_IS_PREDISTRIBUTED =
        new CostCenterActivityTypeField<Boolean>("FixedCostIsPredistributed");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PriceAllocationMethod</b>
     * </p>
     *
     * @return Price Indicator: Calculate Allocation Price
     */
    @SerializedName( "PriceAllocationMethod" )
    @JsonProperty( "PriceAllocationMethod" )
    @Nullable
    @ODataField( odataName = "PriceAllocationMethod" )
    private String priceAllocationMethod;
    /**
     * Use with available fluent helpers to apply the <b>PriceAllocationMethod</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeField<String> PRICE_ALLOCATION_METHOD =
        new CostCenterActivityTypeField<String>("PriceAllocationMethod");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PeriodPriceIsAverage</b>
     * </p>
     *
     * @return Price Calculation with Period-Based Average Prices
     */
    @SerializedName( "PeriodPriceIsAverage" )
    @JsonProperty( "PeriodPriceIsAverage" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PeriodPriceIsAverage" )
    private Boolean periodPriceIsAverage;
    /**
     * Use with available fluent helpers to apply the <b>PeriodPriceIsAverage</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeField<Boolean> PERIOD_PRICE_IS_AVERAGE =
        new CostCenterActivityTypeField<Boolean>("PeriodPriceIsAverage");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualPriceAllocationMethod</b>
     * </p>
     *
     * @return Indicator: Actual Allocation Price
     */
    @SerializedName( "ActualPriceAllocationMethod" )
    @JsonProperty( "ActualPriceAllocationMethod" )
    @Nullable
    @ODataField( odataName = "ActualPriceAllocationMethod" )
    private String actualPriceAllocationMethod;
    /**
     * Use with available fluent helpers to apply the <b>ActualPriceAllocationMethod</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeField<String> ACTUAL_PRICE_ALLOCATION_METHOD =
        new CostCenterActivityTypeField<String>("ActualPriceAllocationMethod");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ActualQuantityIsSetManually</b>
     * </p>
     *
     * @return Indicator: Confirm quantity manually in actual
     */
    @SerializedName( "ActualQuantityIsSetManually" )
    @JsonProperty( "ActualQuantityIsSetManually" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ActualQuantityIsSetManually" )
    private Boolean actualQuantityIsSetManually;
    /**
     * Use with available fluent helpers to apply the <b>ActualQuantityIsSetManually</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeField<Boolean> ACTUAL_QUANTITY_IS_SET_MANUALLY =
        new CostCenterActivityTypeField<Boolean>("ActualQuantityIsSetManually");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlanQuantityIsSetManually</b>
     * </p>
     *
     * @return Indicator: Plan quantity manually set.
     */
    @SerializedName( "PlanQuantityIsSetManually" )
    @JsonProperty( "PlanQuantityIsSetManually" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PlanQuantityIsSetManually" )
    private Boolean planQuantityIsSetManually;
    /**
     * Use with available fluent helpers to apply the <b>PlanQuantityIsSetManually</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeField<Boolean> PLAN_QUANTITY_IS_SET_MANUALLY =
        new CostCenterActivityTypeField<Boolean>("PlanQuantityIsSetManually");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityTypeValidCat</b>
     * </p>
     *
     * @return Valid Cost Center Categories
     */
    @SerializedName( "CostCtrActivityTypeValidCat" )
    @JsonProperty( "CostCtrActivityTypeValidCat" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityTypeValidCat" )
    private String costCtrActivityTypeValidCat;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityTypeValidCat</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeField<String> COST_CTR_ACTIVITY_TYPE_VALID_CAT =
        new CostCenterActivityTypeField<String>("CostCtrActivityTypeValidCat");
    /**
     * Navigation property <b>to_Text</b> for <b>CostCenterActivityType</b> to multiple
     * <b>CostCenterActivityTypeText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CostCenterActivityTypeText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static CostCenterActivityTypeLink<CostCenterActivityTypeText> TO_TEXT =
        new CostCenterActivityTypeLink<CostCenterActivityTypeText>("to_Text");

    @Nonnull
    @Override
    public Class<CostCenterActivityType> getType()
    {
        return CostCenterActivityType.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     *
     * @param costCtrActivityType
     *            Activity Type
     */
    public void setCostCtrActivityType( @Nullable final String costCtrActivityType )
    {
        rememberChangedField("CostCtrActivityType", this.costCtrActivityType);
        this.costCtrActivityType = costCtrActivityType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid To Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Valid-From Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityTypeQtyUnit</b>
     * </p>
     *
     * @param costCtrActivityTypeQtyUnit
     *            Activity Unit
     */
    public void setCostCtrActivityTypeQtyUnit( @Nullable final String costCtrActivityTypeQtyUnit )
    {
        rememberChangedField("CostCtrActivityTypeQtyUnit", this.costCtrActivityTypeQtyUnit);
        this.costCtrActivityTypeQtyUnit = costCtrActivityTypeQtyUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityTypeCategory</b>
     * </p>
     *
     * @param costCtrActivityTypeCategory
     *            Activity Type Category
     */
    public void setCostCtrActivityTypeCategory( @Nullable final String costCtrActivityTypeCategory )
    {
        rememberChangedField("CostCtrActivityTypeCategory", this.costCtrActivityTypeCategory);
        this.costCtrActivityTypeCategory = costCtrActivityTypeCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AllocationCostElement</b>
     * </p>
     *
     * @param allocationCostElement
     *            Allocation Cost Element
     */
    public void setAllocationCostElement( @Nullable final String allocationCostElement )
    {
        rememberChangedField("AllocationCostElement", this.allocationCostElement);
        this.allocationCostElement = allocationCostElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityTypeOutpQtyUnit</b>
     * </p>
     *
     * @param costCtrActivityTypeOutpQtyUnit
     *            Output Unit
     */
    public void setCostCtrActivityTypeOutpQtyUnit( @Nullable final String costCtrActivityTypeOutpQtyUnit )
    {
        rememberChangedField("CostCtrActivityTypeOutpQtyUnit", this.costCtrActivityTypeOutpQtyUnit);
        this.costCtrActivityTypeOutpQtyUnit = costCtrActivityTypeOutpQtyUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Created on
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EnteredByUser</b>
     * </p>
     *
     * @param enteredByUser
     *            Entered By
     */
    public void setEnteredByUser( @Nullable final String enteredByUser )
    {
        rememberChangedField("EnteredByUser", this.enteredByUser);
        this.enteredByUser = enteredByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CostOriginGroup</b>
     * </p>
     *
     * @param costOriginGroup
     *            Origin Group as Subdivision of Cost Element
     */
    public void setCostOriginGroup( @Nullable final String costOriginGroup )
    {
        rememberChangedField("CostOriginGroup", this.costOriginGroup);
        this.costOriginGroup = costOriginGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ActlPostgCostCenterActyTypeCat</b>
     * </p>
     *
     * @param actlPostgCostCenterActyTypeCat
     *            Variant Activity Type Category for Actual Postings
     */
    public void setActlPostgCostCenterActyTypeCat( @Nullable final String actlPostgCostCenterActyTypeCat )
    {
        rememberChangedField("ActlPostgCostCenterActyTypeCat", this.actlPostgCostCenterActyTypeCat);
        this.actlPostgCostCenterActyTypeCat = actlPostgCostCenterActyTypeCat;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>OutputQuantityFactor</b>
     * </p>
     *
     * @param outputQuantityFactor
     *            Output factor
     */
    public void setOutputQuantityFactor( @Nullable final BigDecimal outputQuantityFactor )
    {
        rememberChangedField("OutputQuantityFactor", this.outputQuantityFactor);
        this.outputQuantityFactor = outputQuantityFactor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ActivityTypeIsBlocked</b>
     * </p>
     *
     * @param activityTypeIsBlocked
     *            Lock Indicator
     */
    public void setActivityTypeIsBlocked( @Nullable final String activityTypeIsBlocked )
    {
        rememberChangedField("ActivityTypeIsBlocked", this.activityTypeIsBlocked);
        this.activityTypeIsBlocked = activityTypeIsBlocked;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FixedCostIsPredistributed</b>
     * </p>
     *
     * @param fixedCostIsPredistributed
     *            Predistribution of fixed costs for acty type/bus. process
     */
    public void setFixedCostIsPredistributed( @Nullable final Boolean fixedCostIsPredistributed )
    {
        rememberChangedField("FixedCostIsPredistributed", this.fixedCostIsPredistributed);
        this.fixedCostIsPredistributed = fixedCostIsPredistributed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PriceAllocationMethod</b>
     * </p>
     *
     * @param priceAllocationMethod
     *            Price Indicator: Calculate Allocation Price
     */
    public void setPriceAllocationMethod( @Nullable final String priceAllocationMethod )
    {
        rememberChangedField("PriceAllocationMethod", this.priceAllocationMethod);
        this.priceAllocationMethod = priceAllocationMethod;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PeriodPriceIsAverage</b>
     * </p>
     *
     * @param periodPriceIsAverage
     *            Price Calculation with Period-Based Average Prices
     */
    public void setPeriodPriceIsAverage( @Nullable final Boolean periodPriceIsAverage )
    {
        rememberChangedField("PeriodPriceIsAverage", this.periodPriceIsAverage);
        this.periodPriceIsAverage = periodPriceIsAverage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualPriceAllocationMethod</b>
     * </p>
     *
     * @param actualPriceAllocationMethod
     *            Indicator: Actual Allocation Price
     */
    public void setActualPriceAllocationMethod( @Nullable final String actualPriceAllocationMethod )
    {
        rememberChangedField("ActualPriceAllocationMethod", this.actualPriceAllocationMethod);
        this.actualPriceAllocationMethod = actualPriceAllocationMethod;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ActualQuantityIsSetManually</b>
     * </p>
     *
     * @param actualQuantityIsSetManually
     *            Indicator: Confirm quantity manually in actual
     */
    public void setActualQuantityIsSetManually( @Nullable final Boolean actualQuantityIsSetManually )
    {
        rememberChangedField("ActualQuantityIsSetManually", this.actualQuantityIsSetManually);
        this.actualQuantityIsSetManually = actualQuantityIsSetManually;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PlanQuantityIsSetManually</b>
     * </p>
     *
     * @param planQuantityIsSetManually
     *            Indicator: Plan quantity manually set.
     */
    public void setPlanQuantityIsSetManually( @Nullable final Boolean planQuantityIsSetManually )
    {
        rememberChangedField("PlanQuantityIsSetManually", this.planQuantityIsSetManually);
        this.planQuantityIsSetManually = planQuantityIsSetManually;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityTypeValidCat</b>
     * </p>
     *
     * @param costCtrActivityTypeValidCat
     *            Valid Cost Center Categories
     */
    public void setCostCtrActivityTypeValidCat( @Nullable final String costCtrActivityTypeValidCat )
    {
        rememberChangedField("CostCtrActivityTypeValidCat", this.costCtrActivityTypeValidCat);
        this.costCtrActivityTypeValidCat = costCtrActivityTypeValidCat;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CostCenterActivityType";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ControllingArea", getControllingArea());
        result.put("CostCtrActivityType", getCostCtrActivityType());
        result.put("ValidityEndDate", getValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ControllingArea", getControllingArea());
        values.put("CostCtrActivityType", getCostCtrActivityType());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("CostCtrActivityTypeQtyUnit", getCostCtrActivityTypeQtyUnit());
        values.put("CostCtrActivityTypeCategory", getCostCtrActivityTypeCategory());
        values.put("AllocationCostElement", getAllocationCostElement());
        values.put("CostCtrActivityTypeOutpQtyUnit", getCostCtrActivityTypeOutpQtyUnit());
        values.put("CreationDate", getCreationDate());
        values.put("EnteredByUser", getEnteredByUser());
        values.put("CostOriginGroup", getCostOriginGroup());
        values.put("ActlPostgCostCenterActyTypeCat", getActlPostgCostCenterActyTypeCat());
        values.put("OutputQuantityFactor", getOutputQuantityFactor());
        values.put("ActivityTypeIsBlocked", getActivityTypeIsBlocked());
        values.put("FixedCostIsPredistributed", getFixedCostIsPredistributed());
        values.put("PriceAllocationMethod", getPriceAllocationMethod());
        values.put("PeriodPriceIsAverage", getPeriodPriceIsAverage());
        values.put("ActualPriceAllocationMethod", getActualPriceAllocationMethod());
        values.put("ActualQuantityIsSetManually", getActualQuantityIsSetManually());
        values.put("PlanQuantityIsSetManually", getPlanQuantityIsSetManually());
        values.put("CostCtrActivityTypeValidCat", getCostCtrActivityTypeValidCat());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("CostCtrActivityType") ) {
                final Object value = values.remove("CostCtrActivityType");
                if( (value == null) || (!value.equals(getCostCtrActivityType())) ) {
                    setCostCtrActivityType(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CostCtrActivityTypeQtyUnit") ) {
                final Object value = values.remove("CostCtrActivityTypeQtyUnit");
                if( (value == null) || (!value.equals(getCostCtrActivityTypeQtyUnit())) ) {
                    setCostCtrActivityTypeQtyUnit(((String) value));
                }
            }
            if( values.containsKey("CostCtrActivityTypeCategory") ) {
                final Object value = values.remove("CostCtrActivityTypeCategory");
                if( (value == null) || (!value.equals(getCostCtrActivityTypeCategory())) ) {
                    setCostCtrActivityTypeCategory(((String) value));
                }
            }
            if( values.containsKey("AllocationCostElement") ) {
                final Object value = values.remove("AllocationCostElement");
                if( (value == null) || (!value.equals(getAllocationCostElement())) ) {
                    setAllocationCostElement(((String) value));
                }
            }
            if( values.containsKey("CostCtrActivityTypeOutpQtyUnit") ) {
                final Object value = values.remove("CostCtrActivityTypeOutpQtyUnit");
                if( (value == null) || (!value.equals(getCostCtrActivityTypeOutpQtyUnit())) ) {
                    setCostCtrActivityTypeOutpQtyUnit(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("EnteredByUser") ) {
                final Object value = values.remove("EnteredByUser");
                if( (value == null) || (!value.equals(getEnteredByUser())) ) {
                    setEnteredByUser(((String) value));
                }
            }
            if( values.containsKey("CostOriginGroup") ) {
                final Object value = values.remove("CostOriginGroup");
                if( (value == null) || (!value.equals(getCostOriginGroup())) ) {
                    setCostOriginGroup(((String) value));
                }
            }
            if( values.containsKey("ActlPostgCostCenterActyTypeCat") ) {
                final Object value = values.remove("ActlPostgCostCenterActyTypeCat");
                if( (value == null) || (!value.equals(getActlPostgCostCenterActyTypeCat())) ) {
                    setActlPostgCostCenterActyTypeCat(((String) value));
                }
            }
            if( values.containsKey("OutputQuantityFactor") ) {
                final Object value = values.remove("OutputQuantityFactor");
                if( (value == null) || (!value.equals(getOutputQuantityFactor())) ) {
                    setOutputQuantityFactor(((BigDecimal) value));
                }
            }
            if( values.containsKey("ActivityTypeIsBlocked") ) {
                final Object value = values.remove("ActivityTypeIsBlocked");
                if( (value == null) || (!value.equals(getActivityTypeIsBlocked())) ) {
                    setActivityTypeIsBlocked(((String) value));
                }
            }
            if( values.containsKey("FixedCostIsPredistributed") ) {
                final Object value = values.remove("FixedCostIsPredistributed");
                if( (value == null) || (!value.equals(getFixedCostIsPredistributed())) ) {
                    setFixedCostIsPredistributed(((Boolean) value));
                }
            }
            if( values.containsKey("PriceAllocationMethod") ) {
                final Object value = values.remove("PriceAllocationMethod");
                if( (value == null) || (!value.equals(getPriceAllocationMethod())) ) {
                    setPriceAllocationMethod(((String) value));
                }
            }
            if( values.containsKey("PeriodPriceIsAverage") ) {
                final Object value = values.remove("PeriodPriceIsAverage");
                if( (value == null) || (!value.equals(getPeriodPriceIsAverage())) ) {
                    setPeriodPriceIsAverage(((Boolean) value));
                }
            }
            if( values.containsKey("ActualPriceAllocationMethod") ) {
                final Object value = values.remove("ActualPriceAllocationMethod");
                if( (value == null) || (!value.equals(getActualPriceAllocationMethod())) ) {
                    setActualPriceAllocationMethod(((String) value));
                }
            }
            if( values.containsKey("ActualQuantityIsSetManually") ) {
                final Object value = values.remove("ActualQuantityIsSetManually");
                if( (value == null) || (!value.equals(getActualQuantityIsSetManually())) ) {
                    setActualQuantityIsSetManually(((Boolean) value));
                }
            }
            if( values.containsKey("PlanQuantityIsSetManually") ) {
                final Object value = values.remove("PlanQuantityIsSetManually");
                if( (value == null) || (!value.equals(getPlanQuantityIsSetManually())) ) {
                    setPlanQuantityIsSetManually(((Boolean) value));
                }
            }
            if( values.containsKey("CostCtrActivityTypeValidCat") ) {
                final Object value = values.remove("CostCtrActivityTypeValidCat");
                if( (value == null) || (!value.equals(getCostCtrActivityTypeValidCat())) ) {
                    setCostCtrActivityTypeValidCat(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CostCenterActivityTypeText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new CostCenterActivityTypeText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CostCenterActivityTypeField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CostCenterActivityTypeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CostCenterActivityTypeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CostCenterActivityTypeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterActivityTypeService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>CostCenterActivityTypeText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CostCenterActivityTypeText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CostCenterActivityTypeText> fetchText()
    {
        return fetchFieldAsList("to_Text", CostCenterActivityTypeText.class);
    }

    /**
     * Retrieval of associated <b>CostCenterActivityTypeText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>CostCenterActivityType</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CostCenterActivityTypeText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CostCenterActivityTypeText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>CostCenterActivityTypeText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>CostCenterActivityType</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>CostCenterActivityTypeText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CostCenterActivityTypeText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>CostCenterActivityTypeText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>CostCenterActivityType</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CostCenterActivityTypeText</b> entities.
     */
    public void setText( @Nonnull final List<CostCenterActivityTypeText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CostCenterActivityTypeText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>CostCenterActivityType</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CostCenterActivityTypeText</b> entities.
     */
    public void addText( CostCenterActivityTypeText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CostCenterActivityType instances.
     *
     */
    public final static class CostCenterActivityTypeBuilder
    {

        private List<CostCenterActivityTypeText> toText = Lists.newArrayList();

        private CostCenterActivityType.CostCenterActivityTypeBuilder toText(
            final List<CostCenterActivityTypeText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>CostCenterActivityType</b> to multiple
         * <b>CostCenterActivityTypeText</b>.
         *
         * @param value
         *            The CostCenterActivityTypeTexts to build this CostCenterActivityType with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CostCenterActivityType.CostCenterActivityTypeBuilder text( CostCenterActivityTypeText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
