/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.field.CostCenterActivityTypeTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.link.CostCenterActivityTypeTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.selectable.CostCenterActivityTypeTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Activity Type Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CostCenterActivityTypeTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CostCenterActivityTypeText extends VdmEntity<CostCenterActivityTypeText>
{

    /**
     * Selector for all available fields of CostCenterActivityTypeText.
     *
     */
    public final static CostCenterActivityTypeTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Valid To Date
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeTextField<LocalDateTime> VALIDITY_END_DATE =
        new CostCenterActivityTypeTextField<LocalDateTime>("ValidityEndDate");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeTextField<String> CONTROLLING_AREA =
        new CostCenterActivityTypeTextField<String>("ControllingArea");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     *
     * @return Activity Type
     */
    @Key
    @SerializedName( "CostCtrActivityType" )
    @JsonProperty( "CostCtrActivityType" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityType" )
    private String costCtrActivityType;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityType</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeTextField<String> COST_CTR_ACTIVITY_TYPE =
        new CostCenterActivityTypeTextField<String>("CostCtrActivityType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeTextField<String> LANGUAGE =
        new CostCenterActivityTypeTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityTypeName</b>
     * </p>
     *
     * @return General Name
     */
    @SerializedName( "CostCtrActivityTypeName" )
    @JsonProperty( "CostCtrActivityTypeName" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityTypeName" )
    private String costCtrActivityTypeName;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityTypeName</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeTextField<String> COST_CTR_ACTIVITY_TYPE_NAME =
        new CostCenterActivityTypeTextField<String>("CostCtrActivityTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityTypeDesc</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "CostCtrActivityTypeDesc" )
    @JsonProperty( "CostCtrActivityTypeDesc" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityTypeDesc" )
    private String costCtrActivityTypeDesc;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityTypeDesc</b> field to query operations.
     *
     */
    public final static CostCenterActivityTypeTextField<String> COST_CTR_ACTIVITY_TYPE_DESC =
        new CostCenterActivityTypeTextField<String>("CostCtrActivityTypeDesc");
    /**
     * Navigation property <b>to_CostCenterActivityType</b> for <b>CostCenterActivityTypeText</b> to single
     * <b>CostCenterActivityType</b>.
     *
     */
    @SerializedName( "to_CostCenterActivityType" )
    @JsonProperty( "to_CostCenterActivityType" )
    @ODataField( odataName = "to_CostCenterActivityType" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CostCenterActivityType toCostCenterActivityType;
    /**
     * Use with available fluent helpers to apply the <b>to_CostCenterActivityType</b> navigation property to query
     * operations.
     *
     */
    public final static CostCenterActivityTypeTextOneToOneLink<CostCenterActivityType> TO_COST_CENTER_ACTIVITY_TYPE =
        new CostCenterActivityTypeTextOneToOneLink<CostCenterActivityType>("to_CostCenterActivityType");

    @Nonnull
    @Override
    public Class<CostCenterActivityTypeText> getType()
    {
        return CostCenterActivityTypeText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Valid To Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityType</b>
     * </p>
     *
     * @param costCtrActivityType
     *            Activity Type
     */
    public void setCostCtrActivityType( @Nullable final String costCtrActivityType )
    {
        rememberChangedField("CostCtrActivityType", this.costCtrActivityType);
        this.costCtrActivityType = costCtrActivityType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityTypeName</b>
     * </p>
     *
     * @param costCtrActivityTypeName
     *            General Name
     */
    public void setCostCtrActivityTypeName( @Nullable final String costCtrActivityTypeName )
    {
        rememberChangedField("CostCtrActivityTypeName", this.costCtrActivityTypeName);
        this.costCtrActivityTypeName = costCtrActivityTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityTypeDesc</b>
     * </p>
     *
     * @param costCtrActivityTypeDesc
     *            Description
     */
    public void setCostCtrActivityTypeDesc( @Nullable final String costCtrActivityTypeDesc )
    {
        rememberChangedField("CostCtrActivityTypeDesc", this.costCtrActivityTypeDesc);
        this.costCtrActivityTypeDesc = costCtrActivityTypeDesc;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CostCenterActivityTypeText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ValidityEndDate", getValidityEndDate());
        result.put("ControllingArea", getControllingArea());
        result.put("CostCtrActivityType", getCostCtrActivityType());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ControllingArea", getControllingArea());
        values.put("CostCtrActivityType", getCostCtrActivityType());
        values.put("Language", getLanguage());
        values.put("CostCtrActivityTypeName", getCostCtrActivityTypeName());
        values.put("CostCtrActivityTypeDesc", getCostCtrActivityTypeDesc());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("CostCtrActivityType") ) {
                final Object value = values.remove("CostCtrActivityType");
                if( (value == null) || (!value.equals(getCostCtrActivityType())) ) {
                    setCostCtrActivityType(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("CostCtrActivityTypeName") ) {
                final Object value = values.remove("CostCtrActivityTypeName");
                if( (value == null) || (!value.equals(getCostCtrActivityTypeName())) ) {
                    setCostCtrActivityTypeName(((String) value));
                }
            }
            if( values.containsKey("CostCtrActivityTypeDesc") ) {
                final Object value = values.remove("CostCtrActivityTypeDesc");
                if( (value == null) || (!value.equals(getCostCtrActivityTypeDesc())) ) {
                    setCostCtrActivityTypeDesc(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CostCenterActivityType") ) {
                final Object value = (values).remove("to_CostCenterActivityType");
                if( value instanceof Map ) {
                    if( toCostCenterActivityType == null ) {
                        toCostCenterActivityType = new CostCenterActivityType();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCostCenterActivityType.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CostCenterActivityTypeTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CostCenterActivityTypeTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CostCenterActivityTypeTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CostCenterActivityTypeTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterActivityTypeService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCostCenterActivityType != null ) {
            (values).put("to_CostCenterActivityType", toCostCenterActivityType);
        }
        return values;
    }

    /**
     * Fetches the <b>CostCenterActivityType</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CostCenterActivityType</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CostCenterActivityType</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CostCenterActivityType fetchCostCenterActivityType()
    {
        return fetchFieldAsSingle("to_CostCenterActivityType", CostCenterActivityType.class);
    }

    /**
     * Retrieval of associated <b>CostCenterActivityType</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CostCenterActivityType</b>.
     * <p>
     * If the navigation property <b>to_CostCenterActivityType</b> of a queried <b>CostCenterActivityTypeText</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CostCenterActivityType</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CostCenterActivityType getCostCenterActivityTypeOrFetch()
    {
        if( toCostCenterActivityType == null ) {
            toCostCenterActivityType = fetchCostCenterActivityType();
        }
        return toCostCenterActivityType;
    }

    /**
     * Retrieval of associated <b>CostCenterActivityType</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CostCenterActivityType</b>.
     * <p>
     * If the navigation property for an entity <b>CostCenterActivityTypeText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CostCenterActivityType</b> is already loaded, the result
     *         will contain the <b>CostCenterActivityType</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CostCenterActivityType> getCostCenterActivityTypeIfPresent()
    {
        return Option.of(toCostCenterActivityType);
    }

    /**
     * Overwrites the associated <b>CostCenterActivityType</b> entity for the loaded navigation property
     * <b>to_CostCenterActivityType</b>.
     *
     * @param value
     *            New <b>CostCenterActivityType</b> entity.
     */
    public void setCostCenterActivityType( final CostCenterActivityType value )
    {
        toCostCenterActivityType = value;
    }

    /**
     * Helper class to allow for fluent creation of CostCenterActivityTypeText instances.
     *
     */
    public final static class CostCenterActivityTypeTextBuilder
    {

        private CostCenterActivityType toCostCenterActivityType;

        private CostCenterActivityTypeText.CostCenterActivityTypeTextBuilder toCostCenterActivityType(
            final CostCenterActivityType value )
        {
            toCostCenterActivityType = value;
            return this;
        }

        /**
         * Navigation property <b>to_CostCenterActivityType</b> for <b>CostCenterActivityTypeText</b> to single
         * <b>CostCenterActivityType</b>.
         *
         * @param value
         *            The CostCenterActivityType to build this CostCenterActivityTypeText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CostCenterActivityTypeText.CostCenterActivityTypeTextBuilder costCenterActivityType(
            final CostCenterActivityType value )
        {
            return toCostCenterActivityType(value);
        }

    }

}
