/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperDelete;

/**
 * Fluent helper to delete an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityTypeText
 * CostCenterActivityTypeText} entity in the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class CostCenterActivityTypeTextDeleteFluentHelper
    extends
    FluentHelperDelete<CostCenterActivityTypeTextDeleteFluentHelper, CostCenterActivityTypeText>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityTypeText
     * CostCenterActivityTypeText} entity object that will be deleted in the S/4HANA system.
     *
     */
    private final CostCenterActivityTypeText entity;

    /**
     * Creates a fluent helper object that will delete a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityTypeText
     * CostCenterActivityTypeText} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            The entity collection to direct the update requests to.
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The CostCenterActivityTypeText to delete from the endpoint.
     */
    public CostCenterActivityTypeTextDeleteFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final CostCenterActivityTypeText entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected CostCenterActivityTypeText getEntity()
    {
        return entity;
    }

}
