/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityType;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityTypeText;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterActivityTypeService
 * CostCenterActivityTypeService}.
 *
 */
public interface CostCenterActivityTypeServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<CostCenterActivityTypeServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<CostCenterActivityTypeServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityType
     * CostCenterActivityType} entity and save it to the S/4HANA system.
     *
     * @param costCenterActivityType
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityType
     *            CostCenterActivityType} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CostCenterActivityTypeServiceBatchChangeSet
        createCostCenterActivityType( @Nonnull final CostCenterActivityType costCenterActivityType );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityType
     * CostCenterActivityType} entity and save it to the S/4HANA system.
     *
     * @param costCenterActivityType
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityType
     *            CostCenterActivityType} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CostCenterActivityTypeServiceBatchChangeSet
        updateCostCenterActivityType( @Nonnull final CostCenterActivityType costCenterActivityType );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityType
     * CostCenterActivityType} entity in the S/4HANA system.
     *
     * @param costCenterActivityType
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityType
     *            CostCenterActivityType} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CostCenterActivityTypeServiceBatchChangeSet
        deleteCostCenterActivityType( @Nonnull final CostCenterActivityType costCenterActivityType );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityTypeText
     * CostCenterActivityTypeText} entity and save it to the S/4HANA system.
     *
     * @param costCenterActivityTypeText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityTypeText
     *            CostCenterActivityTypeText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CostCenterActivityTypeServiceBatchChangeSet
        createCostCenterActivityTypeText( @Nonnull final CostCenterActivityTypeText costCenterActivityTypeText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityTypeText
     * CostCenterActivityTypeText} entity and save it to the S/4HANA system.
     *
     * @param costCenterActivityTypeText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityTypeText
     *            CostCenterActivityTypeText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CostCenterActivityTypeServiceBatchChangeSet
        updateCostCenterActivityTypeText( @Nonnull final CostCenterActivityTypeText costCenterActivityTypeText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityTypeText
     * CostCenterActivityTypeText} entity in the S/4HANA system.
     *
     * @param costCenterActivityTypeText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityTypeText
     *            CostCenterActivityTypeText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CostCenterActivityTypeServiceBatchChangeSet
        deleteCostCenterActivityTypeText( @Nonnull final CostCenterActivityTypeText costCenterActivityTypeText );

}
