/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link CostCenterActivityTypeServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterActivityTypeService
 * CostCenterActivityTypeService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultCostCenterActivityTypeServiceBatch
    extends
    BatchFluentHelperBasic<CostCenterActivityTypeServiceBatch, CostCenterActivityTypeServiceBatchChangeSet>
    implements
    CostCenterActivityTypeServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterActivityTypeService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultCostCenterActivityTypeServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCostCenterActivityTypeServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterActivityTypeService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterActivityTypeService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultCostCenterActivityTypeServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCostCenterActivityTypeServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterActivityTypeService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultCostCenterActivityTypeServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CostCenterActivityTypeServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultCostCenterActivityTypeServiceBatchChangeSet(this, service);
    }

}
