/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityType;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcenteractivitytype.CostCenterActivityTypeText;

/**
 * Implementation of the {@link CostCenterActivityTypeServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterActivityTypeService
 * CostCenterActivityTypeService}.
 *
 */
public class DefaultCostCenterActivityTypeServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<CostCenterActivityTypeServiceBatch, CostCenterActivityTypeServiceBatchChangeSet>
    implements
    CostCenterActivityTypeServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterActivityTypeService service;

    @SuppressWarnings( "deprecation" )
    DefaultCostCenterActivityTypeServiceBatchChangeSet(
        @Nonnull final DefaultCostCenterActivityTypeServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterActivityTypeService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultCostCenterActivityTypeServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CostCenterActivityTypeServiceBatchChangeSet createCostCenterActivityType(
        @Nonnull final CostCenterActivityType costCenterActivityType )
    {
        return addRequestCreate(service::createCostCenterActivityType, costCenterActivityType);
    }

    @Nonnull
    @Override
    public CostCenterActivityTypeServiceBatchChangeSet updateCostCenterActivityType(
        @Nonnull final CostCenterActivityType costCenterActivityType )
    {
        return addRequestUpdate(service::updateCostCenterActivityType, costCenterActivityType);
    }

    @Nonnull
    @Override
    public CostCenterActivityTypeServiceBatchChangeSet deleteCostCenterActivityType(
        @Nonnull final CostCenterActivityType costCenterActivityType )
    {
        return addRequestDelete(service::deleteCostCenterActivityType, costCenterActivityType);
    }

    @Nonnull
    @Override
    public CostCenterActivityTypeServiceBatchChangeSet createCostCenterActivityTypeText(
        @Nonnull final CostCenterActivityTypeText costCenterActivityTypeText )
    {
        return addRequestCreate(service::createCostCenterActivityTypeText, costCenterActivityTypeText);
    }

    @Nonnull
    @Override
    public CostCenterActivityTypeServiceBatchChangeSet updateCostCenterActivityTypeText(
        @Nonnull final CostCenterActivityTypeText costCenterActivityTypeText )
    {
        return addRequestUpdate(service::updateCostCenterActivityTypeText, costCenterActivityTypeText);
    }

    @Nonnull
    @Override
    public CostCenterActivityTypeServiceBatchChangeSet deleteCostCenterActivityTypeText(
        @Nonnull final CostCenterActivityTypeText costCenterActivityTypeText )
    {
        return addRequestDelete(service::deleteCostCenterActivityTypeText, costCenterActivityTypeText);
    }

}
