/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.field.CostCenterField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.link.CostCenterLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.selectable.CostCenterSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>CostCenter</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CostCenter extends VdmEntity<CostCenter>
{

    /**
     * Selector for all available fields of CostCenter.
     *
     */
    public final static CostCenterSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return The company code is an organizational unit within financial accounting.
     */
    @Key
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static CostCenterField<String> COMPANY_CODE = new CostCenterField<String>("CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterID</b>
     * </p>
     *
     * @return A key that uniquely identifies a cost center.
     */
    @Key
    @SerializedName( "CostCenterID" )
    @JsonProperty( "CostCenterID" )
    @Nullable
    @ODataField( odataName = "CostCenterID" )
    private String costCenterID;
    /**
     * Use with available fluent helpers to apply the <b>CostCenterID</b> field to query operations.
     *
     */
    public final static CostCenterField<String> COST_CENTER_ID = new CostCenterField<String>("CostCenterID");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Date indicating up to when an entry is valid.
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static CostCenterField<LocalDateTime> VALIDITY_END_DATE =
        new CostCenterField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Date indicating as of when an entry is valid.
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static CostCenterField<LocalDateTime> VALIDITY_START_DATE =
        new CostCenterField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Status</b>
     * </p>
     *
     * @return Character Field with Length 10
     */
    @SerializedName( "Status" )
    @JsonProperty( "Status" )
    @Nullable
    @ODataField( odataName = "Status" )
    private String status;
    /**
     * Use with available fluent helpers to apply the <b>Status</b> field to query operations.
     *
     */
    public final static CostCenterField<String> STATUS = new CostCenterField<String>("Status");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Category</b>
     * </p>
     * <p>
     * The master data of an activity type includes one or more cost center categories. The activity type may be used
     * only by cost centers of the appropriate categories.You define categories in Customizing. For each category, you
     * can define default values for the "Lock" and "Record quantity" indicators, for transfer to cost center master
     * data. Maintain these indicators only if the entry diverges from the default cost center category.In addition, you
     * may use the categories for reports and evaluations.Production cost centerService cost centerAdministration cost
     * center
     * </p>
     *
     * @return Indicator used to define a cost center category.
     */
    @SerializedName( "Category" )
    @JsonProperty( "Category" )
    @Nullable
    @ODataField( odataName = "Category" )
    private String category;
    /**
     * Use with available fluent helpers to apply the <b>Category</b> field to query operations.
     *
     */
    public final static CostCenterField<String> CATEGORY = new CostCenterField<String>("Category");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * <p>
     * It corresponds to:1) All languages according to ISO 639.22) Languages assigned to specific countries or scripts1)
     * Persian = 'FA'2) EnglishEnglish Australia = '1E'English Canada = '3E'English Ireland = '8E'English New Zealand =
     * '1N'
     * </p>
     *
     * @return SAP Language Key (2-letter code) for Unicode languages.
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static CostCenterField<String> LANGUAGE = new CostCenterField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterName</b>
     * </p>
     *
     * @return General description of the object.
     */
    @SerializedName( "CostCenterName" )
    @JsonProperty( "CostCenterName" )
    @Nullable
    @ODataField( odataName = "CostCenterName" )
    private String costCenterName;
    /**
     * Use with available fluent helpers to apply the <b>CostCenterName</b> field to query operations.
     *
     */
    public final static CostCenterField<String> COST_CENTER_NAME = new CostCenterField<String>("CostCenterName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterDescription</b>
     * </p>
     *
     * @return A text that describes the object to which it refers in greater detail.
     */
    @SerializedName( "CostCenterDescription" )
    @JsonProperty( "CostCenterDescription" )
    @Nullable
    @ODataField( odataName = "CostCenterDescription" )
    private String costCenterDescription;
    /**
     * Use with available fluent helpers to apply the <b>CostCenterDescription</b> field to query operations.
     *
     */
    public final static CostCenterField<String> COST_CENTER_DESCRIPTION =
        new CostCenterField<String>("CostCenterDescription");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     * <p>
     * To normalize local times in a UTC time stamp and make them comparable, they must be converted using their time
     * zone and the ABAP command convert.Although the time zone for the conversion can be fetched from customizing or
     * master data, you should save it redundantly.The internal structure of the UTC time stamp is logically divided
     * into a date and time part in packed number format <YYYYMMDDhhmmss>. There is also a high resolution UTC time
     * stamp (10^-7 seconds).
     * </p>
     *
     * @return The UTC timestamp is the date and time relative to the UTC (Universal coordinated time).
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static CostCenterField<LocalDateTime> LAST_CHANGE_DATE_TIME =
        new CostCenterField<LocalDateTime>("LastChangeDateTime");
    /**
     * Navigation property <b>CostCenterTexts</b> for <b>CostCenter</b> to multiple <b>CostCenterText</b>.
     *
     */
    @SerializedName( "CostCenterTexts" )
    @JsonProperty( "CostCenterTexts" )
    @ODataField( odataName = "CostCenterTexts" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CostCenterText> toCostCenterTexts;
    /**
     * Use with available fluent helpers to apply the <b>CostCenterTexts</b> navigation property to query operations.
     *
     */
    public final static CostCenterLink<CostCenterText> TO_COST_CENTER_TEXTS =
        new CostCenterLink<CostCenterText>("CostCenterTexts");

    @Nonnull
    @Override
    public Class<CostCenter> getType()
    {
        return CostCenter.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            The company code is an organizational unit within financial accounting.
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterID</b>
     * </p>
     *
     * @param costCenterID
     *            A key that uniquely identifies a cost center.
     */
    public void setCostCenterID( @Nullable final String costCenterID )
    {
        rememberChangedField("CostCenterID", this.costCenterID);
        this.costCenterID = costCenterID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Date indicating up to when an entry is valid.
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Date indicating as of when an entry is valid.
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Status</b>
     * </p>
     *
     * @param status
     *            Character Field with Length 10
     */
    public void setStatus( @Nullable final String status )
    {
        rememberChangedField("Status", this.status);
        this.status = status;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>Category</b>
     * </p>
     * <p>
     * The master data of an activity type includes one or more cost center categories. The activity type may be used
     * only by cost centers of the appropriate categories.You define categories in Customizing. For each category, you
     * can define default values for the "Lock" and "Record quantity" indicators, for transfer to cost center master
     * data. Maintain these indicators only if the entry diverges from the default cost center category.In addition, you
     * may use the categories for reports and evaluations.Production cost centerService cost centerAdministration cost
     * center
     * </p>
     *
     * @param category
     *            Indicator used to define a cost center category.
     */
    public void setCategory( @Nullable final String category )
    {
        rememberChangedField("Category", this.category);
        this.category = category;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * <p>
     * It corresponds to:1) All languages according to ISO 639.22) Languages assigned to specific countries or scripts1)
     * Persian = 'FA'2) EnglishEnglish Australia = '1E'English Canada = '3E'English Ireland = '8E'English New Zealand =
     * '1N'
     * </p>
     *
     * @param language
     *            SAP Language Key (2-letter code) for Unicode languages.
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterName</b>
     * </p>
     *
     * @param costCenterName
     *            General description of the object.
     */
    public void setCostCenterName( @Nullable final String costCenterName )
    {
        rememberChangedField("CostCenterName", this.costCenterName);
        this.costCenterName = costCenterName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterDescription</b>
     * </p>
     *
     * @param costCenterDescription
     *            A text that describes the object to which it refers in greater detail.
     */
    public void setCostCenterDescription( @Nullable final String costCenterDescription )
    {
        rememberChangedField("CostCenterDescription", this.costCenterDescription);
        this.costCenterDescription = costCenterDescription;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     * <p>
     * To normalize local times in a UTC time stamp and make them comparable, they must be converted using their time
     * zone and the ABAP command convert.Although the time zone for the conversion can be fetched from customizing or
     * master data, you should save it redundantly.The internal structure of the UTC time stamp is logically divided
     * into a date and time part in packed number format <YYYYMMDDhhmmss>. There is also a high resolution UTC time
     * stamp (10^-7 seconds).
     * </p>
     *
     * @param lastChangeDateTime
     *            The UTC timestamp is the date and time relative to the UTC (Universal coordinated time).
     */
    public void setLastChangeDateTime( @Nullable final LocalDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CostCenterCollection";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CompanyCode", getCompanyCode());
        result.put("CostCenterID", getCostCenterID());
        result.put("ValidityEndDate", getValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CompanyCode", getCompanyCode());
        values.put("CostCenterID", getCostCenterID());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("Status", getStatus());
        values.put("Category", getCategory());
        values.put("Language", getLanguage());
        values.put("CostCenterName", getCostCenterName());
        values.put("CostCenterDescription", getCostCenterDescription());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("CostCenterID") ) {
                final Object value = values.remove("CostCenterID");
                if( (value == null) || (!value.equals(getCostCenterID())) ) {
                    setCostCenterID(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Status") ) {
                final Object value = values.remove("Status");
                if( (value == null) || (!value.equals(getStatus())) ) {
                    setStatus(((String) value));
                }
            }
            if( values.containsKey("Category") ) {
                final Object value = values.remove("Category");
                if( (value == null) || (!value.equals(getCategory())) ) {
                    setCategory(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("CostCenterName") ) {
                final Object value = values.remove("CostCenterName");
                if( (value == null) || (!value.equals(getCostCenterName())) ) {
                    setCostCenterName(((String) value));
                }
            }
            if( values.containsKey("CostCenterDescription") ) {
                final Object value = values.remove("CostCenterDescription");
                if( (value == null) || (!value.equals(getCostCenterDescription())) ) {
                    setCostCenterDescription(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("CostCenterTexts") ) {
                final Object value = (values).remove("CostCenterTexts");
                if( value instanceof Iterable ) {
                    if( toCostCenterTexts == null ) {
                        toCostCenterTexts = Lists.newArrayList();
                    } else {
                        toCostCenterTexts = Lists.newArrayList(toCostCenterTexts);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CostCenterText entity;
                        if( toCostCenterTexts.size() > i ) {
                            entity = toCostCenterTexts.get(i);
                        } else {
                            entity = new CostCenterText();
                            toCostCenterTexts.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CostCenterField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CostCenterField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CostCenterField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CostCenterField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterTestService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCostCenterTexts != null ) {
            (values).put("CostCenterTexts", toCostCenterTexts);
        }
        return values;
    }

    /**
     * Fetches the <b>CostCenterText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>CostCenterTexts</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CostCenterText</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CostCenterText> fetchCostCenterTexts()
    {
        return fetchFieldAsList("CostCenterTexts", CostCenterText.class);
    }

    /**
     * Retrieval of associated <b>CostCenterText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>CostCenterTexts</b>.
     * <p>
     * If the navigation property <b>CostCenterTexts</b> of a queried <b>CostCenter</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CostCenterText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CostCenterText> getCostCenterTextsOrFetch()
    {
        if( toCostCenterTexts == null ) {
            toCostCenterTexts = fetchCostCenterTexts();
        }
        return toCostCenterTexts;
    }

    /**
     * Retrieval of associated <b>CostCenterText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>CostCenterTexts</b>.
     * <p>
     * If the navigation property for an entity <b>CostCenter</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>CostCenterTexts</b> is already loaded, the result will
     *         contain the <b>CostCenterText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CostCenterText>> getCostCenterTextsIfPresent()
    {
        return Option.of(toCostCenterTexts);
    }

    /**
     * Overwrites the list of associated <b>CostCenterText</b> entities for the loaded navigation property
     * <b>CostCenterTexts</b>.
     * <p>
     * If the navigation property <b>CostCenterTexts</b> of a queried <b>CostCenter</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CostCenterText</b> entities.
     */
    public void setCostCenterTexts( @Nonnull final List<CostCenterText> value )
    {
        if( toCostCenterTexts == null ) {
            toCostCenterTexts = Lists.newArrayList();
        }
        toCostCenterTexts.clear();
        toCostCenterTexts.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CostCenterText</b> entities. This corresponds to the OData navigation
     * property <b>CostCenterTexts</b>.
     * <p>
     * If the navigation property <b>CostCenterTexts</b> of a queried <b>CostCenter</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CostCenterText</b> entities.
     */
    public void addCostCenterTexts( CostCenterText... entity )
    {
        if( toCostCenterTexts == null ) {
            toCostCenterTexts = Lists.newArrayList();
        }
        toCostCenterTexts.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CostCenter instances.
     *
     */
    public final static class CostCenterBuilder
    {

        private List<CostCenterText> toCostCenterTexts = Lists.newArrayList();

        private CostCenter.CostCenterBuilder toCostCenterTexts( final List<CostCenterText> value )
        {
            toCostCenterTexts.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>CostCenterTexts</b> for <b>CostCenter</b> to multiple <b>CostCenterText</b>.
         *
         * @param value
         *            The CostCenterTexts to build this CostCenter with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CostCenter.CostCenterBuilder costCenterTexts( CostCenterText... value )
        {
            return toCostCenterTexts(Lists.newArrayList(value));
        }

    }

}
