/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.field.CostCenterTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.selectable.CostCenterTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * <p>
 * Original entity name from the Odata EDM: <b>CostCenterText</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CostCenterText extends VdmEntity<CostCenterText>
{

    /**
     * Selector for all available fields of CostCenterText.
     *
     */
    public final static CostCenterTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return The company code is an organizational unit within financial accounting.
     */
    @Key
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static CostCenterTextField<String> COMPANY_CODE = new CostCenterTextField<String>("CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterID</b>
     * </p>
     *
     * @return A key that uniquely identifies a cost center.
     */
    @Key
    @SerializedName( "CostCenterID" )
    @JsonProperty( "CostCenterID" )
    @Nullable
    @ODataField( odataName = "CostCenterID" )
    private String costCenterID;
    /**
     * Use with available fluent helpers to apply the <b>CostCenterID</b> field to query operations.
     *
     */
    public final static CostCenterTextField<String> COST_CENTER_ID = new CostCenterTextField<String>("CostCenterID");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Date indicating up to when an entry is valid.
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static CostCenterTextField<LocalDateTime> VALIDITY_END_DATE =
        new CostCenterTextField<LocalDateTime>("ValidityEndDate");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * <p>
     * It corresponds to:1) All languages according to ISO 639.22) Languages assigned to specific countries or scripts1)
     * Persian = 'FA'2) EnglishEnglish Australia = '1E'English Canada = '3E'English Ireland = '8E'English New Zealand =
     * '1N'
     * </p>
     *
     * @return SAP Language Key (2-letter code) for Unicode languages.
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static CostCenterTextField<String> LANGUAGE = new CostCenterTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterName</b>
     * </p>
     *
     * @return General description of the object.
     */
    @SerializedName( "CostCenterName" )
    @JsonProperty( "CostCenterName" )
    @Nullable
    @ODataField( odataName = "CostCenterName" )
    private String costCenterName;
    /**
     * Use with available fluent helpers to apply the <b>CostCenterName</b> field to query operations.
     *
     */
    public final static CostCenterTextField<String> COST_CENTER_NAME =
        new CostCenterTextField<String>("CostCenterName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterDescription</b>
     * </p>
     *
     * @return A text that describes the object to which it refers in greater detail.
     */
    @SerializedName( "CostCenterDescription" )
    @JsonProperty( "CostCenterDescription" )
    @Nullable
    @ODataField( odataName = "CostCenterDescription" )
    private String costCenterDescription;
    /**
     * Use with available fluent helpers to apply the <b>CostCenterDescription</b> field to query operations.
     *
     */
    public final static CostCenterTextField<String> COST_CENTER_DESCRIPTION =
        new CostCenterTextField<String>("CostCenterDescription");

    @Nonnull
    @Override
    public Class<CostCenterText> getType()
    {
        return CostCenterText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            The company code is an organizational unit within financial accounting.
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterID</b>
     * </p>
     *
     * @param costCenterID
     *            A key that uniquely identifies a cost center.
     */
    public void setCostCenterID( @Nullable final String costCenterID )
    {
        rememberChangedField("CostCenterID", this.costCenterID);
        this.costCenterID = costCenterID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Date indicating up to when an entry is valid.
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     * <p>
     * It corresponds to:1) All languages according to ISO 639.22) Languages assigned to specific countries or scripts1)
     * Persian = 'FA'2) EnglishEnglish Australia = '1E'English Canada = '3E'English Ireland = '8E'English New Zealand =
     * '1N'
     * </p>
     *
     * @param language
     *            SAP Language Key (2-letter code) for Unicode languages.
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterName</b>
     * </p>
     *
     * @param costCenterName
     *            General description of the object.
     */
    public void setCostCenterName( @Nullable final String costCenterName )
    {
        rememberChangedField("CostCenterName", this.costCenterName);
        this.costCenterName = costCenterName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CostCenterDescription</b>
     * </p>
     *
     * @param costCenterDescription
     *            A text that describes the object to which it refers in greater detail.
     */
    public void setCostCenterDescription( @Nullable final String costCenterDescription )
    {
        rememberChangedField("CostCenterDescription", this.costCenterDescription);
        this.costCenterDescription = costCenterDescription;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CostCenterTextCollection";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CompanyCode", getCompanyCode());
        result.put("CostCenterID", getCostCenterID());
        result.put("ValidityEndDate", getValidityEndDate());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CompanyCode", getCompanyCode());
        values.put("CostCenterID", getCostCenterID());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("Language", getLanguage());
        values.put("CostCenterName", getCostCenterName());
        values.put("CostCenterDescription", getCostCenterDescription());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("CostCenterID") ) {
                final Object value = values.remove("CostCenterID");
                if( (value == null) || (!value.equals(getCostCenterID())) ) {
                    setCostCenterID(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("CostCenterName") ) {
                final Object value = values.remove("CostCenterName");
                if( (value == null) || (!value.equals(getCostCenterName())) ) {
                    setCostCenterName(((String) value));
                }
            }
            if( values.containsKey("CostCenterDescription") ) {
                final Object value = values.remove("CostCenterDescription");
                if( (value == null) || (!value.equals(getCostCenterDescription())) ) {
                    setCostCenterDescription(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CostCenterTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CostCenterTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CostCenterTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CostCenterTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterTestService.DEFAULT_SERVICE_PATH);
    }

}
