/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterTestService CostCenterTestService}.
 *
 */
public interface CostCenterTestServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<CostCenterTestServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<CostCenterTestServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenter CostCenter}
     * entity and save it to the S/4HANA system.
     *
     * @param costCenter
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenter CostCenter}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CostCenterTestServiceBatchChangeSet createCostCenter( @Nonnull final CostCenter costCenter );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenter
     * CostCenter} entity and save it to the S/4HANA system.
     *
     * @param costCenter
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenter CostCenter}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CostCenterTestServiceBatchChangeSet updateCostCenter( @Nonnull final CostCenter costCenter );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenter
     * CostCenter} entity in the S/4HANA system.
     *
     * @param costCenter
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenter CostCenter}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CostCenterTestServiceBatchChangeSet deleteCostCenter( @Nonnull final CostCenter costCenter );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText
     * CostCenterText} entity and save it to the S/4HANA system.
     *
     * @param costCenterText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText
     *            CostCenterText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CostCenterTestServiceBatchChangeSet createCostCenterText( @Nonnull final CostCenterText costCenterText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText
     * CostCenterText} entity and save it to the S/4HANA system.
     *
     * @param costCenterText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText
     *            CostCenterText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CostCenterTestServiceBatchChangeSet updateCostCenterText( @Nonnull final CostCenterText costCenterText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText
     * CostCenterText} entity in the S/4HANA system.
     *
     * @param costCenterText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText
     *            CostCenterText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CostCenterTestServiceBatchChangeSet deleteCostCenterText( @Nonnull final CostCenterText costCenterText );

}
