/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link CostCenterTestServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterTestService CostCenterTestService}, allowing you
 * to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultCostCenterTestServiceBatch
    extends
    BatchFluentHelperBasic<CostCenterTestServiceBatch, CostCenterTestServiceBatchChangeSet>
    implements
    CostCenterTestServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterTestService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultCostCenterTestServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCostCenterTestServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterTestService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterTestService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultCostCenterTestServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCostCenterTestServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterTestService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultCostCenterTestServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CostCenterTestServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultCostCenterTestServiceBatchChangeSet(this, service);
    }

}
