/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenter;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText;

/**
 * Implementation of the {@link CostCenterTestServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterTestService CostCenterTestService}.
 *
 */
public class DefaultCostCenterTestServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<CostCenterTestServiceBatch, CostCenterTestServiceBatchChangeSet>
    implements
    CostCenterTestServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterTestService service;

    @SuppressWarnings( "deprecation" )
    DefaultCostCenterTestServiceBatchChangeSet(
        @Nonnull final DefaultCostCenterTestServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostCenterTestService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultCostCenterTestServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CostCenterTestServiceBatchChangeSet createCostCenter( @Nonnull final CostCenter costCenter )
    {
        return addRequestCreate(service::createCostCenter, costCenter);
    }

    @Nonnull
    @Override
    public CostCenterTestServiceBatchChangeSet updateCostCenter( @Nonnull final CostCenter costCenter )
    {
        return addRequestUpdate(service::updateCostCenter, costCenter);
    }

    @Nonnull
    @Override
    public CostCenterTestServiceBatchChangeSet deleteCostCenter( @Nonnull final CostCenter costCenter )
    {
        return addRequestDelete(service::deleteCostCenter, costCenter);
    }

    @Nonnull
    @Override
    public CostCenterTestServiceBatchChangeSet createCostCenterText( @Nonnull final CostCenterText costCenterText )
    {
        return addRequestCreate(service::createCostCenterText, costCenterText);
    }

    @Nonnull
    @Override
    public CostCenterTestServiceBatchChangeSet updateCostCenterText( @Nonnull final CostCenterText costCenterText )
    {
        return addRequestUpdate(service::updateCostCenterText, costCenterText);
    }

    @Nonnull
    @Override
    public CostCenterTestServiceBatchChangeSet deleteCostCenterText( @Nonnull final CostCenterText costCenterText )
    {
        return addRequestDelete(service::deleteCostCenterText, costCenterText);
    }

}
