/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText CostCenterText}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.field.CostCenterTextField
 * CostCenterTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.link.CostCenterTextLink
 * CostCenterTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText#COST_CENTER_ID
 * COST_CENTER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText#LANGUAGE LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText#COST_CENTER_NAME
 * COST_CENTER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcentertest.CostCenterText#COST_CENTER_DESCRIPTION
 * COST_CENTER_DESCRIPTION}</li>
 * </ul>
 *
 */
public interface CostCenterTextSelectable extends EntitySelectable<CostCenterText>
{

}
