/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.field.CostRevenueReassignmentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.link.CostRevenueReassignmentLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.selectable.CostRevenueReassignmentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Cost Reassignment Header
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CostRevenueReassignment_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CostRevenueReassignment extends VdmEntity<CostRevenueReassignment>
{

    /**
     * Selector for all available fields of CostRevenueReassignment.
     *
     */
    public final static CostRevenueReassignmentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @Key
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentField<String> FISCAL_YEAR =
        new CostRevenueReassignmentField<String>("FiscalYear");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocument</b>
     * </p>
     *
     * @return Reference document number
     */
    @Key
    @SerializedName( "ReferenceDocument" )
    @JsonProperty( "ReferenceDocument" )
    @Nullable
    @ODataField( odataName = "ReferenceDocument" )
    private String referenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocument</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentField<String> REFERENCE_DOCUMENT =
        new CostRevenueReassignmentField<String>("ReferenceDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentField<String> CONTROLLING_AREA =
        new CostRevenueReassignmentField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentHeaderText</b>
     * </p>
     *
     * @return Document Header Text
     */
    @SerializedName( "AccountingDocumentHeaderText" )
    @JsonProperty( "AccountingDocumentHeaderText" )
    @Nullable
    @ODataField( odataName = "AccountingDocumentHeaderText" )
    private String accountingDocumentHeaderText;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentHeaderText</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentField<String> ACCOUNTING_DOCUMENT_HEADER_TEXT =
        new CostRevenueReassignmentField<String>("AccountingDocumentHeaderText");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     *
     * @return Journal Entry Date
     */
    @SerializedName( "DocumentDate" )
    @JsonProperty( "DocumentDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DocumentDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime documentDate;
    /**
     * Use with available fluent helpers to apply the <b>DocumentDate</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentField<LocalDateTime> DOCUMENT_DATE =
        new CostRevenueReassignmentField<LocalDateTime>("DocumentDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @return Posting Date
     */
    @SerializedName( "PostingDate" )
    @JsonProperty( "PostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime postingDate;
    /**
     * Use with available fluent helpers to apply the <b>PostingDate</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentField<LocalDateTime> POSTING_DATE =
        new CostRevenueReassignmentField<LocalDateTime>("PostingDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriod</b>
     * </p>
     *
     * @return Fiscal Period
     */
    @SerializedName( "FiscalPeriod" )
    @JsonProperty( "FiscalPeriod" )
    @Nullable
    @ODataField( odataName = "FiscalPeriod" )
    private String fiscalPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FiscalPeriod</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentField<String> FISCAL_PERIOD =
        new CostRevenueReassignmentField<String>("FiscalPeriod");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentCreationDate</b>
     * </p>
     *
     * @return Accounting Document Entry Date
     */
    @SerializedName( "AccountingDocumentCreationDate" )
    @JsonProperty( "AccountingDocumentCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "AccountingDocumentCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime accountingDocumentCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocumentCreationDate</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentField<LocalDateTime> ACCOUNTING_DOCUMENT_CREATION_DATE =
        new CostRevenueReassignmentField<LocalDateTime>("AccountingDocumentCreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocCreatedByUser</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "AccountingDocCreatedByUser" )
    @JsonProperty( "AccountingDocCreatedByUser" )
    @Nullable
    @ODataField( odataName = "AccountingDocCreatedByUser" )
    private String accountingDocCreatedByUser;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocCreatedByUser</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentField<String> ACCOUNTING_DOC_CREATED_BY_USER =
        new CostRevenueReassignmentField<String>("AccountingDocCreatedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentType</b>
     * </p>
     *
     * @return Reference Document Type
     */
    @SerializedName( "ReferenceDocumentType" )
    @JsonProperty( "ReferenceDocumentType" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentType" )
    private String referenceDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentType</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentField<String> REFERENCE_DOCUMENT_TYPE =
        new CostRevenueReassignmentField<String>("ReferenceDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentTypeName</b>
     * </p>
     *
     * @return Name of Object Type
     */
    @SerializedName( "ReferenceDocumentTypeName" )
    @JsonProperty( "ReferenceDocumentTypeName" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentTypeName" )
    private String referenceDocumentTypeName;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentTypeName</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentField<String> REFERENCE_DOCUMENT_TYPE_NAME =
        new CostRevenueReassignmentField<String>("ReferenceDocumentTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostRevenueReassignmentAction</b>
     * </p>
     *
     * @return Cost and Revenue Reassignment Action to be executed
     */
    @SerializedName( "CostRevenueReassignmentAction" )
    @JsonProperty( "CostRevenueReassignmentAction" )
    @Nullable
    @ODataField( odataName = "CostRevenueReassignmentAction" )
    private String costRevenueReassignmentAction;
    /**
     * Use with available fluent helpers to apply the <b>CostRevenueReassignmentAction</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentField<String> COST_REVENUE_REASSIGNMENT_ACTION =
        new CostRevenueReassignmentField<String>("CostRevenueReassignmentAction");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PostingFiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @SerializedName( "PostingFiscalYear" )
    @JsonProperty( "PostingFiscalYear" )
    @Nullable
    @ODataField( odataName = "PostingFiscalYear" )
    private String postingFiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>PostingFiscalYear</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentField<String> POSTING_FISCAL_YEAR =
        new CostRevenueReassignmentField<String>("PostingFiscalYear");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateDate</b>
     * </p>
     *
     * @return Date of Translation of Transaction Currency into Local
     */
    @SerializedName( "ExchangeRateDate" )
    @JsonProperty( "ExchangeRateDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ExchangeRateDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime exchangeRateDate;
    /**
     * Use with available fluent helpers to apply the <b>ExchangeRateDate</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentField<LocalDateTime> EXCHANGE_RATE_DATE =
        new CostRevenueReassignmentField<LocalDateTime>("ExchangeRateDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ControllingDocumentStatus</b>
     * </p>
     *
     * @return Document status
     */
    @SerializedName( "ControllingDocumentStatus" )
    @JsonProperty( "ControllingDocumentStatus" )
    @Nullable
    @ODataField( odataName = "ControllingDocumentStatus" )
    private String controllingDocumentStatus;
    /**
     * Use with available fluent helpers to apply the <b>ControllingDocumentStatus</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentField<String> CONTROLLING_DOCUMENT_STATUS =
        new CostRevenueReassignmentField<String>("ControllingDocumentStatus");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>StatusName</b>
     * </p>
     *
     * @return Document status
     */
    @SerializedName( "StatusName" )
    @JsonProperty( "StatusName" )
    @Nullable
    @ODataField( odataName = "StatusName" )
    private String statusName;
    /**
     * Use with available fluent helpers to apply the <b>StatusName</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentField<String> STATUS_NAME =
        new CostRevenueReassignmentField<String>("StatusName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AllocationPostingType</b>
     * </p>
     *
     * @return Posting type
     */
    @SerializedName( "AllocationPostingType" )
    @JsonProperty( "AllocationPostingType" )
    @Nullable
    @ODataField( odataName = "AllocationPostingType" )
    private String allocationPostingType;
    /**
     * Use with available fluent helpers to apply the <b>AllocationPostingType</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentField<String> ALLOCATION_POSTING_TYPE =
        new CostRevenueReassignmentField<String>("AllocationPostingType");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>AllocationPostingTypeText</b>
     * </p>
     *
     * @return Posting type
     */
    @SerializedName( "AllocationPostingTypeText" )
    @JsonProperty( "AllocationPostingTypeText" )
    @Nullable
    @ODataField( odataName = "AllocationPostingTypeText" )
    private String allocationPostingTypeText;
    /**
     * Use with available fluent helpers to apply the <b>AllocationPostingTypeText</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentField<String> ALLOCATION_POSTING_TYPE_TEXT =
        new CostRevenueReassignmentField<String>("AllocationPostingTypeText");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReversalReferenceDocument</b>
     * </p>
     *
     * @return Reversal Reference Document
     */
    @SerializedName( "ReversalReferenceDocument" )
    @JsonProperty( "ReversalReferenceDocument" )
    @Nullable
    @ODataField( odataName = "ReversalReferenceDocument" )
    private String reversalReferenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReversalReferenceDocument</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentField<String> REVERSAL_REFERENCE_DOCUMENT =
        new CostRevenueReassignmentField<String>("ReversalReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReversedReferenceDocument</b>
     * </p>
     *
     * @return Reversed Reference Document
     */
    @SerializedName( "ReversedReferenceDocument" )
    @JsonProperty( "ReversedReferenceDocument" )
    @Nullable
    @ODataField( odataName = "ReversedReferenceDocument" )
    private String reversedReferenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReversedReferenceDocument</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentField<String> REVERSED_REFERENCE_DOCUMENT =
        new CostRevenueReassignmentField<String>("ReversedReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CostRevenueReassignmentType</b>
     * </p>
     *
     * @return Reassignment Type of Cost and Revenue
     */
    @SerializedName( "CostRevenueReassignmentType" )
    @JsonProperty( "CostRevenueReassignmentType" )
    @Nullable
    @ODataField( odataName = "CostRevenueReassignmentType" )
    private String costRevenueReassignmentType;
    /**
     * Use with available fluent helpers to apply the <b>CostRevenueReassignmentType</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentField<String> COST_REVENUE_REASSIGNMENT_TYPE =
        new CostRevenueReassignmentField<String>("CostRevenueReassignmentType");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CostRevnReassignmentTypeName</b>
     * </p>
     *
     * @return Reassignment Type of Cost and Revenue Name
     */
    @SerializedName( "CostRevnReassignmentTypeName" )
    @JsonProperty( "CostRevnReassignmentTypeName" )
    @Nullable
    @ODataField( odataName = "CostRevnReassignmentTypeName" )
    private String costRevnReassignmentTypeName;
    /**
     * Use with available fluent helpers to apply the <b>CostRevnReassignmentTypeName</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentField<String> COST_REVN_REASSIGNMENT_TYPE_NAME =
        new CostRevenueReassignmentField<String>("CostRevnReassignmentTypeName");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GlobalCurrency</b>
     * </p>
     *
     * @return Global Currency
     */
    @SerializedName( "GlobalCurrency" )
    @JsonProperty( "GlobalCurrency" )
    @Nullable
    @ODataField( odataName = "GlobalCurrency" )
    private String globalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>GlobalCurrency</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentField<String> GLOBAL_CURRENCY =
        new CostRevenueReassignmentField<String>("GlobalCurrency");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalAmountInGlobalCurrency</b>
     * </p>
     *
     * @return Amount in Company Code Currency
     */
    @SerializedName( "TotalAmountInGlobalCurrency" )
    @JsonProperty( "TotalAmountInGlobalCurrency" )
    @Nullable
    @ODataField( odataName = "TotalAmountInGlobalCurrency" )
    private BigDecimal totalAmountInGlobalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TotalAmountInGlobalCurrency</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentField<BigDecimal> TOTAL_AMOUNT_IN_GLOBAL_CURRENCY =
        new CostRevenueReassignmentField<BigDecimal>("TotalAmountInGlobalCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WarningsAreIgnored</b>
     * </p>
     *
     * @return Ignore Warnings
     */
    @SerializedName( "WarningsAreIgnored" )
    @JsonProperty( "WarningsAreIgnored" )
    @Nullable
    @ODataField( odataName = "WarningsAreIgnored" )
    private String warningsAreIgnored;
    /**
     * Use with available fluent helpers to apply the <b>WarningsAreIgnored</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentField<String> WARNINGS_ARE_IGNORED =
        new CostRevenueReassignmentField<String>("WarningsAreIgnored");
    /**
     * Navigation property <b>to_Item</b> for <b>CostRevenueReassignment</b> to multiple
     * <b>CostRevenueReassignmentItem</b>.
     *
     */
    @SerializedName( "to_Item" )
    @JsonProperty( "to_Item" )
    @ODataField( odataName = "to_Item" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CostRevenueReassignmentItem> toItem;
    /**
     * Use with available fluent helpers to apply the <b>to_Item</b> navigation property to query operations.
     *
     */
    public final static CostRevenueReassignmentLink<CostRevenueReassignmentItem> TO_ITEM =
        new CostRevenueReassignmentLink<CostRevenueReassignmentItem>("to_Item");

    @Nonnull
    @Override
    public Class<CostRevenueReassignment> getType()
    {
        return CostRevenueReassignment.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocument</b>
     * </p>
     *
     * @param referenceDocument
     *            Reference document number
     */
    public void setReferenceDocument( @Nullable final String referenceDocument )
    {
        rememberChangedField("ReferenceDocument", this.referenceDocument);
        this.referenceDocument = referenceDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentHeaderText</b>
     * </p>
     *
     * @param accountingDocumentHeaderText
     *            Document Header Text
     */
    public void setAccountingDocumentHeaderText( @Nullable final String accountingDocumentHeaderText )
    {
        rememberChangedField("AccountingDocumentHeaderText", this.accountingDocumentHeaderText);
        this.accountingDocumentHeaderText = accountingDocumentHeaderText;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     *
     * @param documentDate
     *            Journal Entry Date
     */
    public void setDocumentDate( @Nullable final LocalDateTime documentDate )
    {
        rememberChangedField("DocumentDate", this.documentDate);
        this.documentDate = documentDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @param postingDate
     *            Posting Date
     */
    public void setPostingDate( @Nullable final LocalDateTime postingDate )
    {
        rememberChangedField("PostingDate", this.postingDate);
        this.postingDate = postingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FiscalPeriod</b>
     * </p>
     *
     * @param fiscalPeriod
     *            Fiscal Period
     */
    public void setFiscalPeriod( @Nullable final String fiscalPeriod )
    {
        rememberChangedField("FiscalPeriod", this.fiscalPeriod);
        this.fiscalPeriod = fiscalPeriod;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocumentCreationDate</b>
     * </p>
     *
     * @param accountingDocumentCreationDate
     *            Accounting Document Entry Date
     */
    public void setAccountingDocumentCreationDate( @Nullable final LocalDateTime accountingDocumentCreationDate )
    {
        rememberChangedField("AccountingDocumentCreationDate", this.accountingDocumentCreationDate);
        this.accountingDocumentCreationDate = accountingDocumentCreationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocCreatedByUser</b>
     * </p>
     *
     * @param accountingDocCreatedByUser
     *            Created By
     */
    public void setAccountingDocCreatedByUser( @Nullable final String accountingDocCreatedByUser )
    {
        rememberChangedField("AccountingDocCreatedByUser", this.accountingDocCreatedByUser);
        this.accountingDocCreatedByUser = accountingDocCreatedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentType</b>
     * </p>
     *
     * @param referenceDocumentType
     *            Reference Document Type
     */
    public void setReferenceDocumentType( @Nullable final String referenceDocumentType )
    {
        rememberChangedField("ReferenceDocumentType", this.referenceDocumentType);
        this.referenceDocumentType = referenceDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentTypeName</b>
     * </p>
     *
     * @param referenceDocumentTypeName
     *            Name of Object Type
     */
    public void setReferenceDocumentTypeName( @Nullable final String referenceDocumentTypeName )
    {
        rememberChangedField("ReferenceDocumentTypeName", this.referenceDocumentTypeName);
        this.referenceDocumentTypeName = referenceDocumentTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostRevenueReassignmentAction</b>
     * </p>
     *
     * @param costRevenueReassignmentAction
     *            Cost and Revenue Reassignment Action to be executed
     */
    public void setCostRevenueReassignmentAction( @Nullable final String costRevenueReassignmentAction )
    {
        rememberChangedField("CostRevenueReassignmentAction", this.costRevenueReassignmentAction);
        this.costRevenueReassignmentAction = costRevenueReassignmentAction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PostingFiscalYear</b>
     * </p>
     *
     * @param postingFiscalYear
     *            Fiscal Year
     */
    public void setPostingFiscalYear( @Nullable final String postingFiscalYear )
    {
        rememberChangedField("PostingFiscalYear", this.postingFiscalYear);
        this.postingFiscalYear = postingFiscalYear;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateDate</b>
     * </p>
     *
     * @param exchangeRateDate
     *            Date of Translation of Transaction Currency into Local
     */
    public void setExchangeRateDate( @Nullable final LocalDateTime exchangeRateDate )
    {
        rememberChangedField("ExchangeRateDate", this.exchangeRateDate);
        this.exchangeRateDate = exchangeRateDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ControllingDocumentStatus</b>
     * </p>
     *
     * @param controllingDocumentStatus
     *            Document status
     */
    public void setControllingDocumentStatus( @Nullable final String controllingDocumentStatus )
    {
        rememberChangedField("ControllingDocumentStatus", this.controllingDocumentStatus);
        this.controllingDocumentStatus = controllingDocumentStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>StatusName</b>
     * </p>
     *
     * @param statusName
     *            Document status
     */
    public void setStatusName( @Nullable final String statusName )
    {
        rememberChangedField("StatusName", this.statusName);
        this.statusName = statusName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AllocationPostingType</b>
     * </p>
     *
     * @param allocationPostingType
     *            Posting type
     */
    public void setAllocationPostingType( @Nullable final String allocationPostingType )
    {
        rememberChangedField("AllocationPostingType", this.allocationPostingType);
        this.allocationPostingType = allocationPostingType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>AllocationPostingTypeText</b>
     * </p>
     *
     * @param allocationPostingTypeText
     *            Posting type
     */
    public void setAllocationPostingTypeText( @Nullable final String allocationPostingTypeText )
    {
        rememberChangedField("AllocationPostingTypeText", this.allocationPostingTypeText);
        this.allocationPostingTypeText = allocationPostingTypeText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReversalReferenceDocument</b>
     * </p>
     *
     * @param reversalReferenceDocument
     *            Reversal Reference Document
     */
    public void setReversalReferenceDocument( @Nullable final String reversalReferenceDocument )
    {
        rememberChangedField("ReversalReferenceDocument", this.reversalReferenceDocument);
        this.reversalReferenceDocument = reversalReferenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReversedReferenceDocument</b>
     * </p>
     *
     * @param reversedReferenceDocument
     *            Reversed Reference Document
     */
    public void setReversedReferenceDocument( @Nullable final String reversedReferenceDocument )
    {
        rememberChangedField("ReversedReferenceDocument", this.reversedReferenceDocument);
        this.reversedReferenceDocument = reversedReferenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CostRevenueReassignmentType</b>
     * </p>
     *
     * @param costRevenueReassignmentType
     *            Reassignment Type of Cost and Revenue
     */
    public void setCostRevenueReassignmentType( @Nullable final String costRevenueReassignmentType )
    {
        rememberChangedField("CostRevenueReassignmentType", this.costRevenueReassignmentType);
        this.costRevenueReassignmentType = costRevenueReassignmentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>CostRevnReassignmentTypeName</b>
     * </p>
     *
     * @param costRevnReassignmentTypeName
     *            Reassignment Type of Cost and Revenue Name
     */
    public void setCostRevnReassignmentTypeName( @Nullable final String costRevnReassignmentTypeName )
    {
        rememberChangedField("CostRevnReassignmentTypeName", this.costRevnReassignmentTypeName);
        this.costRevnReassignmentTypeName = costRevnReassignmentTypeName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GlobalCurrency</b>
     * </p>
     *
     * @param globalCurrency
     *            Global Currency
     */
    public void setGlobalCurrency( @Nullable final String globalCurrency )
    {
        rememberChangedField("GlobalCurrency", this.globalCurrency);
        this.globalCurrency = globalCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalAmountInGlobalCurrency</b>
     * </p>
     *
     * @param totalAmountInGlobalCurrency
     *            Amount in Company Code Currency
     */
    public void setTotalAmountInGlobalCurrency( @Nullable final BigDecimal totalAmountInGlobalCurrency )
    {
        rememberChangedField("TotalAmountInGlobalCurrency", this.totalAmountInGlobalCurrency);
        this.totalAmountInGlobalCurrency = totalAmountInGlobalCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WarningsAreIgnored</b>
     * </p>
     *
     * @param warningsAreIgnored
     *            Ignore Warnings
     */
    public void setWarningsAreIgnored( @Nullable final String warningsAreIgnored )
    {
        rememberChangedField("WarningsAreIgnored", this.warningsAreIgnored);
        this.warningsAreIgnored = warningsAreIgnored;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CostRevenueReassignment";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FiscalYear", getFiscalYear());
        result.put("ReferenceDocument", getReferenceDocument());
        result.put("ControllingArea", getControllingArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FiscalYear", getFiscalYear());
        values.put("ReferenceDocument", getReferenceDocument());
        values.put("ControllingArea", getControllingArea());
        values.put("AccountingDocumentHeaderText", getAccountingDocumentHeaderText());
        values.put("DocumentDate", getDocumentDate());
        values.put("PostingDate", getPostingDate());
        values.put("FiscalPeriod", getFiscalPeriod());
        values.put("AccountingDocumentCreationDate", getAccountingDocumentCreationDate());
        values.put("AccountingDocCreatedByUser", getAccountingDocCreatedByUser());
        values.put("ReferenceDocumentType", getReferenceDocumentType());
        values.put("ReferenceDocumentTypeName", getReferenceDocumentTypeName());
        values.put("CostRevenueReassignmentAction", getCostRevenueReassignmentAction());
        values.put("PostingFiscalYear", getPostingFiscalYear());
        values.put("ExchangeRateDate", getExchangeRateDate());
        values.put("ControllingDocumentStatus", getControllingDocumentStatus());
        values.put("StatusName", getStatusName());
        values.put("AllocationPostingType", getAllocationPostingType());
        values.put("AllocationPostingTypeText", getAllocationPostingTypeText());
        values.put("ReversalReferenceDocument", getReversalReferenceDocument());
        values.put("ReversedReferenceDocument", getReversedReferenceDocument());
        values.put("CostRevenueReassignmentType", getCostRevenueReassignmentType());
        values.put("CostRevnReassignmentTypeName", getCostRevnReassignmentTypeName());
        values.put("GlobalCurrency", getGlobalCurrency());
        values.put("TotalAmountInGlobalCurrency", getTotalAmountInGlobalCurrency());
        values.put("WarningsAreIgnored", getWarningsAreIgnored());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocument") ) {
                final Object value = values.remove("ReferenceDocument");
                if( (value == null) || (!value.equals(getReferenceDocument())) ) {
                    setReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("AccountingDocumentHeaderText") ) {
                final Object value = values.remove("AccountingDocumentHeaderText");
                if( (value == null) || (!value.equals(getAccountingDocumentHeaderText())) ) {
                    setAccountingDocumentHeaderText(((String) value));
                }
            }
            if( values.containsKey("DocumentDate") ) {
                final Object value = values.remove("DocumentDate");
                if( (value == null) || (!value.equals(getDocumentDate())) ) {
                    setDocumentDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PostingDate") ) {
                final Object value = values.remove("PostingDate");
                if( (value == null) || (!value.equals(getPostingDate())) ) {
                    setPostingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("FiscalPeriod") ) {
                final Object value = values.remove("FiscalPeriod");
                if( (value == null) || (!value.equals(getFiscalPeriod())) ) {
                    setFiscalPeriod(((String) value));
                }
            }
            if( values.containsKey("AccountingDocumentCreationDate") ) {
                final Object value = values.remove("AccountingDocumentCreationDate");
                if( (value == null) || (!value.equals(getAccountingDocumentCreationDate())) ) {
                    setAccountingDocumentCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("AccountingDocCreatedByUser") ) {
                final Object value = values.remove("AccountingDocCreatedByUser");
                if( (value == null) || (!value.equals(getAccountingDocCreatedByUser())) ) {
                    setAccountingDocCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentType") ) {
                final Object value = values.remove("ReferenceDocumentType");
                if( (value == null) || (!value.equals(getReferenceDocumentType())) ) {
                    setReferenceDocumentType(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentTypeName") ) {
                final Object value = values.remove("ReferenceDocumentTypeName");
                if( (value == null) || (!value.equals(getReferenceDocumentTypeName())) ) {
                    setReferenceDocumentTypeName(((String) value));
                }
            }
            if( values.containsKey("CostRevenueReassignmentAction") ) {
                final Object value = values.remove("CostRevenueReassignmentAction");
                if( (value == null) || (!value.equals(getCostRevenueReassignmentAction())) ) {
                    setCostRevenueReassignmentAction(((String) value));
                }
            }
            if( values.containsKey("PostingFiscalYear") ) {
                final Object value = values.remove("PostingFiscalYear");
                if( (value == null) || (!value.equals(getPostingFiscalYear())) ) {
                    setPostingFiscalYear(((String) value));
                }
            }
            if( values.containsKey("ExchangeRateDate") ) {
                final Object value = values.remove("ExchangeRateDate");
                if( (value == null) || (!value.equals(getExchangeRateDate())) ) {
                    setExchangeRateDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ControllingDocumentStatus") ) {
                final Object value = values.remove("ControllingDocumentStatus");
                if( (value == null) || (!value.equals(getControllingDocumentStatus())) ) {
                    setControllingDocumentStatus(((String) value));
                }
            }
            if( values.containsKey("StatusName") ) {
                final Object value = values.remove("StatusName");
                if( (value == null) || (!value.equals(getStatusName())) ) {
                    setStatusName(((String) value));
                }
            }
            if( values.containsKey("AllocationPostingType") ) {
                final Object value = values.remove("AllocationPostingType");
                if( (value == null) || (!value.equals(getAllocationPostingType())) ) {
                    setAllocationPostingType(((String) value));
                }
            }
            if( values.containsKey("AllocationPostingTypeText") ) {
                final Object value = values.remove("AllocationPostingTypeText");
                if( (value == null) || (!value.equals(getAllocationPostingTypeText())) ) {
                    setAllocationPostingTypeText(((String) value));
                }
            }
            if( values.containsKey("ReversalReferenceDocument") ) {
                final Object value = values.remove("ReversalReferenceDocument");
                if( (value == null) || (!value.equals(getReversalReferenceDocument())) ) {
                    setReversalReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("ReversedReferenceDocument") ) {
                final Object value = values.remove("ReversedReferenceDocument");
                if( (value == null) || (!value.equals(getReversedReferenceDocument())) ) {
                    setReversedReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("CostRevenueReassignmentType") ) {
                final Object value = values.remove("CostRevenueReassignmentType");
                if( (value == null) || (!value.equals(getCostRevenueReassignmentType())) ) {
                    setCostRevenueReassignmentType(((String) value));
                }
            }
            if( values.containsKey("CostRevnReassignmentTypeName") ) {
                final Object value = values.remove("CostRevnReassignmentTypeName");
                if( (value == null) || (!value.equals(getCostRevnReassignmentTypeName())) ) {
                    setCostRevnReassignmentTypeName(((String) value));
                }
            }
            if( values.containsKey("GlobalCurrency") ) {
                final Object value = values.remove("GlobalCurrency");
                if( (value == null) || (!value.equals(getGlobalCurrency())) ) {
                    setGlobalCurrency(((String) value));
                }
            }
            if( values.containsKey("TotalAmountInGlobalCurrency") ) {
                final Object value = values.remove("TotalAmountInGlobalCurrency");
                if( (value == null) || (!value.equals(getTotalAmountInGlobalCurrency())) ) {
                    setTotalAmountInGlobalCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("WarningsAreIgnored") ) {
                final Object value = values.remove("WarningsAreIgnored");
                if( (value == null) || (!value.equals(getWarningsAreIgnored())) ) {
                    setWarningsAreIgnored(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Item") ) {
                final Object value = (values).remove("to_Item");
                if( value instanceof Iterable ) {
                    if( toItem == null ) {
                        toItem = Lists.newArrayList();
                    } else {
                        toItem = Lists.newArrayList(toItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CostRevenueReassignmentItem entity;
                        if( toItem.size() > i ) {
                            entity = toItem.get(i);
                        } else {
                            entity = new CostRevenueReassignmentItem();
                            toItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CostRevenueReassignmentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CostRevenueReassignmentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CostRevenueReassignmentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CostRevenueReassignmentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostControllingJournalEntryService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toItem != null ) {
            (values).put("to_Item", toItem);
        }
        return values;
    }

    /**
     * Fetches the <b>CostRevenueReassignmentItem</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_Item</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CostRevenueReassignmentItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CostRevenueReassignmentItem> fetchItem()
    {
        return fetchFieldAsList("to_Item", CostRevenueReassignmentItem.class);
    }

    /**
     * Retrieval of associated <b>CostRevenueReassignmentItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>CostRevenueReassignment</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CostRevenueReassignmentItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CostRevenueReassignmentItem> getItemOrFetch()
    {
        if( toItem == null ) {
            toItem = fetchItem();
        }
        return toItem;
    }

    /**
     * Retrieval of associated <b>CostRevenueReassignmentItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property for an entity <b>CostRevenueReassignment</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Item</b> is already loaded, the result will contain the
     *         <b>CostRevenueReassignmentItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CostRevenueReassignmentItem>> getItemIfPresent()
    {
        return Option.of(toItem);
    }

    /**
     * Overwrites the list of associated <b>CostRevenueReassignmentItem</b> entities for the loaded navigation property
     * <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>CostRevenueReassignment</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CostRevenueReassignmentItem</b> entities.
     */
    public void setItem( @Nonnull final List<CostRevenueReassignmentItem> value )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.clear();
        toItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CostRevenueReassignmentItem</b> entities. This corresponds to the
     * OData navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>CostRevenueReassignment</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CostRevenueReassignmentItem</b> entities.
     */
    public void addItem( CostRevenueReassignmentItem... entity )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CostRevenueReassignment instances.
     *
     */
    public final static class CostRevenueReassignmentBuilder
    {

        private List<CostRevenueReassignmentItem> toItem = Lists.newArrayList();

        private CostRevenueReassignment.CostRevenueReassignmentBuilder toItem(
            final List<CostRevenueReassignmentItem> value )
        {
            toItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Item</b> for <b>CostRevenueReassignment</b> to multiple
         * <b>CostRevenueReassignmentItem</b>.
         *
         * @param value
         *            The CostRevenueReassignmentItems to build this CostRevenueReassignment with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CostRevenueReassignment.CostRevenueReassignmentBuilder item( CostRevenueReassignmentItem... value )
        {
            return toItem(Lists.newArrayList(value));
        }

    }

}
