/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.selectable.CostRevenueReassignmentSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment
 * CostRevenueReassignment} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class CostRevenueReassignmentByKeyFluentHelper
    extends
    FluentHelperByKey<CostRevenueReassignmentByKeyFluentHelper, CostRevenueReassignment, CostRevenueReassignmentSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment
     * CostRevenueReassignment} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CostRevenueReassignment}
     * @param servicePath
     *            Service path to be used to fetch a single {@code CostRevenueReassignment}
     * @param referenceDocument
     *            Reference document number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param controllingArea
     *            Controlling Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public CostRevenueReassignmentByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String fiscalYear,
        final String referenceDocument,
        final String controllingArea )
    {
        super(servicePath, entityCollection);
        this.key.put("FiscalYear", fiscalYear);
        this.key.put("ReferenceDocument", referenceDocument);
        this.key.put("ControllingArea", controllingArea);
    }

    @Override
    @Nonnull
    protected Class<CostRevenueReassignment> getEntityClass()
    {
        return CostRevenueReassignment.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
