/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.field.CostRevenueReassignmentItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.link.CostRevenueReassignmentItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.selectable.CostRevenueReassignmentItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Cost Reassignment Items
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CostRevenueReassignmentItem_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CostRevenueReassignmentItem extends VdmEntity<CostRevenueReassignmentItem>
{

    /**
     * Selector for all available fields of CostRevenueReassignmentItem.
     *
     */
    public final static CostRevenueReassignmentItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @Key
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> FISCAL_YEAR =
        new CostRevenueReassignmentItemField<String>("FiscalYear");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocument</b>
     * </p>
     *
     * @return Reference Document Number
     */
    @Key
    @SerializedName( "ReferenceDocument" )
    @JsonProperty( "ReferenceDocument" )
    @Nullable
    @ODataField( odataName = "ReferenceDocument" )
    private String referenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocument</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> REFERENCE_DOCUMENT =
        new CostRevenueReassignmentItemField<String>("ReferenceDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> CONTROLLING_AREA =
        new CostRevenueReassignmentItemField<String>("ControllingArea");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Receiver Company Code
     */
    @Key
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> COMPANY_CODE =
        new CostRevenueReassignmentItemField<String>("CompanyCode");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LedgerGLLineItem</b>
     * </p>
     *
     * @return Ledger Journal Entry Item
     */
    @Key
    @SerializedName( "LedgerGLLineItem" )
    @JsonProperty( "LedgerGLLineItem" )
    @Nullable
    @ODataField( odataName = "LedgerGLLineItem" )
    private String ledgerGLLineItem;
    /**
     * Use with available fluent helpers to apply the <b>LedgerGLLineItem</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> LEDGER_GL_LINE_ITEM =
        new CostRevenueReassignmentItemField<String>("LedgerGLLineItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentItem</b>
     * </p>
     *
     * @return Reference Document Item
     */
    @Key
    @SerializedName( "ReferenceDocumentItem" )
    @JsonProperty( "ReferenceDocumentItem" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentItem" )
    private String referenceDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentItem</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> REFERENCE_DOCUMENT_ITEM =
        new CostRevenueReassignmentItemField<String>("ReferenceDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocument</b>
     * </p>
     *
     * @return Journal Entry
     */
    @SerializedName( "AccountingDocument" )
    @JsonProperty( "AccountingDocument" )
    @Nullable
    @ODataField( odataName = "AccountingDocument" )
    private String accountingDocument;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocument</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> ACCOUNTING_DOCUMENT =
        new CostRevenueReassignmentItemField<String>("AccountingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SourceLedger</b>
     * </p>
     *
     * @return Source Ledger
     */
    @SerializedName( "SourceLedger" )
    @JsonProperty( "SourceLedger" )
    @Nullable
    @ODataField( odataName = "SourceLedger" )
    private String sourceLedger;
    /**
     * Use with available fluent helpers to apply the <b>SourceLedger</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> SOURCE_LEDGER =
        new CostRevenueReassignmentItemField<String>("SourceLedger");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>DocumentItemText</b>
     * </p>
     *
     * @return Item Text
     */
    @SerializedName( "DocumentItemText" )
    @JsonProperty( "DocumentItemText" )
    @Nullable
    @ODataField( odataName = "DocumentItemText" )
    private String documentItemText;
    /**
     * Use with available fluent helpers to apply the <b>DocumentItemText</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> DOCUMENT_ITEM_TEXT =
        new CostRevenueReassignmentItemField<String>("DocumentItemText");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return Account for Allocation
     */
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> GL_ACCOUNT =
        new CostRevenueReassignmentItemField<String>("GLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonnelNumber</b>
     * </p>
     *
     * @return Personnel Number
     */
    @SerializedName( "PersonnelNumber" )
    @JsonProperty( "PersonnelNumber" )
    @Nullable
    @ODataField( odataName = "PersonnelNumber" )
    private String personnelNumber;
    /**
     * Use with available fluent helpers to apply the <b>PersonnelNumber</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> PERSONNEL_NUMBER =
        new CostRevenueReassignmentItemField<String>("PersonnelNumber");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentType</b>
     * </p>
     *
     * @return Object Type
     */
    @SerializedName( "AccountAssignmentType" )
    @JsonProperty( "AccountAssignmentType" )
    @Nullable
    @ODataField( odataName = "AccountAssignmentType" )
    private String accountAssignmentType;
    /**
     * Use with available fluent helpers to apply the <b>AccountAssignmentType</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> ACCOUNT_ASSIGNMENT_TYPE =
        new CostRevenueReassignmentItemField<String>("AccountAssignmentType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerAccountAssignmentType</b>
     * </p>
     *
     * @return Receiver Object Type
     */
    @SerializedName( "PartnerAccountAssignmentType" )
    @JsonProperty( "PartnerAccountAssignmentType" )
    @Nullable
    @ODataField( odataName = "PartnerAccountAssignmentType" )
    private String partnerAccountAssignmentType;
    /**
     * Use with available fluent helpers to apply the <b>PartnerAccountAssignmentType</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> PARTNER_ACCOUNT_ASSIGNMENT_TYPE =
        new CostRevenueReassignmentItemField<String>("PartnerAccountAssignmentType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OriginCostCenter</b>
     * </p>
     *
     * @return Sender Cost Center
     */
    @SerializedName( "OriginCostCenter" )
    @JsonProperty( "OriginCostCenter" )
    @Nullable
    @ODataField( odataName = "OriginCostCenter" )
    private String originCostCenter;
    /**
     * Use with available fluent helpers to apply the <b>OriginCostCenter</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> ORIGIN_COST_CENTER =
        new CostRevenueReassignmentItemField<String>("OriginCostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCenter</b>
     * </p>
     *
     * @return Partner Cost Center
     */
    @SerializedName( "PartnerCostCenter" )
    @JsonProperty( "PartnerCostCenter" )
    @Nullable
    @ODataField( odataName = "PartnerCostCenter" )
    private String partnerCostCenter;
    /**
     * Use with available fluent helpers to apply the <b>PartnerCostCenter</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> PARTNER_COST_CENTER =
        new CostRevenueReassignmentItemField<String>("PartnerCostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElementInternalID</b>
     * </p>
     *
     * @return Partner WBS Element Internal ID
     */
    @SerializedName( "PartnerWBSElementInternalID" )
    @JsonProperty( "PartnerWBSElementInternalID" )
    @Nullable
    @ODataField( odataName = "PartnerWBSElementInternalID" )
    private String partnerWBSElementInternalID;
    /**
     * Use with available fluent helpers to apply the <b>PartnerWBSElementInternalID</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> PARTNER_WBS_ELEMENT_INTERNAL_ID =
        new CostRevenueReassignmentItemField<String>("PartnerWBSElementInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @return WBS Element Internal ID
     */
    @SerializedName( "WBSElementInternalID" )
    @JsonProperty( "WBSElementInternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementInternalID" )
    private String wBSElementInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementInternalID</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> WBS_ELEMENT_INTERNAL_ID =
        new CostRevenueReassignmentItemField<String>("WBSElementInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElementExternalID</b>
     * </p>
     *
     * @return Partner WBS Element External ID
     */
    @SerializedName( "PartnerWBSElementExternalID" )
    @JsonProperty( "PartnerWBSElementExternalID" )
    @Nullable
    @ODataField( odataName = "PartnerWBSElementExternalID" )
    private String partnerWBSElementExternalID;
    /**
     * Use with available fluent helpers to apply the <b>PartnerWBSElementExternalID</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> PARTNER_WBS_ELEMENT_EXTERNAL_ID =
        new CostRevenueReassignmentItemField<String>("PartnerWBSElementExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @return WBS Element External ID
     */
    @SerializedName( "WBSElementExternalID" )
    @JsonProperty( "WBSElementExternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementExternalID" )
    private String wBSElementExternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementExternalID</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> WBS_ELEMENT_EXTERNAL_ID =
        new CostRevenueReassignmentItemField<String>("WBSElementExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerServiceDocumentType</b>
     * </p>
     *
     * @return Partner Service Document Type
     */
    @SerializedName( "PartnerServiceDocumentType" )
    @JsonProperty( "PartnerServiceDocumentType" )
    @Nullable
    @ODataField( odataName = "PartnerServiceDocumentType" )
    private String partnerServiceDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>PartnerServiceDocumentType</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> PARTNER_SERVICE_DOCUMENT_TYPE =
        new CostRevenueReassignmentItemField<String>("PartnerServiceDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerServiceDocument</b>
     * </p>
     *
     * @return Partner Service Document ID
     */
    @SerializedName( "PartnerServiceDocument" )
    @JsonProperty( "PartnerServiceDocument" )
    @Nullable
    @ODataField( odataName = "PartnerServiceDocument" )
    private String partnerServiceDocument;
    /**
     * Use with available fluent helpers to apply the <b>PartnerServiceDocument</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> PARTNER_SERVICE_DOCUMENT =
        new CostRevenueReassignmentItemField<String>("PartnerServiceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerServiceDocumentItem</b>
     * </p>
     *
     * @return Partner Service Document Item ID
     */
    @SerializedName( "PartnerServiceDocumentItem" )
    @JsonProperty( "PartnerServiceDocumentItem" )
    @Nullable
    @ODataField( odataName = "PartnerServiceDocumentItem" )
    private String partnerServiceDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PartnerServiceDocumentItem</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> PARTNER_SERVICE_DOCUMENT_ITEM =
        new CostRevenueReassignmentItemField<String>("PartnerServiceDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentType</b>
     * </p>
     *
     * @return Service Document Type
     */
    @SerializedName( "ServiceDocumentType" )
    @JsonProperty( "ServiceDocumentType" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentType" )
    private String serviceDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentType</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> SERVICE_DOCUMENT_TYPE =
        new CostRevenueReassignmentItemField<String>("ServiceDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocument</b>
     * </p>
     *
     * @return Service Document ID
     */
    @SerializedName( "ServiceDocument" )
    @JsonProperty( "ServiceDocument" )
    @Nullable
    @ODataField( odataName = "ServiceDocument" )
    private String serviceDocument;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocument</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> SERVICE_DOCUMENT =
        new CostRevenueReassignmentItemField<String>("ServiceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItem</b>
     * </p>
     *
     * @return Service Document Item ID
     */
    @SerializedName( "ServiceDocumentItem" )
    @JsonProperty( "ServiceDocumentItem" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentItem" )
    private String serviceDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentItem</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> SERVICE_DOCUMENT_ITEM =
        new CostRevenueReassignmentItemField<String>("ServiceDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerOrder</b>
     * </p>
     *
     * @return Partner Order
     */
    @SerializedName( "PartnerOrder" )
    @JsonProperty( "PartnerOrder" )
    @Nullable
    @ODataField( odataName = "PartnerOrder" )
    private String partnerOrder;
    /**
     * Use with available fluent helpers to apply the <b>PartnerOrder</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> PARTNER_ORDER =
        new CostRevenueReassignmentItemField<String>("PartnerOrder");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @return Order ID
     */
    @SerializedName( "OrderID" )
    @JsonProperty( "OrderID" )
    @Nullable
    @ODataField( odataName = "OrderID" )
    private String orderID;
    /**
     * Use with available fluent helpers to apply the <b>OrderID</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> ORDER_ID =
        new CostRevenueReassignmentItemField<String>("OrderID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SenderCompanyCode</b>
     * </p>
     *
     * @return Sender Company Code
     */
    @SerializedName( "SenderCompanyCode" )
    @JsonProperty( "SenderCompanyCode" )
    @Nullable
    @ODataField( odataName = "SenderCompanyCode" )
    private String senderCompanyCode;
    /**
     * Use with available fluent helpers to apply the <b>SenderCompanyCode</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> SENDER_COMPANY_CODE =
        new CostRevenueReassignmentItemField<String>("SenderCompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocument</b>
     * </p>
     *
     * @return Partner Sales Document
     */
    @SerializedName( "PartnerSalesDocument" )
    @JsonProperty( "PartnerSalesDocument" )
    @Nullable
    @ODataField( odataName = "PartnerSalesDocument" )
    private String partnerSalesDocument;
    /**
     * Use with available fluent helpers to apply the <b>PartnerSalesDocument</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> PARTNER_SALES_DOCUMENT =
        new CostRevenueReassignmentItemField<String>("PartnerSalesDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocumentItem</b>
     * </p>
     *
     * @return Partner Sales Document Item
     */
    @SerializedName( "PartnerSalesDocumentItem" )
    @JsonProperty( "PartnerSalesDocumentItem" )
    @Nullable
    @ODataField( odataName = "PartnerSalesDocumentItem" )
    private String partnerSalesDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PartnerSalesDocumentItem</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> PARTNER_SALES_DOCUMENT_ITEM =
        new CostRevenueReassignmentItemField<String>("PartnerSalesDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocument</b>
     * </p>
     *
     * @return Sales Document
     */
    @SerializedName( "SalesDocument" )
    @JsonProperty( "SalesDocument" )
    @Nullable
    @ODataField( odataName = "SalesDocument" )
    private String salesDocument;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocument</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> SALES_DOCUMENT =
        new CostRevenueReassignmentItemField<String>("SalesDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItem</b>
     * </p>
     *
     * @return Sales Document Item
     */
    @SerializedName( "SalesDocumentItem" )
    @JsonProperty( "SalesDocumentItem" )
    @Nullable
    @ODataField( odataName = "SalesDocumentItem" )
    private String salesDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentItem</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> SALES_DOCUMENT_ITEM =
        new CostRevenueReassignmentItemField<String>("SalesDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureCostRecoveryCode</b>
     * </p>
     *
     * @return Joint Venture Cost Recovery Code
     */
    @SerializedName( "JointVentureCostRecoveryCode" )
    @JsonProperty( "JointVentureCostRecoveryCode" )
    @Nullable
    @ODataField( odataName = "JointVentureCostRecoveryCode" )
    private String jointVentureCostRecoveryCode;
    /**
     * Use with available fluent helpers to apply the <b>JointVentureCostRecoveryCode</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> JOINT_VENTURE_COST_RECOVERY_CODE =
        new CostRevenueReassignmentItemField<String>("JointVentureCostRecoveryCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SenderCostRecoveryCode</b>
     * </p>
     *
     * @return Sender Cost Recovery Code
     */
    @SerializedName( "SenderCostRecoveryCode" )
    @JsonProperty( "SenderCostRecoveryCode" )
    @Nullable
    @ODataField( odataName = "SenderCostRecoveryCode" )
    private String senderCostRecoveryCode;
    /**
     * Use with available fluent helpers to apply the <b>SenderCostRecoveryCode</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> SENDER_COST_RECOVERY_CODE =
        new CostRevenueReassignmentItemField<String>("SenderCostRecoveryCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @return Sender fund
     */
    @SerializedName( "Fund" )
    @JsonProperty( "Fund" )
    @Nullable
    @ODataField( odataName = "Fund" )
    private String fund;
    /**
     * Use with available fluent helpers to apply the <b>Fund</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> FUND =
        new CostRevenueReassignmentItemField<String>("Fund");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Sender Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> FUNCTIONAL_AREA =
        new CostRevenueReassignmentItemField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @return Sender Grant
     */
    @SerializedName( "GrantID" )
    @JsonProperty( "GrantID" )
    @Nullable
    @ODataField( odataName = "GrantID" )
    private String grantID;
    /**
     * Use with available fluent helpers to apply the <b>GrantID</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> GRANT_ID =
        new CostRevenueReassignmentItemField<String>("GrantID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @return Budget Period
     */
    @SerializedName( "BudgetPeriod" )
    @JsonProperty( "BudgetPeriod" )
    @Nullable
    @ODataField( odataName = "BudgetPeriod" )
    private String budgetPeriod;
    /**
     * Use with available fluent helpers to apply the <b>BudgetPeriod</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> BUDGET_PERIOD =
        new CostRevenueReassignmentItemField<String>("BudgetPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFund</b>
     * </p>
     *
     * @return Receiver Fund
     */
    @SerializedName( "PartnerFund" )
    @JsonProperty( "PartnerFund" )
    @Nullable
    @ODataField( odataName = "PartnerFund" )
    private String partnerFund;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFund</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> PARTNER_FUND =
        new CostRevenueReassignmentItemField<String>("PartnerFund");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalArea</b>
     * </p>
     *
     * @return Receiver Functional Area
     */
    @SerializedName( "PartnerFunctionalArea" )
    @JsonProperty( "PartnerFunctionalArea" )
    @Nullable
    @ODataField( odataName = "PartnerFunctionalArea" )
    private String partnerFunctionalArea;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunctionalArea</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> PARTNER_FUNCTIONAL_AREA =
        new CostRevenueReassignmentItemField<String>("PartnerFunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PartnerGrant</b>
     * </p>
     *
     * @return Receiver Grant
     */
    @SerializedName( "PartnerGrant" )
    @JsonProperty( "PartnerGrant" )
    @Nullable
    @ODataField( odataName = "PartnerGrant" )
    private String partnerGrant;
    /**
     * Use with available fluent helpers to apply the <b>PartnerGrant</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> PARTNER_GRANT =
        new CostRevenueReassignmentItemField<String>("PartnerGrant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBudgetPeriod</b>
     * </p>
     *
     * @return FM: Partner Budget Period
     */
    @SerializedName( "PartnerBudgetPeriod" )
    @JsonProperty( "PartnerBudgetPeriod" )
    @Nullable
    @ODataField( odataName = "PartnerBudgetPeriod" )
    private String partnerBudgetPeriod;
    /**
     * Use with available fluent helpers to apply the <b>PartnerBudgetPeriod</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> PARTNER_BUDGET_PERIOD =
        new CostRevenueReassignmentItemField<String>("PartnerBudgetPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     *
     * @return Financial Management Area
     */
    @SerializedName( "FinancialManagementArea" )
    @JsonProperty( "FinancialManagementArea" )
    @Nullable
    @ODataField( odataName = "FinancialManagementArea" )
    private String financialManagementArea;
    /**
     * Use with available fluent helpers to apply the <b>FinancialManagementArea</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> FINANCIAL_MANAGEMENT_AREA =
        new CostRevenueReassignmentItemField<String>("FinancialManagementArea");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RcvrAcctgIndCode</b>
     * </p>
     *
     * @return Receiver Accounting Indicator
     */
    @SerializedName( "RcvrAcctgIndCode" )
    @JsonProperty( "RcvrAcctgIndCode" )
    @Nullable
    @ODataField( odataName = "RcvrAcctgIndCode" )
    private String rcvrAcctgIndCode;
    /**
     * Use with available fluent helpers to apply the <b>RcvrAcctgIndCode</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> RCVR_ACCTG_IND_CODE =
        new CostRevenueReassignmentItemField<String>("RcvrAcctgIndCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillableControl</b>
     * </p>
     *
     * @return Accounting Indicator
     */
    @SerializedName( "BillableControl" )
    @JsonProperty( "BillableControl" )
    @Nullable
    @ODataField( odataName = "BillableControl" )
    private String billableControl;
    /**
     * Use with available fluent helpers to apply the <b>BillableControl</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> BILLABLE_CONTROL =
        new CostRevenueReassignmentItemField<String>("BillableControl");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperatingConcern</b>
     * </p>
     *
     * @return Operating Concern
     */
    @SerializedName( "OperatingConcern" )
    @JsonProperty( "OperatingConcern" )
    @Nullable
    @ODataField( odataName = "OperatingConcern" )
    private String operatingConcern;
    /**
     * Use with available fluent helpers to apply the <b>OperatingConcern</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> OPERATING_CONCERN =
        new CostRevenueReassignmentItemField<String>("OperatingConcern");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @return Base Unit of Measure
     */
    @SerializedName( "BaseUnit" )
    @JsonProperty( "BaseUnit" )
    @Nullable
    @ODataField( odataName = "BaseUnit" )
    private String baseUnit;
    /**
     * Use with available fluent helpers to apply the <b>BaseUnit</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> BASE_UNIT =
        new CostRevenueReassignmentItemField<String>("BaseUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @return Activity Quantity
     */
    @SerializedName( "Quantity" )
    @JsonProperty( "Quantity" )
    @Nullable
    @ODataField( odataName = "Quantity" )
    private BigDecimal quantity;
    /**
     * Use with available fluent helpers to apply the <b>Quantity</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<BigDecimal> QUANTITY =
        new CostRevenueReassignmentItemField<BigDecimal>("Quantity");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Transaction Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> TRANSACTION_CURRENCY =
        new CostRevenueReassignmentItemField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInTransactionCurrency</b>
     * </p>
     *
     * @return Amount in Transaction Currency
     */
    @SerializedName( "AmountInTransactionCurrency" )
    @JsonProperty( "AmountInTransactionCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInTransactionCurrency" )
    private BigDecimal amountInTransactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInTransactionCurrency</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<BigDecimal> AMOUNT_IN_TRANSACTION_CURRENCY =
        new CostRevenueReassignmentItemField<BigDecimal>("AmountInTransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @return Company Code Currency
     */
    @SerializedName( "CompanyCodeCurrency" )
    @JsonProperty( "CompanyCodeCurrency" )
    @Nullable
    @ODataField( odataName = "CompanyCodeCurrency" )
    private String companyCodeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeCurrency</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> COMPANY_CODE_CURRENCY =
        new CostRevenueReassignmentItemField<String>("CompanyCodeCurrency");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInCompanyCodeCurrency</b>
     * </p>
     *
     * @return Amount in Company Code Currency
     */
    @SerializedName( "AmountInCompanyCodeCurrency" )
    @JsonProperty( "AmountInCompanyCodeCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInCompanyCodeCurrency" )
    private BigDecimal amountInCompanyCodeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInCompanyCodeCurrency</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<BigDecimal> AMOUNT_IN_COMPANY_CODE_CURRENCY =
        new CostRevenueReassignmentItemField<BigDecimal>("AmountInCompanyCodeCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GlobalCurrency</b>
     * </p>
     *
     * @return Global Currency
     */
    @SerializedName( "GlobalCurrency" )
    @JsonProperty( "GlobalCurrency" )
    @Nullable
    @ODataField( odataName = "GlobalCurrency" )
    private String globalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>GlobalCurrency</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> GLOBAL_CURRENCY =
        new CostRevenueReassignmentItemField<String>("GlobalCurrency");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInGlobalCurrency</b>
     * </p>
     *
     * @return Amount in Global Currency
     */
    @SerializedName( "AmountInGlobalCurrency" )
    @JsonProperty( "AmountInGlobalCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInGlobalCurrency" )
    private BigDecimal amountInGlobalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInGlobalCurrency</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<BigDecimal> AMOUNT_IN_GLOBAL_CURRENCY =
        new CostRevenueReassignmentItemField<BigDecimal>("AmountInGlobalCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency1</b>
     * </p>
     *
     * @return Freely Defined Currency 1
     */
    @SerializedName( "FreeDefinedCurrency1" )
    @JsonProperty( "FreeDefinedCurrency1" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency1" )
    private String freeDefinedCurrency1;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency1</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> FREE_DEFINED_CURRENCY1 =
        new CostRevenueReassignmentItemField<String>("FreeDefinedCurrency1");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency1</b>
     * </p>
     *
     * @return Amount in Freely Defined Currency 1
     */
    @SerializedName( "AmountInFreeDefinedCurrency1" )
    @JsonProperty( "AmountInFreeDefinedCurrency1" )
    @Nullable
    @ODataField( odataName = "AmountInFreeDefinedCurrency1" )
    private BigDecimal amountInFreeDefinedCurrency1;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFreeDefinedCurrency1</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<BigDecimal> AMOUNT_IN_FREE_DEFINED_CURRENCY1 =
        new CostRevenueReassignmentItemField<BigDecimal>("AmountInFreeDefinedCurrency1");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency2</b>
     * </p>
     *
     * @return Freely Defined Currency 2
     */
    @SerializedName( "FreeDefinedCurrency2" )
    @JsonProperty( "FreeDefinedCurrency2" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency2" )
    private String freeDefinedCurrency2;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency2</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> FREE_DEFINED_CURRENCY2 =
        new CostRevenueReassignmentItemField<String>("FreeDefinedCurrency2");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency2</b>
     * </p>
     *
     * @return Amount in Freely Defined Currency 2
     */
    @SerializedName( "AmountInFreeDefinedCurrency2" )
    @JsonProperty( "AmountInFreeDefinedCurrency2" )
    @Nullable
    @ODataField( odataName = "AmountInFreeDefinedCurrency2" )
    private BigDecimal amountInFreeDefinedCurrency2;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFreeDefinedCurrency2</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<BigDecimal> AMOUNT_IN_FREE_DEFINED_CURRENCY2 =
        new CostRevenueReassignmentItemField<BigDecimal>("AmountInFreeDefinedCurrency2");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency3</b>
     * </p>
     *
     * @return Freely Defined Currency 3
     */
    @SerializedName( "FreeDefinedCurrency3" )
    @JsonProperty( "FreeDefinedCurrency3" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency3" )
    private String freeDefinedCurrency3;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency3</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> FREE_DEFINED_CURRENCY3 =
        new CostRevenueReassignmentItemField<String>("FreeDefinedCurrency3");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency3</b>
     * </p>
     *
     * @return Amount in Freely Defined Currency 3
     */
    @SerializedName( "AmountInFreeDefinedCurrency3" )
    @JsonProperty( "AmountInFreeDefinedCurrency3" )
    @Nullable
    @ODataField( odataName = "AmountInFreeDefinedCurrency3" )
    private BigDecimal amountInFreeDefinedCurrency3;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFreeDefinedCurrency3</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<BigDecimal> AMOUNT_IN_FREE_DEFINED_CURRENCY3 =
        new CostRevenueReassignmentItemField<BigDecimal>("AmountInFreeDefinedCurrency3");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency4</b>
     * </p>
     *
     * @return Freely Defined Currency 4
     */
    @SerializedName( "FreeDefinedCurrency4" )
    @JsonProperty( "FreeDefinedCurrency4" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency4" )
    private String freeDefinedCurrency4;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency4</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> FREE_DEFINED_CURRENCY4 =
        new CostRevenueReassignmentItemField<String>("FreeDefinedCurrency4");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency4</b>
     * </p>
     *
     * @return Amount in Freely Defined Currency 4
     */
    @SerializedName( "AmountInFreeDefinedCurrency4" )
    @JsonProperty( "AmountInFreeDefinedCurrency4" )
    @Nullable
    @ODataField( odataName = "AmountInFreeDefinedCurrency4" )
    private BigDecimal amountInFreeDefinedCurrency4;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFreeDefinedCurrency4</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<BigDecimal> AMOUNT_IN_FREE_DEFINED_CURRENCY4 =
        new CostRevenueReassignmentItemField<BigDecimal>("AmountInFreeDefinedCurrency4");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency5</b>
     * </p>
     *
     * @return Freely Defined Currency 5
     */
    @SerializedName( "FreeDefinedCurrency5" )
    @JsonProperty( "FreeDefinedCurrency5" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency5" )
    private String freeDefinedCurrency5;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency5</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> FREE_DEFINED_CURRENCY5 =
        new CostRevenueReassignmentItemField<String>("FreeDefinedCurrency5");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency5</b>
     * </p>
     *
     * @return Amount in Freely Defined Currency 5
     */
    @SerializedName( "AmountInFreeDefinedCurrency5" )
    @JsonProperty( "AmountInFreeDefinedCurrency5" )
    @Nullable
    @ODataField( odataName = "AmountInFreeDefinedCurrency5" )
    private BigDecimal amountInFreeDefinedCurrency5;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFreeDefinedCurrency5</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<BigDecimal> AMOUNT_IN_FREE_DEFINED_CURRENCY5 =
        new CostRevenueReassignmentItemField<BigDecimal>("AmountInFreeDefinedCurrency5");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency6</b>
     * </p>
     *
     * @return Freely Defined Currency 6
     */
    @SerializedName( "FreeDefinedCurrency6" )
    @JsonProperty( "FreeDefinedCurrency6" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency6" )
    private String freeDefinedCurrency6;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency6</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> FREE_DEFINED_CURRENCY6 =
        new CostRevenueReassignmentItemField<String>("FreeDefinedCurrency6");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency6</b>
     * </p>
     *
     * @return Amount in Freely Defined Currency 6
     */
    @SerializedName( "AmountInFreeDefinedCurrency6" )
    @JsonProperty( "AmountInFreeDefinedCurrency6" )
    @Nullable
    @ODataField( odataName = "AmountInFreeDefinedCurrency6" )
    private BigDecimal amountInFreeDefinedCurrency6;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFreeDefinedCurrency6</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<BigDecimal> AMOUNT_IN_FREE_DEFINED_CURRENCY6 =
        new CostRevenueReassignmentItemField<BigDecimal>("AmountInFreeDefinedCurrency6");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency7</b>
     * </p>
     *
     * @return Freely Defined Currency 7
     */
    @SerializedName( "FreeDefinedCurrency7" )
    @JsonProperty( "FreeDefinedCurrency7" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency7" )
    private String freeDefinedCurrency7;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency7</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> FREE_DEFINED_CURRENCY7 =
        new CostRevenueReassignmentItemField<String>("FreeDefinedCurrency7");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency7</b>
     * </p>
     *
     * @return Amount in Freely Defined Currency 7
     */
    @SerializedName( "AmountInFreeDefinedCurrency7" )
    @JsonProperty( "AmountInFreeDefinedCurrency7" )
    @Nullable
    @ODataField( odataName = "AmountInFreeDefinedCurrency7" )
    private BigDecimal amountInFreeDefinedCurrency7;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFreeDefinedCurrency7</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<BigDecimal> AMOUNT_IN_FREE_DEFINED_CURRENCY7 =
        new CostRevenueReassignmentItemField<BigDecimal>("AmountInFreeDefinedCurrency7");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency8</b>
     * </p>
     *
     * @return Freely Defined Currency 8
     */
    @SerializedName( "FreeDefinedCurrency8" )
    @JsonProperty( "FreeDefinedCurrency8" )
    @Nullable
    @ODataField( odataName = "FreeDefinedCurrency8" )
    private String freeDefinedCurrency8;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedCurrency8</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> FREE_DEFINED_CURRENCY8 =
        new CostRevenueReassignmentItemField<String>("FreeDefinedCurrency8");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency8</b>
     * </p>
     *
     * @return Amount in Freely Defined Currency 8
     */
    @SerializedName( "AmountInFreeDefinedCurrency8" )
    @JsonProperty( "AmountInFreeDefinedCurrency8" )
    @Nullable
    @ODataField( odataName = "AmountInFreeDefinedCurrency8" )
    private BigDecimal amountInFreeDefinedCurrency8;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFreeDefinedCurrency8</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<BigDecimal> AMOUNT_IN_FREE_DEFINED_CURRENCY8 =
        new CostRevenueReassignmentItemField<BigDecimal>("AmountInFreeDefinedCurrency8");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalCurrency</b>
     * </p>
     *
     * @return Functional Currency
     */
    @SerializedName( "FunctionalCurrency" )
    @JsonProperty( "FunctionalCurrency" )
    @Nullable
    @ODataField( odataName = "FunctionalCurrency" )
    private String functionalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalCurrency</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> FUNCTIONAL_CURRENCY =
        new CostRevenueReassignmentItemField<String>("FunctionalCurrency");
    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFunctionalCurrency</b>
     * </p>
     *
     * @return Amount in Functional Currency
     */
    @SerializedName( "AmountInFunctionalCurrency" )
    @JsonProperty( "AmountInFunctionalCurrency" )
    @Nullable
    @ODataField( odataName = "AmountInFunctionalCurrency" )
    private BigDecimal amountInFunctionalCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AmountInFunctionalCurrency</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<BigDecimal> AMOUNT_IN_FUNCTIONAL_CURRENCY =
        new CostRevenueReassignmentItemField<BigDecimal>("AmountInFunctionalCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReceiverRECompanyCode</b>
     * </p>
     *
     * @return Company code of partner
     */
    @SerializedName( "ReceiverRECompanyCode" )
    @JsonProperty( "ReceiverRECompanyCode" )
    @Nullable
    @ODataField( odataName = "ReceiverRECompanyCode" )
    private String receiverRECompanyCode;
    /**
     * Use with available fluent helpers to apply the <b>ReceiverRECompanyCode</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> RECEIVER_RE_COMPANY_CODE =
        new CostRevenueReassignmentItemField<String>("ReceiverRECompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>RealEstatePartnerContract</b>
     * </p>
     *
     * @return Real Estate Partner Contract
     */
    @SerializedName( "RealEstatePartnerContract" )
    @JsonProperty( "RealEstatePartnerContract" )
    @Nullable
    @ODataField( odataName = "RealEstatePartnerContract" )
    private String realEstatePartnerContract;
    /**
     * Use with available fluent helpers to apply the <b>RealEstatePartnerContract</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> REAL_ESTATE_PARTNER_CONTRACT =
        new CostRevenueReassignmentItemField<String>("RealEstatePartnerContract");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SenderRECompanyCode</b>
     * </p>
     *
     * @return Company code of Real Estate objects to be sent
     */
    @SerializedName( "SenderRECompanyCode" )
    @JsonProperty( "SenderRECompanyCode" )
    @Nullable
    @ODataField( odataName = "SenderRECompanyCode" )
    private String senderRECompanyCode;
    /**
     * Use with available fluent helpers to apply the <b>SenderRECompanyCode</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> SENDER_RE_COMPANY_CODE =
        new CostRevenueReassignmentItemField<String>("SenderRECompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>RealEstateContract</b>
     * </p>
     *
     * @return Real Estate Contract
     */
    @SerializedName( "RealEstateContract" )
    @JsonProperty( "RealEstateContract" )
    @Nullable
    @ODataField( odataName = "RealEstateContract" )
    private String realEstateContract;
    /**
     * Use with available fluent helpers to apply the <b>RealEstateContract</b> field to query operations.
     *
     */
    public final static CostRevenueReassignmentItemField<String> REAL_ESTATE_CONTRACT =
        new CostRevenueReassignmentItemField<String>("RealEstateContract");
    /**
     * Navigation property <b>to_Header</b> for <b>CostRevenueReassignmentItem</b> to single
     * <b>CostRevenueReassignment</b>.
     *
     */
    @SerializedName( "to_Header" )
    @JsonProperty( "to_Header" )
    @ODataField( odataName = "to_Header" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CostRevenueReassignment toHeader;
    /**
     * Navigation property <b>to_ReceiverProfitabilitySegment</b> for <b>CostRevenueReassignmentItem</b> to single
     * <b>CostRevnRcvrPrftbltySegment</b>.
     *
     */
    @SerializedName( "to_ReceiverProfitabilitySegment" )
    @JsonProperty( "to_ReceiverProfitabilitySegment" )
    @ODataField( odataName = "to_ReceiverProfitabilitySegment" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CostRevnRcvrPrftbltySegment toReceiverProfitabilitySegment;
    /**
     * Navigation property <b>to_SenderProfitabilitySegment</b> for <b>CostRevenueReassignmentItem</b> to single
     * <b>CostRevnSndrPrftbltySegment</b>.
     *
     */
    @SerializedName( "to_SenderProfitabilitySegment" )
    @JsonProperty( "to_SenderProfitabilitySegment" )
    @ODataField( odataName = "to_SenderProfitabilitySegment" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CostRevnSndrPrftbltySegment toSenderProfitabilitySegment;
    /**
     * Use with available fluent helpers to apply the <b>to_Header</b> navigation property to query operations.
     *
     */
    public final static CostRevenueReassignmentItemOneToOneLink<CostRevenueReassignment> TO_HEADER =
        new CostRevenueReassignmentItemOneToOneLink<CostRevenueReassignment>("to_Header");
    /**
     * Use with available fluent helpers to apply the <b>to_ReceiverProfitabilitySegment</b> navigation property to
     * query operations.
     *
     */
    public final static CostRevenueReassignmentItemOneToOneLink<CostRevnRcvrPrftbltySegment> TO_RECEIVER_PROFITABILITY_SEGMENT =
        new CostRevenueReassignmentItemOneToOneLink<CostRevnRcvrPrftbltySegment>("to_ReceiverProfitabilitySegment");
    /**
     * Use with available fluent helpers to apply the <b>to_SenderProfitabilitySegment</b> navigation property to query
     * operations.
     *
     */
    public final static CostRevenueReassignmentItemOneToOneLink<CostRevnSndrPrftbltySegment> TO_SENDER_PROFITABILITY_SEGMENT =
        new CostRevenueReassignmentItemOneToOneLink<CostRevnSndrPrftbltySegment>("to_SenderProfitabilitySegment");

    @Nonnull
    @Override
    public Class<CostRevenueReassignmentItem> getType()
    {
        return CostRevenueReassignmentItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocument</b>
     * </p>
     *
     * @param referenceDocument
     *            Reference Document Number
     */
    public void setReferenceDocument( @Nullable final String referenceDocument )
    {
        rememberChangedField("ReferenceDocument", this.referenceDocument);
        this.referenceDocument = referenceDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Receiver Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LedgerGLLineItem</b>
     * </p>
     *
     * @param ledgerGLLineItem
     *            Ledger Journal Entry Item
     */
    public void setLedgerGLLineItem( @Nullable final String ledgerGLLineItem )
    {
        rememberChangedField("LedgerGLLineItem", this.ledgerGLLineItem);
        this.ledgerGLLineItem = ledgerGLLineItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentItem</b>
     * </p>
     *
     * @param referenceDocumentItem
     *            Reference Document Item
     */
    public void setReferenceDocumentItem( @Nullable final String referenceDocumentItem )
    {
        rememberChangedField("ReferenceDocumentItem", this.referenceDocumentItem);
        this.referenceDocumentItem = referenceDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocument</b>
     * </p>
     *
     * @param accountingDocument
     *            Journal Entry
     */
    public void setAccountingDocument( @Nullable final String accountingDocument )
    {
        rememberChangedField("AccountingDocument", this.accountingDocument);
        this.accountingDocument = accountingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SourceLedger</b>
     * </p>
     *
     * @param sourceLedger
     *            Source Ledger
     */
    public void setSourceLedger( @Nullable final String sourceLedger )
    {
        rememberChangedField("SourceLedger", this.sourceLedger);
        this.sourceLedger = sourceLedger;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>DocumentItemText</b>
     * </p>
     *
     * @param documentItemText
     *            Item Text
     */
    public void setDocumentItemText( @Nullable final String documentItemText )
    {
        rememberChangedField("DocumentItemText", this.documentItemText);
        this.documentItemText = documentItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            Account for Allocation
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonnelNumber</b>
     * </p>
     *
     * @param personnelNumber
     *            Personnel Number
     */
    public void setPersonnelNumber( @Nullable final String personnelNumber )
    {
        rememberChangedField("PersonnelNumber", this.personnelNumber);
        this.personnelNumber = personnelNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AccountAssignmentType</b>
     * </p>
     *
     * @param accountAssignmentType
     *            Object Type
     */
    public void setAccountAssignmentType( @Nullable final String accountAssignmentType )
    {
        rememberChangedField("AccountAssignmentType", this.accountAssignmentType);
        this.accountAssignmentType = accountAssignmentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerAccountAssignmentType</b>
     * </p>
     *
     * @param partnerAccountAssignmentType
     *            Receiver Object Type
     */
    public void setPartnerAccountAssignmentType( @Nullable final String partnerAccountAssignmentType )
    {
        rememberChangedField("PartnerAccountAssignmentType", this.partnerAccountAssignmentType);
        this.partnerAccountAssignmentType = partnerAccountAssignmentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>OriginCostCenter</b>
     * </p>
     *
     * @param originCostCenter
     *            Sender Cost Center
     */
    public void setOriginCostCenter( @Nullable final String originCostCenter )
    {
        rememberChangedField("OriginCostCenter", this.originCostCenter);
        this.originCostCenter = originCostCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerCostCenter</b>
     * </p>
     *
     * @param partnerCostCenter
     *            Partner Cost Center
     */
    public void setPartnerCostCenter( @Nullable final String partnerCostCenter )
    {
        rememberChangedField("PartnerCostCenter", this.partnerCostCenter);
        this.partnerCostCenter = partnerCostCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElementInternalID</b>
     * </p>
     *
     * @param partnerWBSElementInternalID
     *            Partner WBS Element Internal ID
     */
    public void setPartnerWBSElementInternalID( @Nullable final String partnerWBSElementInternalID )
    {
        rememberChangedField("PartnerWBSElementInternalID", this.partnerWBSElementInternalID);
        this.partnerWBSElementInternalID = partnerWBSElementInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @param wBSElementInternalID
     *            WBS Element Internal ID
     */
    public void setWBSElementInternalID( @Nullable final String wBSElementInternalID )
    {
        rememberChangedField("WBSElementInternalID", this.wBSElementInternalID);
        this.wBSElementInternalID = wBSElementInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>PartnerWBSElementExternalID</b>
     * </p>
     *
     * @param partnerWBSElementExternalID
     *            Partner WBS Element External ID
     */
    public void setPartnerWBSElementExternalID( @Nullable final String partnerWBSElementExternalID )
    {
        rememberChangedField("PartnerWBSElementExternalID", this.partnerWBSElementExternalID);
        this.partnerWBSElementExternalID = partnerWBSElementExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @param wBSElementExternalID
     *            WBS Element External ID
     */
    public void setWBSElementExternalID( @Nullable final String wBSElementExternalID )
    {
        rememberChangedField("WBSElementExternalID", this.wBSElementExternalID);
        this.wBSElementExternalID = wBSElementExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PartnerServiceDocumentType</b>
     * </p>
     *
     * @param partnerServiceDocumentType
     *            Partner Service Document Type
     */
    public void setPartnerServiceDocumentType( @Nullable final String partnerServiceDocumentType )
    {
        rememberChangedField("PartnerServiceDocumentType", this.partnerServiceDocumentType);
        this.partnerServiceDocumentType = partnerServiceDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerServiceDocument</b>
     * </p>
     *
     * @param partnerServiceDocument
     *            Partner Service Document ID
     */
    public void setPartnerServiceDocument( @Nullable final String partnerServiceDocument )
    {
        rememberChangedField("PartnerServiceDocument", this.partnerServiceDocument);
        this.partnerServiceDocument = partnerServiceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerServiceDocumentItem</b>
     * </p>
     *
     * @param partnerServiceDocumentItem
     *            Partner Service Document Item ID
     */
    public void setPartnerServiceDocumentItem( @Nullable final String partnerServiceDocumentItem )
    {
        rememberChangedField("PartnerServiceDocumentItem", this.partnerServiceDocumentItem);
        this.partnerServiceDocumentItem = partnerServiceDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentType</b>
     * </p>
     *
     * @param serviceDocumentType
     *            Service Document Type
     */
    public void setServiceDocumentType( @Nullable final String serviceDocumentType )
    {
        rememberChangedField("ServiceDocumentType", this.serviceDocumentType);
        this.serviceDocumentType = serviceDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocument</b>
     * </p>
     *
     * @param serviceDocument
     *            Service Document ID
     */
    public void setServiceDocument( @Nullable final String serviceDocument )
    {
        rememberChangedField("ServiceDocument", this.serviceDocument);
        this.serviceDocument = serviceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItem</b>
     * </p>
     *
     * @param serviceDocumentItem
     *            Service Document Item ID
     */
    public void setServiceDocumentItem( @Nullable final String serviceDocumentItem )
    {
        rememberChangedField("ServiceDocumentItem", this.serviceDocumentItem);
        this.serviceDocumentItem = serviceDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>PartnerOrder</b>
     * </p>
     *
     * @param partnerOrder
     *            Partner Order
     */
    public void setPartnerOrder( @Nullable final String partnerOrder )
    {
        rememberChangedField("PartnerOrder", this.partnerOrder);
        this.partnerOrder = partnerOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>OrderID</b>
     * </p>
     *
     * @param orderID
     *            Order ID
     */
    public void setOrderID( @Nullable final String orderID )
    {
        rememberChangedField("OrderID", this.orderID);
        this.orderID = orderID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SenderCompanyCode</b>
     * </p>
     *
     * @param senderCompanyCode
     *            Sender Company Code
     */
    public void setSenderCompanyCode( @Nullable final String senderCompanyCode )
    {
        rememberChangedField("SenderCompanyCode", this.senderCompanyCode);
        this.senderCompanyCode = senderCompanyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocument</b>
     * </p>
     *
     * @param partnerSalesDocument
     *            Partner Sales Document
     */
    public void setPartnerSalesDocument( @Nullable final String partnerSalesDocument )
    {
        rememberChangedField("PartnerSalesDocument", this.partnerSalesDocument);
        this.partnerSalesDocument = partnerSalesDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSalesDocumentItem</b>
     * </p>
     *
     * @param partnerSalesDocumentItem
     *            Partner Sales Document Item
     */
    public void setPartnerSalesDocumentItem( @Nullable final String partnerSalesDocumentItem )
    {
        rememberChangedField("PartnerSalesDocumentItem", this.partnerSalesDocumentItem);
        this.partnerSalesDocumentItem = partnerSalesDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocument</b>
     * </p>
     *
     * @param salesDocument
     *            Sales Document
     */
    public void setSalesDocument( @Nullable final String salesDocument )
    {
        rememberChangedField("SalesDocument", this.salesDocument);
        this.salesDocument = salesDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentItem</b>
     * </p>
     *
     * @param salesDocumentItem
     *            Sales Document Item
     */
    public void setSalesDocumentItem( @Nullable final String salesDocumentItem )
    {
        rememberChangedField("SalesDocumentItem", this.salesDocumentItem);
        this.salesDocumentItem = salesDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureCostRecoveryCode</b>
     * </p>
     *
     * @param jointVentureCostRecoveryCode
     *            Joint Venture Cost Recovery Code
     */
    public void setJointVentureCostRecoveryCode( @Nullable final String jointVentureCostRecoveryCode )
    {
        rememberChangedField("JointVentureCostRecoveryCode", this.jointVentureCostRecoveryCode);
        this.jointVentureCostRecoveryCode = jointVentureCostRecoveryCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SenderCostRecoveryCode</b>
     * </p>
     *
     * @param senderCostRecoveryCode
     *            Sender Cost Recovery Code
     */
    public void setSenderCostRecoveryCode( @Nullable final String senderCostRecoveryCode )
    {
        rememberChangedField("SenderCostRecoveryCode", this.senderCostRecoveryCode);
        this.senderCostRecoveryCode = senderCostRecoveryCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @param fund
     *            Sender fund
     */
    public void setFund( @Nullable final String fund )
    {
        rememberChangedField("Fund", this.fund);
        this.fund = fund;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Sender Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @param grantID
     *            Sender Grant
     */
    public void setGrantID( @Nullable final String grantID )
    {
        rememberChangedField("GrantID", this.grantID);
        this.grantID = grantID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @param budgetPeriod
     *            Budget Period
     */
    public void setBudgetPeriod( @Nullable final String budgetPeriod )
    {
        rememberChangedField("BudgetPeriod", this.budgetPeriod);
        this.budgetPeriod = budgetPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFund</b>
     * </p>
     *
     * @param partnerFund
     *            Receiver Fund
     */
    public void setPartnerFund( @Nullable final String partnerFund )
    {
        rememberChangedField("PartnerFund", this.partnerFund);
        this.partnerFund = partnerFund;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunctionalArea</b>
     * </p>
     *
     * @param partnerFunctionalArea
     *            Receiver Functional Area
     */
    public void setPartnerFunctionalArea( @Nullable final String partnerFunctionalArea )
    {
        rememberChangedField("PartnerFunctionalArea", this.partnerFunctionalArea);
        this.partnerFunctionalArea = partnerFunctionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>PartnerGrant</b>
     * </p>
     *
     * @param partnerGrant
     *            Receiver Grant
     */
    public void setPartnerGrant( @Nullable final String partnerGrant )
    {
        rememberChangedField("PartnerGrant", this.partnerGrant);
        this.partnerGrant = partnerGrant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PartnerBudgetPeriod</b>
     * </p>
     *
     * @param partnerBudgetPeriod
     *            FM: Partner Budget Period
     */
    public void setPartnerBudgetPeriod( @Nullable final String partnerBudgetPeriod )
    {
        rememberChangedField("PartnerBudgetPeriod", this.partnerBudgetPeriod);
        this.partnerBudgetPeriod = partnerBudgetPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FinancialManagementArea</b>
     * </p>
     *
     * @param financialManagementArea
     *            Financial Management Area
     */
    public void setFinancialManagementArea( @Nullable final String financialManagementArea )
    {
        rememberChangedField("FinancialManagementArea", this.financialManagementArea);
        this.financialManagementArea = financialManagementArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RcvrAcctgIndCode</b>
     * </p>
     *
     * @param rcvrAcctgIndCode
     *            Receiver Accounting Indicator
     */
    public void setRcvrAcctgIndCode( @Nullable final String rcvrAcctgIndCode )
    {
        rememberChangedField("RcvrAcctgIndCode", this.rcvrAcctgIndCode);
        this.rcvrAcctgIndCode = rcvrAcctgIndCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillableControl</b>
     * </p>
     *
     * @param billableControl
     *            Accounting Indicator
     */
    public void setBillableControl( @Nullable final String billableControl )
    {
        rememberChangedField("BillableControl", this.billableControl);
        this.billableControl = billableControl;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OperatingConcern</b>
     * </p>
     *
     * @param operatingConcern
     *            Operating Concern
     */
    public void setOperatingConcern( @Nullable final String operatingConcern )
    {
        rememberChangedField("OperatingConcern", this.operatingConcern);
        this.operatingConcern = operatingConcern;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BaseUnit</b>
     * </p>
     *
     * @param baseUnit
     *            Base Unit of Measure
     */
    public void setBaseUnit( @Nullable final String baseUnit )
    {
        rememberChangedField("BaseUnit", this.baseUnit);
        this.baseUnit = baseUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Quantity</b>
     * </p>
     *
     * @param quantity
     *            Activity Quantity
     */
    public void setQuantity( @Nullable final BigDecimal quantity )
    {
        rememberChangedField("Quantity", this.quantity);
        this.quantity = quantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Transaction Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInTransactionCurrency</b>
     * </p>
     *
     * @param amountInTransactionCurrency
     *            Amount in Transaction Currency
     */
    public void setAmountInTransactionCurrency( @Nullable final BigDecimal amountInTransactionCurrency )
    {
        rememberChangedField("AmountInTransactionCurrency", this.amountInTransactionCurrency);
        this.amountInTransactionCurrency = amountInTransactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @param companyCodeCurrency
     *            Company Code Currency
     */
    public void setCompanyCodeCurrency( @Nullable final String companyCodeCurrency )
    {
        rememberChangedField("CompanyCodeCurrency", this.companyCodeCurrency);
        this.companyCodeCurrency = companyCodeCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInCompanyCodeCurrency</b>
     * </p>
     *
     * @param amountInCompanyCodeCurrency
     *            Amount in Company Code Currency
     */
    public void setAmountInCompanyCodeCurrency( @Nullable final BigDecimal amountInCompanyCodeCurrency )
    {
        rememberChangedField("AmountInCompanyCodeCurrency", this.amountInCompanyCodeCurrency);
        this.amountInCompanyCodeCurrency = amountInCompanyCodeCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>GlobalCurrency</b>
     * </p>
     *
     * @param globalCurrency
     *            Global Currency
     */
    public void setGlobalCurrency( @Nullable final String globalCurrency )
    {
        rememberChangedField("GlobalCurrency", this.globalCurrency);
        this.globalCurrency = globalCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInGlobalCurrency</b>
     * </p>
     *
     * @param amountInGlobalCurrency
     *            Amount in Global Currency
     */
    public void setAmountInGlobalCurrency( @Nullable final BigDecimal amountInGlobalCurrency )
    {
        rememberChangedField("AmountInGlobalCurrency", this.amountInGlobalCurrency);
        this.amountInGlobalCurrency = amountInGlobalCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency1</b>
     * </p>
     *
     * @param freeDefinedCurrency1
     *            Freely Defined Currency 1
     */
    public void setFreeDefinedCurrency1( @Nullable final String freeDefinedCurrency1 )
    {
        rememberChangedField("FreeDefinedCurrency1", this.freeDefinedCurrency1);
        this.freeDefinedCurrency1 = freeDefinedCurrency1;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency1</b>
     * </p>
     *
     * @param amountInFreeDefinedCurrency1
     *            Amount in Freely Defined Currency 1
     */
    public void setAmountInFreeDefinedCurrency1( @Nullable final BigDecimal amountInFreeDefinedCurrency1 )
    {
        rememberChangedField("AmountInFreeDefinedCurrency1", this.amountInFreeDefinedCurrency1);
        this.amountInFreeDefinedCurrency1 = amountInFreeDefinedCurrency1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency2</b>
     * </p>
     *
     * @param freeDefinedCurrency2
     *            Freely Defined Currency 2
     */
    public void setFreeDefinedCurrency2( @Nullable final String freeDefinedCurrency2 )
    {
        rememberChangedField("FreeDefinedCurrency2", this.freeDefinedCurrency2);
        this.freeDefinedCurrency2 = freeDefinedCurrency2;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency2</b>
     * </p>
     *
     * @param amountInFreeDefinedCurrency2
     *            Amount in Freely Defined Currency 2
     */
    public void setAmountInFreeDefinedCurrency2( @Nullable final BigDecimal amountInFreeDefinedCurrency2 )
    {
        rememberChangedField("AmountInFreeDefinedCurrency2", this.amountInFreeDefinedCurrency2);
        this.amountInFreeDefinedCurrency2 = amountInFreeDefinedCurrency2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency3</b>
     * </p>
     *
     * @param freeDefinedCurrency3
     *            Freely Defined Currency 3
     */
    public void setFreeDefinedCurrency3( @Nullable final String freeDefinedCurrency3 )
    {
        rememberChangedField("FreeDefinedCurrency3", this.freeDefinedCurrency3);
        this.freeDefinedCurrency3 = freeDefinedCurrency3;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency3</b>
     * </p>
     *
     * @param amountInFreeDefinedCurrency3
     *            Amount in Freely Defined Currency 3
     */
    public void setAmountInFreeDefinedCurrency3( @Nullable final BigDecimal amountInFreeDefinedCurrency3 )
    {
        rememberChangedField("AmountInFreeDefinedCurrency3", this.amountInFreeDefinedCurrency3);
        this.amountInFreeDefinedCurrency3 = amountInFreeDefinedCurrency3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency4</b>
     * </p>
     *
     * @param freeDefinedCurrency4
     *            Freely Defined Currency 4
     */
    public void setFreeDefinedCurrency4( @Nullable final String freeDefinedCurrency4 )
    {
        rememberChangedField("FreeDefinedCurrency4", this.freeDefinedCurrency4);
        this.freeDefinedCurrency4 = freeDefinedCurrency4;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency4</b>
     * </p>
     *
     * @param amountInFreeDefinedCurrency4
     *            Amount in Freely Defined Currency 4
     */
    public void setAmountInFreeDefinedCurrency4( @Nullable final BigDecimal amountInFreeDefinedCurrency4 )
    {
        rememberChangedField("AmountInFreeDefinedCurrency4", this.amountInFreeDefinedCurrency4);
        this.amountInFreeDefinedCurrency4 = amountInFreeDefinedCurrency4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency5</b>
     * </p>
     *
     * @param freeDefinedCurrency5
     *            Freely Defined Currency 5
     */
    public void setFreeDefinedCurrency5( @Nullable final String freeDefinedCurrency5 )
    {
        rememberChangedField("FreeDefinedCurrency5", this.freeDefinedCurrency5);
        this.freeDefinedCurrency5 = freeDefinedCurrency5;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency5</b>
     * </p>
     *
     * @param amountInFreeDefinedCurrency5
     *            Amount in Freely Defined Currency 5
     */
    public void setAmountInFreeDefinedCurrency5( @Nullable final BigDecimal amountInFreeDefinedCurrency5 )
    {
        rememberChangedField("AmountInFreeDefinedCurrency5", this.amountInFreeDefinedCurrency5);
        this.amountInFreeDefinedCurrency5 = amountInFreeDefinedCurrency5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency6</b>
     * </p>
     *
     * @param freeDefinedCurrency6
     *            Freely Defined Currency 6
     */
    public void setFreeDefinedCurrency6( @Nullable final String freeDefinedCurrency6 )
    {
        rememberChangedField("FreeDefinedCurrency6", this.freeDefinedCurrency6);
        this.freeDefinedCurrency6 = freeDefinedCurrency6;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency6</b>
     * </p>
     *
     * @param amountInFreeDefinedCurrency6
     *            Amount in Freely Defined Currency 6
     */
    public void setAmountInFreeDefinedCurrency6( @Nullable final BigDecimal amountInFreeDefinedCurrency6 )
    {
        rememberChangedField("AmountInFreeDefinedCurrency6", this.amountInFreeDefinedCurrency6);
        this.amountInFreeDefinedCurrency6 = amountInFreeDefinedCurrency6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency7</b>
     * </p>
     *
     * @param freeDefinedCurrency7
     *            Freely Defined Currency 7
     */
    public void setFreeDefinedCurrency7( @Nullable final String freeDefinedCurrency7 )
    {
        rememberChangedField("FreeDefinedCurrency7", this.freeDefinedCurrency7);
        this.freeDefinedCurrency7 = freeDefinedCurrency7;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency7</b>
     * </p>
     *
     * @param amountInFreeDefinedCurrency7
     *            Amount in Freely Defined Currency 7
     */
    public void setAmountInFreeDefinedCurrency7( @Nullable final BigDecimal amountInFreeDefinedCurrency7 )
    {
        rememberChangedField("AmountInFreeDefinedCurrency7", this.amountInFreeDefinedCurrency7);
        this.amountInFreeDefinedCurrency7 = amountInFreeDefinedCurrency7;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedCurrency8</b>
     * </p>
     *
     * @param freeDefinedCurrency8
     *            Freely Defined Currency 8
     */
    public void setFreeDefinedCurrency8( @Nullable final String freeDefinedCurrency8 )
    {
        rememberChangedField("FreeDefinedCurrency8", this.freeDefinedCurrency8);
        this.freeDefinedCurrency8 = freeDefinedCurrency8;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFreeDefinedCurrency8</b>
     * </p>
     *
     * @param amountInFreeDefinedCurrency8
     *            Amount in Freely Defined Currency 8
     */
    public void setAmountInFreeDefinedCurrency8( @Nullable final BigDecimal amountInFreeDefinedCurrency8 )
    {
        rememberChangedField("AmountInFreeDefinedCurrency8", this.amountInFreeDefinedCurrency8);
        this.amountInFreeDefinedCurrency8 = amountInFreeDefinedCurrency8;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalCurrency</b>
     * </p>
     *
     * @param functionalCurrency
     *            Functional Currency
     */
    public void setFunctionalCurrency( @Nullable final String functionalCurrency )
    {
        rememberChangedField("FunctionalCurrency", this.functionalCurrency);
        this.functionalCurrency = functionalCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 23, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AmountInFunctionalCurrency</b>
     * </p>
     *
     * @param amountInFunctionalCurrency
     *            Amount in Functional Currency
     */
    public void setAmountInFunctionalCurrency( @Nullable final BigDecimal amountInFunctionalCurrency )
    {
        rememberChangedField("AmountInFunctionalCurrency", this.amountInFunctionalCurrency);
        this.amountInFunctionalCurrency = amountInFunctionalCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReceiverRECompanyCode</b>
     * </p>
     *
     * @param receiverRECompanyCode
     *            Company code of partner
     */
    public void setReceiverRECompanyCode( @Nullable final String receiverRECompanyCode )
    {
        rememberChangedField("ReceiverRECompanyCode", this.receiverRECompanyCode);
        this.receiverRECompanyCode = receiverRECompanyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>RealEstatePartnerContract</b>
     * </p>
     *
     * @param realEstatePartnerContract
     *            Real Estate Partner Contract
     */
    public void setRealEstatePartnerContract( @Nullable final String realEstatePartnerContract )
    {
        rememberChangedField("RealEstatePartnerContract", this.realEstatePartnerContract);
        this.realEstatePartnerContract = realEstatePartnerContract;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SenderRECompanyCode</b>
     * </p>
     *
     * @param senderRECompanyCode
     *            Company code of Real Estate objects to be sent
     */
    public void setSenderRECompanyCode( @Nullable final String senderRECompanyCode )
    {
        rememberChangedField("SenderRECompanyCode", this.senderRECompanyCode);
        this.senderRECompanyCode = senderRECompanyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>RealEstateContract</b>
     * </p>
     *
     * @param realEstateContract
     *            Real Estate Contract
     */
    public void setRealEstateContract( @Nullable final String realEstateContract )
    {
        rememberChangedField("RealEstateContract", this.realEstateContract);
        this.realEstateContract = realEstateContract;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CostRevenueReassignmentItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FiscalYear", getFiscalYear());
        result.put("ReferenceDocument", getReferenceDocument());
        result.put("ControllingArea", getControllingArea());
        result.put("CompanyCode", getCompanyCode());
        result.put("LedgerGLLineItem", getLedgerGLLineItem());
        result.put("ReferenceDocumentItem", getReferenceDocumentItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FiscalYear", getFiscalYear());
        values.put("ReferenceDocument", getReferenceDocument());
        values.put("ControllingArea", getControllingArea());
        values.put("CompanyCode", getCompanyCode());
        values.put("LedgerGLLineItem", getLedgerGLLineItem());
        values.put("ReferenceDocumentItem", getReferenceDocumentItem());
        values.put("AccountingDocument", getAccountingDocument());
        values.put("SourceLedger", getSourceLedger());
        values.put("DocumentItemText", getDocumentItemText());
        values.put("GLAccount", getGLAccount());
        values.put("PersonnelNumber", getPersonnelNumber());
        values.put("AccountAssignmentType", getAccountAssignmentType());
        values.put("PartnerAccountAssignmentType", getPartnerAccountAssignmentType());
        values.put("OriginCostCenter", getOriginCostCenter());
        values.put("PartnerCostCenter", getPartnerCostCenter());
        values.put("PartnerWBSElementInternalID", getPartnerWBSElementInternalID());
        values.put("WBSElementInternalID", getWBSElementInternalID());
        values.put("PartnerWBSElementExternalID", getPartnerWBSElementExternalID());
        values.put("WBSElementExternalID", getWBSElementExternalID());
        values.put("PartnerServiceDocumentType", getPartnerServiceDocumentType());
        values.put("PartnerServiceDocument", getPartnerServiceDocument());
        values.put("PartnerServiceDocumentItem", getPartnerServiceDocumentItem());
        values.put("ServiceDocumentType", getServiceDocumentType());
        values.put("ServiceDocument", getServiceDocument());
        values.put("ServiceDocumentItem", getServiceDocumentItem());
        values.put("PartnerOrder", getPartnerOrder());
        values.put("OrderID", getOrderID());
        values.put("SenderCompanyCode", getSenderCompanyCode());
        values.put("PartnerSalesDocument", getPartnerSalesDocument());
        values.put("PartnerSalesDocumentItem", getPartnerSalesDocumentItem());
        values.put("SalesDocument", getSalesDocument());
        values.put("SalesDocumentItem", getSalesDocumentItem());
        values.put("JointVentureCostRecoveryCode", getJointVentureCostRecoveryCode());
        values.put("SenderCostRecoveryCode", getSenderCostRecoveryCode());
        values.put("Fund", getFund());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("GrantID", getGrantID());
        values.put("BudgetPeriod", getBudgetPeriod());
        values.put("PartnerFund", getPartnerFund());
        values.put("PartnerFunctionalArea", getPartnerFunctionalArea());
        values.put("PartnerGrant", getPartnerGrant());
        values.put("PartnerBudgetPeriod", getPartnerBudgetPeriod());
        values.put("FinancialManagementArea", getFinancialManagementArea());
        values.put("RcvrAcctgIndCode", getRcvrAcctgIndCode());
        values.put("BillableControl", getBillableControl());
        values.put("OperatingConcern", getOperatingConcern());
        values.put("BaseUnit", getBaseUnit());
        values.put("Quantity", getQuantity());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("AmountInTransactionCurrency", getAmountInTransactionCurrency());
        values.put("CompanyCodeCurrency", getCompanyCodeCurrency());
        values.put("AmountInCompanyCodeCurrency", getAmountInCompanyCodeCurrency());
        values.put("GlobalCurrency", getGlobalCurrency());
        values.put("AmountInGlobalCurrency", getAmountInGlobalCurrency());
        values.put("FreeDefinedCurrency1", getFreeDefinedCurrency1());
        values.put("AmountInFreeDefinedCurrency1", getAmountInFreeDefinedCurrency1());
        values.put("FreeDefinedCurrency2", getFreeDefinedCurrency2());
        values.put("AmountInFreeDefinedCurrency2", getAmountInFreeDefinedCurrency2());
        values.put("FreeDefinedCurrency3", getFreeDefinedCurrency3());
        values.put("AmountInFreeDefinedCurrency3", getAmountInFreeDefinedCurrency3());
        values.put("FreeDefinedCurrency4", getFreeDefinedCurrency4());
        values.put("AmountInFreeDefinedCurrency4", getAmountInFreeDefinedCurrency4());
        values.put("FreeDefinedCurrency5", getFreeDefinedCurrency5());
        values.put("AmountInFreeDefinedCurrency5", getAmountInFreeDefinedCurrency5());
        values.put("FreeDefinedCurrency6", getFreeDefinedCurrency6());
        values.put("AmountInFreeDefinedCurrency6", getAmountInFreeDefinedCurrency6());
        values.put("FreeDefinedCurrency7", getFreeDefinedCurrency7());
        values.put("AmountInFreeDefinedCurrency7", getAmountInFreeDefinedCurrency7());
        values.put("FreeDefinedCurrency8", getFreeDefinedCurrency8());
        values.put("AmountInFreeDefinedCurrency8", getAmountInFreeDefinedCurrency8());
        values.put("FunctionalCurrency", getFunctionalCurrency());
        values.put("AmountInFunctionalCurrency", getAmountInFunctionalCurrency());
        values.put("ReceiverRECompanyCode", getReceiverRECompanyCode());
        values.put("RealEstatePartnerContract", getRealEstatePartnerContract());
        values.put("SenderRECompanyCode", getSenderRECompanyCode());
        values.put("RealEstateContract", getRealEstateContract());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocument") ) {
                final Object value = values.remove("ReferenceDocument");
                if( (value == null) || (!value.equals(getReferenceDocument())) ) {
                    setReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("LedgerGLLineItem") ) {
                final Object value = values.remove("LedgerGLLineItem");
                if( (value == null) || (!value.equals(getLedgerGLLineItem())) ) {
                    setLedgerGLLineItem(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentItem") ) {
                final Object value = values.remove("ReferenceDocumentItem");
                if( (value == null) || (!value.equals(getReferenceDocumentItem())) ) {
                    setReferenceDocumentItem(((String) value));
                }
            }
            if( values.containsKey("AccountingDocument") ) {
                final Object value = values.remove("AccountingDocument");
                if( (value == null) || (!value.equals(getAccountingDocument())) ) {
                    setAccountingDocument(((String) value));
                }
            }
            if( values.containsKey("SourceLedger") ) {
                final Object value = values.remove("SourceLedger");
                if( (value == null) || (!value.equals(getSourceLedger())) ) {
                    setSourceLedger(((String) value));
                }
            }
            if( values.containsKey("DocumentItemText") ) {
                final Object value = values.remove("DocumentItemText");
                if( (value == null) || (!value.equals(getDocumentItemText())) ) {
                    setDocumentItemText(((String) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("PersonnelNumber") ) {
                final Object value = values.remove("PersonnelNumber");
                if( (value == null) || (!value.equals(getPersonnelNumber())) ) {
                    setPersonnelNumber(((String) value));
                }
            }
            if( values.containsKey("AccountAssignmentType") ) {
                final Object value = values.remove("AccountAssignmentType");
                if( (value == null) || (!value.equals(getAccountAssignmentType())) ) {
                    setAccountAssignmentType(((String) value));
                }
            }
            if( values.containsKey("PartnerAccountAssignmentType") ) {
                final Object value = values.remove("PartnerAccountAssignmentType");
                if( (value == null) || (!value.equals(getPartnerAccountAssignmentType())) ) {
                    setPartnerAccountAssignmentType(((String) value));
                }
            }
            if( values.containsKey("OriginCostCenter") ) {
                final Object value = values.remove("OriginCostCenter");
                if( (value == null) || (!value.equals(getOriginCostCenter())) ) {
                    setOriginCostCenter(((String) value));
                }
            }
            if( values.containsKey("PartnerCostCenter") ) {
                final Object value = values.remove("PartnerCostCenter");
                if( (value == null) || (!value.equals(getPartnerCostCenter())) ) {
                    setPartnerCostCenter(((String) value));
                }
            }
            if( values.containsKey("PartnerWBSElementInternalID") ) {
                final Object value = values.remove("PartnerWBSElementInternalID");
                if( (value == null) || (!value.equals(getPartnerWBSElementInternalID())) ) {
                    setPartnerWBSElementInternalID(((String) value));
                }
            }
            if( values.containsKey("WBSElementInternalID") ) {
                final Object value = values.remove("WBSElementInternalID");
                if( (value == null) || (!value.equals(getWBSElementInternalID())) ) {
                    setWBSElementInternalID(((String) value));
                }
            }
            if( values.containsKey("PartnerWBSElementExternalID") ) {
                final Object value = values.remove("PartnerWBSElementExternalID");
                if( (value == null) || (!value.equals(getPartnerWBSElementExternalID())) ) {
                    setPartnerWBSElementExternalID(((String) value));
                }
            }
            if( values.containsKey("WBSElementExternalID") ) {
                final Object value = values.remove("WBSElementExternalID");
                if( (value == null) || (!value.equals(getWBSElementExternalID())) ) {
                    setWBSElementExternalID(((String) value));
                }
            }
            if( values.containsKey("PartnerServiceDocumentType") ) {
                final Object value = values.remove("PartnerServiceDocumentType");
                if( (value == null) || (!value.equals(getPartnerServiceDocumentType())) ) {
                    setPartnerServiceDocumentType(((String) value));
                }
            }
            if( values.containsKey("PartnerServiceDocument") ) {
                final Object value = values.remove("PartnerServiceDocument");
                if( (value == null) || (!value.equals(getPartnerServiceDocument())) ) {
                    setPartnerServiceDocument(((String) value));
                }
            }
            if( values.containsKey("PartnerServiceDocumentItem") ) {
                final Object value = values.remove("PartnerServiceDocumentItem");
                if( (value == null) || (!value.equals(getPartnerServiceDocumentItem())) ) {
                    setPartnerServiceDocumentItem(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentType") ) {
                final Object value = values.remove("ServiceDocumentType");
                if( (value == null) || (!value.equals(getServiceDocumentType())) ) {
                    setServiceDocumentType(((String) value));
                }
            }
            if( values.containsKey("ServiceDocument") ) {
                final Object value = values.remove("ServiceDocument");
                if( (value == null) || (!value.equals(getServiceDocument())) ) {
                    setServiceDocument(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentItem") ) {
                final Object value = values.remove("ServiceDocumentItem");
                if( (value == null) || (!value.equals(getServiceDocumentItem())) ) {
                    setServiceDocumentItem(((String) value));
                }
            }
            if( values.containsKey("PartnerOrder") ) {
                final Object value = values.remove("PartnerOrder");
                if( (value == null) || (!value.equals(getPartnerOrder())) ) {
                    setPartnerOrder(((String) value));
                }
            }
            if( values.containsKey("OrderID") ) {
                final Object value = values.remove("OrderID");
                if( (value == null) || (!value.equals(getOrderID())) ) {
                    setOrderID(((String) value));
                }
            }
            if( values.containsKey("SenderCompanyCode") ) {
                final Object value = values.remove("SenderCompanyCode");
                if( (value == null) || (!value.equals(getSenderCompanyCode())) ) {
                    setSenderCompanyCode(((String) value));
                }
            }
            if( values.containsKey("PartnerSalesDocument") ) {
                final Object value = values.remove("PartnerSalesDocument");
                if( (value == null) || (!value.equals(getPartnerSalesDocument())) ) {
                    setPartnerSalesDocument(((String) value));
                }
            }
            if( values.containsKey("PartnerSalesDocumentItem") ) {
                final Object value = values.remove("PartnerSalesDocumentItem");
                if( (value == null) || (!value.equals(getPartnerSalesDocumentItem())) ) {
                    setPartnerSalesDocumentItem(((String) value));
                }
            }
            if( values.containsKey("SalesDocument") ) {
                final Object value = values.remove("SalesDocument");
                if( (value == null) || (!value.equals(getSalesDocument())) ) {
                    setSalesDocument(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentItem") ) {
                final Object value = values.remove("SalesDocumentItem");
                if( (value == null) || (!value.equals(getSalesDocumentItem())) ) {
                    setSalesDocumentItem(((String) value));
                }
            }
            if( values.containsKey("JointVentureCostRecoveryCode") ) {
                final Object value = values.remove("JointVentureCostRecoveryCode");
                if( (value == null) || (!value.equals(getJointVentureCostRecoveryCode())) ) {
                    setJointVentureCostRecoveryCode(((String) value));
                }
            }
            if( values.containsKey("SenderCostRecoveryCode") ) {
                final Object value = values.remove("SenderCostRecoveryCode");
                if( (value == null) || (!value.equals(getSenderCostRecoveryCode())) ) {
                    setSenderCostRecoveryCode(((String) value));
                }
            }
            if( values.containsKey("Fund") ) {
                final Object value = values.remove("Fund");
                if( (value == null) || (!value.equals(getFund())) ) {
                    setFund(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("GrantID") ) {
                final Object value = values.remove("GrantID");
                if( (value == null) || (!value.equals(getGrantID())) ) {
                    setGrantID(((String) value));
                }
            }
            if( values.containsKey("BudgetPeriod") ) {
                final Object value = values.remove("BudgetPeriod");
                if( (value == null) || (!value.equals(getBudgetPeriod())) ) {
                    setBudgetPeriod(((String) value));
                }
            }
            if( values.containsKey("PartnerFund") ) {
                final Object value = values.remove("PartnerFund");
                if( (value == null) || (!value.equals(getPartnerFund())) ) {
                    setPartnerFund(((String) value));
                }
            }
            if( values.containsKey("PartnerFunctionalArea") ) {
                final Object value = values.remove("PartnerFunctionalArea");
                if( (value == null) || (!value.equals(getPartnerFunctionalArea())) ) {
                    setPartnerFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("PartnerGrant") ) {
                final Object value = values.remove("PartnerGrant");
                if( (value == null) || (!value.equals(getPartnerGrant())) ) {
                    setPartnerGrant(((String) value));
                }
            }
            if( values.containsKey("PartnerBudgetPeriod") ) {
                final Object value = values.remove("PartnerBudgetPeriod");
                if( (value == null) || (!value.equals(getPartnerBudgetPeriod())) ) {
                    setPartnerBudgetPeriod(((String) value));
                }
            }
            if( values.containsKey("FinancialManagementArea") ) {
                final Object value = values.remove("FinancialManagementArea");
                if( (value == null) || (!value.equals(getFinancialManagementArea())) ) {
                    setFinancialManagementArea(((String) value));
                }
            }
            if( values.containsKey("RcvrAcctgIndCode") ) {
                final Object value = values.remove("RcvrAcctgIndCode");
                if( (value == null) || (!value.equals(getRcvrAcctgIndCode())) ) {
                    setRcvrAcctgIndCode(((String) value));
                }
            }
            if( values.containsKey("BillableControl") ) {
                final Object value = values.remove("BillableControl");
                if( (value == null) || (!value.equals(getBillableControl())) ) {
                    setBillableControl(((String) value));
                }
            }
            if( values.containsKey("OperatingConcern") ) {
                final Object value = values.remove("OperatingConcern");
                if( (value == null) || (!value.equals(getOperatingConcern())) ) {
                    setOperatingConcern(((String) value));
                }
            }
            if( values.containsKey("BaseUnit") ) {
                final Object value = values.remove("BaseUnit");
                if( (value == null) || (!value.equals(getBaseUnit())) ) {
                    setBaseUnit(((String) value));
                }
            }
            if( values.containsKey("Quantity") ) {
                final Object value = values.remove("Quantity");
                if( (value == null) || (!value.equals(getQuantity())) ) {
                    setQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInTransactionCurrency") ) {
                final Object value = values.remove("AmountInTransactionCurrency");
                if( (value == null) || (!value.equals(getAmountInTransactionCurrency())) ) {
                    setAmountInTransactionCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("CompanyCodeCurrency") ) {
                final Object value = values.remove("CompanyCodeCurrency");
                if( (value == null) || (!value.equals(getCompanyCodeCurrency())) ) {
                    setCompanyCodeCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInCompanyCodeCurrency") ) {
                final Object value = values.remove("AmountInCompanyCodeCurrency");
                if( (value == null) || (!value.equals(getAmountInCompanyCodeCurrency())) ) {
                    setAmountInCompanyCodeCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("GlobalCurrency") ) {
                final Object value = values.remove("GlobalCurrency");
                if( (value == null) || (!value.equals(getGlobalCurrency())) ) {
                    setGlobalCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInGlobalCurrency") ) {
                final Object value = values.remove("AmountInGlobalCurrency");
                if( (value == null) || (!value.equals(getAmountInGlobalCurrency())) ) {
                    setAmountInGlobalCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency1") ) {
                final Object value = values.remove("FreeDefinedCurrency1");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency1())) ) {
                    setFreeDefinedCurrency1(((String) value));
                }
            }
            if( values.containsKey("AmountInFreeDefinedCurrency1") ) {
                final Object value = values.remove("AmountInFreeDefinedCurrency1");
                if( (value == null) || (!value.equals(getAmountInFreeDefinedCurrency1())) ) {
                    setAmountInFreeDefinedCurrency1(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency2") ) {
                final Object value = values.remove("FreeDefinedCurrency2");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency2())) ) {
                    setFreeDefinedCurrency2(((String) value));
                }
            }
            if( values.containsKey("AmountInFreeDefinedCurrency2") ) {
                final Object value = values.remove("AmountInFreeDefinedCurrency2");
                if( (value == null) || (!value.equals(getAmountInFreeDefinedCurrency2())) ) {
                    setAmountInFreeDefinedCurrency2(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency3") ) {
                final Object value = values.remove("FreeDefinedCurrency3");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency3())) ) {
                    setFreeDefinedCurrency3(((String) value));
                }
            }
            if( values.containsKey("AmountInFreeDefinedCurrency3") ) {
                final Object value = values.remove("AmountInFreeDefinedCurrency3");
                if( (value == null) || (!value.equals(getAmountInFreeDefinedCurrency3())) ) {
                    setAmountInFreeDefinedCurrency3(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency4") ) {
                final Object value = values.remove("FreeDefinedCurrency4");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency4())) ) {
                    setFreeDefinedCurrency4(((String) value));
                }
            }
            if( values.containsKey("AmountInFreeDefinedCurrency4") ) {
                final Object value = values.remove("AmountInFreeDefinedCurrency4");
                if( (value == null) || (!value.equals(getAmountInFreeDefinedCurrency4())) ) {
                    setAmountInFreeDefinedCurrency4(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency5") ) {
                final Object value = values.remove("FreeDefinedCurrency5");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency5())) ) {
                    setFreeDefinedCurrency5(((String) value));
                }
            }
            if( values.containsKey("AmountInFreeDefinedCurrency5") ) {
                final Object value = values.remove("AmountInFreeDefinedCurrency5");
                if( (value == null) || (!value.equals(getAmountInFreeDefinedCurrency5())) ) {
                    setAmountInFreeDefinedCurrency5(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency6") ) {
                final Object value = values.remove("FreeDefinedCurrency6");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency6())) ) {
                    setFreeDefinedCurrency6(((String) value));
                }
            }
            if( values.containsKey("AmountInFreeDefinedCurrency6") ) {
                final Object value = values.remove("AmountInFreeDefinedCurrency6");
                if( (value == null) || (!value.equals(getAmountInFreeDefinedCurrency6())) ) {
                    setAmountInFreeDefinedCurrency6(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency7") ) {
                final Object value = values.remove("FreeDefinedCurrency7");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency7())) ) {
                    setFreeDefinedCurrency7(((String) value));
                }
            }
            if( values.containsKey("AmountInFreeDefinedCurrency7") ) {
                final Object value = values.remove("AmountInFreeDefinedCurrency7");
                if( (value == null) || (!value.equals(getAmountInFreeDefinedCurrency7())) ) {
                    setAmountInFreeDefinedCurrency7(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedCurrency8") ) {
                final Object value = values.remove("FreeDefinedCurrency8");
                if( (value == null) || (!value.equals(getFreeDefinedCurrency8())) ) {
                    setFreeDefinedCurrency8(((String) value));
                }
            }
            if( values.containsKey("AmountInFreeDefinedCurrency8") ) {
                final Object value = values.remove("AmountInFreeDefinedCurrency8");
                if( (value == null) || (!value.equals(getAmountInFreeDefinedCurrency8())) ) {
                    setAmountInFreeDefinedCurrency8(((BigDecimal) value));
                }
            }
            if( values.containsKey("FunctionalCurrency") ) {
                final Object value = values.remove("FunctionalCurrency");
                if( (value == null) || (!value.equals(getFunctionalCurrency())) ) {
                    setFunctionalCurrency(((String) value));
                }
            }
            if( values.containsKey("AmountInFunctionalCurrency") ) {
                final Object value = values.remove("AmountInFunctionalCurrency");
                if( (value == null) || (!value.equals(getAmountInFunctionalCurrency())) ) {
                    setAmountInFunctionalCurrency(((BigDecimal) value));
                }
            }
            if( values.containsKey("ReceiverRECompanyCode") ) {
                final Object value = values.remove("ReceiverRECompanyCode");
                if( (value == null) || (!value.equals(getReceiverRECompanyCode())) ) {
                    setReceiverRECompanyCode(((String) value));
                }
            }
            if( values.containsKey("RealEstatePartnerContract") ) {
                final Object value = values.remove("RealEstatePartnerContract");
                if( (value == null) || (!value.equals(getRealEstatePartnerContract())) ) {
                    setRealEstatePartnerContract(((String) value));
                }
            }
            if( values.containsKey("SenderRECompanyCode") ) {
                final Object value = values.remove("SenderRECompanyCode");
                if( (value == null) || (!value.equals(getSenderRECompanyCode())) ) {
                    setSenderRECompanyCode(((String) value));
                }
            }
            if( values.containsKey("RealEstateContract") ) {
                final Object value = values.remove("RealEstateContract");
                if( (value == null) || (!value.equals(getRealEstateContract())) ) {
                    setRealEstateContract(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Header") ) {
                final Object value = (values).remove("to_Header");
                if( value instanceof Map ) {
                    if( toHeader == null ) {
                        toHeader = new CostRevenueReassignment();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toHeader.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_ReceiverProfitabilitySegment") ) {
                final Object value = (values).remove("to_ReceiverProfitabilitySegment");
                if( value instanceof Map ) {
                    if( toReceiverProfitabilitySegment == null ) {
                        toReceiverProfitabilitySegment = new CostRevnRcvrPrftbltySegment();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toReceiverProfitabilitySegment.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SenderProfitabilitySegment") ) {
                final Object value = (values).remove("to_SenderProfitabilitySegment");
                if( value instanceof Map ) {
                    if( toSenderProfitabilitySegment == null ) {
                        toSenderProfitabilitySegment = new CostRevnSndrPrftbltySegment();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSenderProfitabilitySegment.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CostRevenueReassignmentItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CostRevenueReassignmentItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CostRevenueReassignmentItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CostRevenueReassignmentItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostControllingJournalEntryService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toHeader != null ) {
            (values).put("to_Header", toHeader);
        }
        if( toReceiverProfitabilitySegment != null ) {
            (values).put("to_ReceiverProfitabilitySegment", toReceiverProfitabilitySegment);
        }
        if( toSenderProfitabilitySegment != null ) {
            (values).put("to_SenderProfitabilitySegment", toSenderProfitabilitySegment);
        }
        return values;
    }

    /**
     * Fetches the <b>CostRevenueReassignment</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Header</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CostRevenueReassignment</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CostRevenueReassignment fetchHeader()
    {
        return fetchFieldAsSingle("to_Header", CostRevenueReassignment.class);
    }

    /**
     * Retrieval of associated <b>CostRevenueReassignment</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Header</b>.
     * <p>
     * If the navigation property <b>to_Header</b> of a queried <b>CostRevenueReassignmentItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CostRevenueReassignment</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CostRevenueReassignment getHeaderOrFetch()
    {
        if( toHeader == null ) {
            toHeader = fetchHeader();
        }
        return toHeader;
    }

    /**
     * Retrieval of associated <b>CostRevenueReassignment</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Header</b>.
     * <p>
     * If the navigation property for an entity <b>CostRevenueReassignmentItem</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Header</b> is already loaded, the result will contain
     *         the <b>CostRevenueReassignment</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CostRevenueReassignment> getHeaderIfPresent()
    {
        return Option.of(toHeader);
    }

    /**
     * Overwrites the associated <b>CostRevenueReassignment</b> entity for the loaded navigation property
     * <b>to_Header</b>.
     *
     * @param value
     *            New <b>CostRevenueReassignment</b> entity.
     */
    public void setHeader( final CostRevenueReassignment value )
    {
        toHeader = value;
    }

    /**
     * Fetches the <b>CostRevnRcvrPrftbltySegment</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ReceiverProfitabilitySegment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CostRevnRcvrPrftbltySegment</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CostRevnRcvrPrftbltySegment fetchReceiverProfitabilitySegment()
    {
        return fetchFieldAsSingle("to_ReceiverProfitabilitySegment", CostRevnRcvrPrftbltySegment.class);
    }

    /**
     * Retrieval of associated <b>CostRevnRcvrPrftbltySegment</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ReceiverProfitabilitySegment</b>.
     * <p>
     * If the navigation property <b>to_ReceiverProfitabilitySegment</b> of a queried <b>CostRevenueReassignmentItem</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CostRevnRcvrPrftbltySegment</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CostRevnRcvrPrftbltySegment getReceiverProfitabilitySegmentOrFetch()
    {
        if( toReceiverProfitabilitySegment == null ) {
            toReceiverProfitabilitySegment = fetchReceiverProfitabilitySegment();
        }
        return toReceiverProfitabilitySegment;
    }

    /**
     * Retrieval of associated <b>CostRevnRcvrPrftbltySegment</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_ReceiverProfitabilitySegment</b>.
     * <p>
     * If the navigation property for an entity <b>CostRevenueReassignmentItem</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ReceiverProfitabilitySegment</b> is already loaded, the
     *         result will contain the <b>CostRevnRcvrPrftbltySegment</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CostRevnRcvrPrftbltySegment> getReceiverProfitabilitySegmentIfPresent()
    {
        return Option.of(toReceiverProfitabilitySegment);
    }

    /**
     * Overwrites the associated <b>CostRevnRcvrPrftbltySegment</b> entity for the loaded navigation property
     * <b>to_ReceiverProfitabilitySegment</b>.
     *
     * @param value
     *            New <b>CostRevnRcvrPrftbltySegment</b> entity.
     */
    public void setReceiverProfitabilitySegment( final CostRevnRcvrPrftbltySegment value )
    {
        toReceiverProfitabilitySegment = value;
    }

    /**
     * Fetches the <b>CostRevnSndrPrftbltySegment</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SenderProfitabilitySegment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CostRevnSndrPrftbltySegment</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CostRevnSndrPrftbltySegment fetchSenderProfitabilitySegment()
    {
        return fetchFieldAsSingle("to_SenderProfitabilitySegment", CostRevnSndrPrftbltySegment.class);
    }

    /**
     * Retrieval of associated <b>CostRevnSndrPrftbltySegment</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SenderProfitabilitySegment</b>.
     * <p>
     * If the navigation property <b>to_SenderProfitabilitySegment</b> of a queried <b>CostRevenueReassignmentItem</b>
     * is operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CostRevnSndrPrftbltySegment</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CostRevnSndrPrftbltySegment getSenderProfitabilitySegmentOrFetch()
    {
        if( toSenderProfitabilitySegment == null ) {
            toSenderProfitabilitySegment = fetchSenderProfitabilitySegment();
        }
        return toSenderProfitabilitySegment;
    }

    /**
     * Retrieval of associated <b>CostRevnSndrPrftbltySegment</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SenderProfitabilitySegment</b>.
     * <p>
     * If the navigation property for an entity <b>CostRevenueReassignmentItem</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SenderProfitabilitySegment</b> is already loaded, the
     *         result will contain the <b>CostRevnSndrPrftbltySegment</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CostRevnSndrPrftbltySegment> getSenderProfitabilitySegmentIfPresent()
    {
        return Option.of(toSenderProfitabilitySegment);
    }

    /**
     * Overwrites the associated <b>CostRevnSndrPrftbltySegment</b> entity for the loaded navigation property
     * <b>to_SenderProfitabilitySegment</b>.
     *
     * @param value
     *            New <b>CostRevnSndrPrftbltySegment</b> entity.
     */
    public void setSenderProfitabilitySegment( final CostRevnSndrPrftbltySegment value )
    {
        toSenderProfitabilitySegment = value;
    }

    /**
     * Helper class to allow for fluent creation of CostRevenueReassignmentItem instances.
     *
     */
    public final static class CostRevenueReassignmentItemBuilder
    {

        private CostRevenueReassignment toHeader;
        private CostRevnRcvrPrftbltySegment toReceiverProfitabilitySegment;
        private CostRevnSndrPrftbltySegment toSenderProfitabilitySegment;

        private CostRevenueReassignmentItem.CostRevenueReassignmentItemBuilder toHeader(
            final CostRevenueReassignment value )
        {
            toHeader = value;
            return this;
        }

        /**
         * Navigation property <b>to_Header</b> for <b>CostRevenueReassignmentItem</b> to single
         * <b>CostRevenueReassignment</b>.
         *
         * @param value
         *            The CostRevenueReassignment to build this CostRevenueReassignmentItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CostRevenueReassignmentItem.CostRevenueReassignmentItemBuilder header(
            final CostRevenueReassignment value )
        {
            return toHeader(value);
        }

        private CostRevenueReassignmentItem.CostRevenueReassignmentItemBuilder toReceiverProfitabilitySegment(
            final CostRevnRcvrPrftbltySegment value )
        {
            toReceiverProfitabilitySegment = value;
            return this;
        }

        /**
         * Navigation property <b>to_ReceiverProfitabilitySegment</b> for <b>CostRevenueReassignmentItem</b> to single
         * <b>CostRevnRcvrPrftbltySegment</b>.
         *
         * @param value
         *            The CostRevnRcvrPrftbltySegment to build this CostRevenueReassignmentItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CostRevenueReassignmentItem.CostRevenueReassignmentItemBuilder receiverProfitabilitySegment(
            final CostRevnRcvrPrftbltySegment value )
        {
            return toReceiverProfitabilitySegment(value);
        }

        private CostRevenueReassignmentItem.CostRevenueReassignmentItemBuilder toSenderProfitabilitySegment(
            final CostRevnSndrPrftbltySegment value )
        {
            toSenderProfitabilitySegment = value;
            return this;
        }

        /**
         * Navigation property <b>to_SenderProfitabilitySegment</b> for <b>CostRevenueReassignmentItem</b> to single
         * <b>CostRevnSndrPrftbltySegment</b>.
         *
         * @param value
         *            The CostRevnSndrPrftbltySegment to build this CostRevenueReassignmentItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CostRevenueReassignmentItem.CostRevenueReassignmentItemBuilder senderProfitabilitySegment(
            final CostRevnSndrPrftbltySegment value )
        {
            return toSenderProfitabilitySegment(value);
        }

    }

}
