/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.selectable.CostRevenueReassignmentItemSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignmentItem
 * CostRevenueReassignmentItem} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class CostRevenueReassignmentItemByKeyFluentHelper
    extends
    FluentHelperByKey<CostRevenueReassignmentItemByKeyFluentHelper, CostRevenueReassignmentItem, CostRevenueReassignmentItemSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignmentItem
     * CostRevenueReassignmentItem} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param companyCode
     *            Receiver Company Code
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CostRevenueReassignmentItem}
     * @param ledgerGLLineItem
     *            Ledger Journal Entry Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code CostRevenueReassignmentItem}
     * @param referenceDocumentItem
     *            Reference Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param referenceDocument
     *            Reference Document Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param controllingArea
     *            Controlling Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param fiscalYear
     *            Fiscal Year
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     */
    public CostRevenueReassignmentItemByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String fiscalYear,
        final String referenceDocument,
        final String controllingArea,
        final String companyCode,
        final String ledgerGLLineItem,
        final String referenceDocumentItem )
    {
        super(servicePath, entityCollection);
        this.key.put("FiscalYear", fiscalYear);
        this.key.put("ReferenceDocument", referenceDocument);
        this.key.put("ControllingArea", controllingArea);
        this.key.put("CompanyCode", companyCode);
        this.key.put("LedgerGLLineItem", ledgerGLLineItem);
        this.key.put("ReferenceDocumentItem", referenceDocumentItem);
    }

    @Override
    @Nonnull
    protected Class<CostRevenueReassignmentItem> getEntityClass()
    {
        return CostRevenueReassignmentItem.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
