/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.field.CostRevnSndrPrftbltySegmentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.link.CostRevnSndrPrftbltySegmentOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.selectable.CostRevnSndrPrftbltySegmentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Cost Reassignment Sender Profitability Segment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CostRevnSndrPrftbltySegment_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CostRevnSndrPrftbltySegment extends VdmEntity<CostRevnSndrPrftbltySegment>
{

    /**
     * Selector for all available fields of CostRevnSndrPrftbltySegment.
     *
     */
    public final static CostRevnSndrPrftbltySegmentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @return Fiscal Year
     */
    @Key
    @SerializedName( "FiscalYear" )
    @JsonProperty( "FiscalYear" )
    @Nullable
    @ODataField( odataName = "FiscalYear" )
    private String fiscalYear;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYear</b> field to query operations.
     *
     */
    public final static CostRevnSndrPrftbltySegmentField<String> FISCAL_YEAR =
        new CostRevnSndrPrftbltySegmentField<String>("FiscalYear");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocument</b>
     * </p>
     *
     * @return Reference Document Number
     */
    @Key
    @SerializedName( "ReferenceDocument" )
    @JsonProperty( "ReferenceDocument" )
    @Nullable
    @ODataField( odataName = "ReferenceDocument" )
    private String referenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocument</b> field to query operations.
     *
     */
    public final static CostRevnSndrPrftbltySegmentField<String> REFERENCE_DOCUMENT =
        new CostRevnSndrPrftbltySegmentField<String>("ReferenceDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static CostRevnSndrPrftbltySegmentField<String> CONTROLLING_AREA =
        new CostRevnSndrPrftbltySegmentField<String>("ControllingArea");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LedgerGLLineItem</b>
     * </p>
     *
     * @return Ledger Journal Entry Item
     */
    @Key
    @SerializedName( "LedgerGLLineItem" )
    @JsonProperty( "LedgerGLLineItem" )
    @Nullable
    @ODataField( odataName = "LedgerGLLineItem" )
    private String ledgerGLLineItem;
    /**
     * Use with available fluent helpers to apply the <b>LedgerGLLineItem</b> field to query operations.
     *
     */
    public final static CostRevnSndrPrftbltySegmentField<String> LEDGER_GL_LINE_ITEM =
        new CostRevnSndrPrftbltySegmentField<String>("LedgerGLLineItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentItem</b>
     * </p>
     *
     * @return Reference Document Item
     */
    @Key
    @SerializedName( "ReferenceDocumentItem" )
    @JsonProperty( "ReferenceDocumentItem" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentItem" )
    private String referenceDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentItem</b> field to query operations.
     *
     */
    public final static CostRevnSndrPrftbltySegmentField<String> REFERENCE_DOCUMENT_ITEM =
        new CostRevnSndrPrftbltySegmentField<String>("ReferenceDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TransactionSubitem</b>
     * </p>
     *
     * @return Partial Document to be balanced to zero
     */
    @SerializedName( "TransactionSubitem" )
    @JsonProperty( "TransactionSubitem" )
    @Nullable
    @ODataField( odataName = "TransactionSubitem" )
    private String transactionSubitem;
    /**
     * Use with available fluent helpers to apply the <b>TransactionSubitem</b> field to query operations.
     *
     */
    public final static CostRevnSndrPrftbltySegmentField<String> TRANSACTION_SUBITEM =
        new CostRevnSndrPrftbltySegmentField<String>("TransactionSubitem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static CostRevnSndrPrftbltySegmentField<String> COMPANY_CODE =
        new CostRevnSndrPrftbltySegmentField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer Number
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static CostRevnSndrPrftbltySegmentField<String> CUSTOMER =
        new CostRevnSndrPrftbltySegmentField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @return Customer Group
     */
    @SerializedName( "CustomerGroup" )
    @JsonProperty( "CustomerGroup" )
    @Nullable
    @ODataField( odataName = "CustomerGroup" )
    private String customerGroup;
    /**
     * Use with available fluent helpers to apply the <b>CustomerGroup</b> field to query operations.
     *
     */
    public final static CostRevnSndrPrftbltySegmentField<String> CUSTOMER_GROUP =
        new CostRevnSndrPrftbltySegmentField<String>("CustomerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierIndustry</b>
     * </p>
     *
     * @return Customer Supplier Industry
     */
    @SerializedName( "CustomerSupplierIndustry" )
    @JsonProperty( "CustomerSupplierIndustry" )
    @Nullable
    @ODataField( odataName = "CustomerSupplierIndustry" )
    private String customerSupplierIndustry;
    /**
     * Use with available fluent helpers to apply the <b>CustomerSupplierIndustry</b> field to query operations.
     *
     */
    public final static CostRevnSndrPrftbltySegmentField<String> CUSTOMER_SUPPLIER_INDUSTRY =
        new CostRevnSndrPrftbltySegmentField<String>("CustomerSupplierIndustry");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierCountry</b>
     * </p>
     *
     * @return Customer or Supplier Country/Region
     */
    @SerializedName( "CustomerSupplierCountry" )
    @JsonProperty( "CustomerSupplierCountry" )
    @Nullable
    @ODataField( odataName = "CustomerSupplierCountry" )
    private String customerSupplierCountry;
    /**
     * Use with available fluent helpers to apply the <b>CustomerSupplierCountry</b> field to query operations.
     *
     */
    public final static CostRevnSndrPrftbltySegmentField<String> CUSTOMER_SUPPLIER_COUNTRY =
        new CostRevnSndrPrftbltySegmentField<String>("CustomerSupplierCountry");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict</b>
     * </p>
     *
     * @return Sales District
     */
    @SerializedName( "SalesDistrict" )
    @JsonProperty( "SalesDistrict" )
    @Nullable
    @ODataField( odataName = "SalesDistrict" )
    private String salesDistrict;
    /**
     * Use with available fluent helpers to apply the <b>SalesDistrict</b> field to query operations.
     *
     */
    public final static CostRevnSndrPrftbltySegmentField<String> SALES_DISTRICT =
        new CostRevnSndrPrftbltySegmentField<String>("SalesDistrict");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SoldProduct</b>
     * </p>
     *
     * @return Product Sold
     */
    @SerializedName( "SoldProduct" )
    @JsonProperty( "SoldProduct" )
    @Nullable
    @ODataField( odataName = "SoldProduct" )
    private String soldProduct;
    /**
     * Use with available fluent helpers to apply the <b>SoldProduct</b> field to query operations.
     *
     */
    public final static CostRevnSndrPrftbltySegmentField<String> SOLD_PRODUCT =
        new CostRevnSndrPrftbltySegmentField<String>("SoldProduct");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>SoldProductGroup</b>
     * </p>
     *
     * @return Product Sold Group
     */
    @SerializedName( "SoldProductGroup" )
    @JsonProperty( "SoldProductGroup" )
    @Nullable
    @ODataField( odataName = "SoldProductGroup" )
    private String soldProductGroup;
    /**
     * Use with available fluent helpers to apply the <b>SoldProductGroup</b> field to query operations.
     *
     */
    public final static CostRevnSndrPrftbltySegmentField<String> SOLD_PRODUCT_GROUP =
        new CostRevnSndrPrftbltySegmentField<String>("SoldProductGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static CostRevnSndrPrftbltySegmentField<String> SALES_ORGANIZATION =
        new CostRevnSndrPrftbltySegmentField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static CostRevnSndrPrftbltySegmentField<String> DISTRIBUTION_CHANNEL =
        new CostRevnSndrPrftbltySegmentField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "OrganizationDivision" )
    @JsonProperty( "OrganizationDivision" )
    @Nullable
    @ODataField( odataName = "OrganizationDivision" )
    private String organizationDivision;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationDivision</b> field to query operations.
     *
     */
    public final static CostRevnSndrPrftbltySegmentField<String> ORGANIZATION_DIVISION =
        new CostRevnSndrPrftbltySegmentField<String>("OrganizationDivision");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @return Bill-to Party
     */
    @SerializedName( "BillToParty" )
    @JsonProperty( "BillToParty" )
    @Nullable
    @ODataField( odataName = "BillToParty" )
    private String billToParty;
    /**
     * Use with available fluent helpers to apply the <b>BillToParty</b> field to query operations.
     *
     */
    public final static CostRevnSndrPrftbltySegmentField<String> BILL_TO_PARTY =
        new CostRevnSndrPrftbltySegmentField<String>("BillToParty");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @return Ship-to Party
     */
    @SerializedName( "ShipToParty" )
    @JsonProperty( "ShipToParty" )
    @Nullable
    @ODataField( odataName = "ShipToParty" )
    private String shipToParty;
    /**
     * Use with available fluent helpers to apply the <b>ShipToParty</b> field to query operations.
     *
     */
    public final static CostRevnSndrPrftbltySegmentField<String> SHIP_TO_PARTY =
        new CostRevnSndrPrftbltySegmentField<String>("ShipToParty");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @return WBS Element External ID
     */
    @SerializedName( "WBSElementExternalID" )
    @JsonProperty( "WBSElementExternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementExternalID" )
    private String wBSElementExternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementExternalID</b> field to query operations.
     *
     */
    public final static CostRevnSndrPrftbltySegmentField<String> WBS_ELEMENT_EXTERNAL_ID =
        new CostRevnSndrPrftbltySegmentField<String>("WBSElementExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentType</b>
     * </p>
     *
     * @return Service Document Type
     */
    @SerializedName( "ServiceDocumentType" )
    @JsonProperty( "ServiceDocumentType" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentType" )
    private String serviceDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentType</b> field to query operations.
     *
     */
    public final static CostRevnSndrPrftbltySegmentField<String> SERVICE_DOCUMENT_TYPE =
        new CostRevnSndrPrftbltySegmentField<String>("ServiceDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocument</b>
     * </p>
     *
     * @return Service Document ID
     */
    @SerializedName( "ServiceDocument" )
    @JsonProperty( "ServiceDocument" )
    @Nullable
    @ODataField( odataName = "ServiceDocument" )
    private String serviceDocument;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocument</b> field to query operations.
     *
     */
    public final static CostRevnSndrPrftbltySegmentField<String> SERVICE_DOCUMENT =
        new CostRevnSndrPrftbltySegmentField<String>("ServiceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItem</b>
     * </p>
     *
     * @return Service Document Item ID
     */
    @SerializedName( "ServiceDocumentItem" )
    @JsonProperty( "ServiceDocumentItem" )
    @Nullable
    @ODataField( odataName = "ServiceDocumentItem" )
    private String serviceDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ServiceDocumentItem</b> field to query operations.
     *
     */
    public final static CostRevnSndrPrftbltySegmentField<String> SERVICE_DOCUMENT_ITEM =
        new CostRevnSndrPrftbltySegmentField<String>("ServiceDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static CostRevnSndrPrftbltySegmentField<String> FUNCTIONAL_AREA =
        new CostRevnSndrPrftbltySegmentField<String>("FunctionalArea");
    /**
     * Navigation property <b>to_Item</b> for <b>CostRevnSndrPrftbltySegment</b> to single
     * <b>CostRevenueReassignmentItem</b>.
     *
     */
    @SerializedName( "to_Item" )
    @JsonProperty( "to_Item" )
    @ODataField( odataName = "to_Item" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CostRevenueReassignmentItem toItem;
    /**
     * Use with available fluent helpers to apply the <b>to_Item</b> navigation property to query operations.
     *
     */
    public final static CostRevnSndrPrftbltySegmentOneToOneLink<CostRevenueReassignmentItem> TO_ITEM =
        new CostRevnSndrPrftbltySegmentOneToOneLink<CostRevenueReassignmentItem>("to_Item");

    @Nonnull
    @Override
    public Class<CostRevnSndrPrftbltySegment> getType()
    {
        return CostRevnSndrPrftbltySegment.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYear</b>
     * </p>
     *
     * @param fiscalYear
     *            Fiscal Year
     */
    public void setFiscalYear( @Nullable final String fiscalYear )
    {
        rememberChangedField("FiscalYear", this.fiscalYear);
        this.fiscalYear = fiscalYear;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocument</b>
     * </p>
     *
     * @param referenceDocument
     *            Reference Document Number
     */
    public void setReferenceDocument( @Nullable final String referenceDocument )
    {
        rememberChangedField("ReferenceDocument", this.referenceDocument);
        this.referenceDocument = referenceDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>LedgerGLLineItem</b>
     * </p>
     *
     * @param ledgerGLLineItem
     *            Ledger Journal Entry Item
     */
    public void setLedgerGLLineItem( @Nullable final String ledgerGLLineItem )
    {
        rememberChangedField("LedgerGLLineItem", this.ledgerGLLineItem);
        this.ledgerGLLineItem = ledgerGLLineItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentItem</b>
     * </p>
     *
     * @param referenceDocumentItem
     *            Reference Document Item
     */
    public void setReferenceDocumentItem( @Nullable final String referenceDocumentItem )
    {
        rememberChangedField("ReferenceDocumentItem", this.referenceDocumentItem);
        this.referenceDocumentItem = referenceDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TransactionSubitem</b>
     * </p>
     *
     * @param transactionSubitem
     *            Partial Document to be balanced to zero
     */
    public void setTransactionSubitem( @Nullable final String transactionSubitem )
    {
        rememberChangedField("TransactionSubitem", this.transactionSubitem);
        this.transactionSubitem = transactionSubitem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @param customerGroup
     *            Customer Group
     */
    public void setCustomerGroup( @Nullable final String customerGroup )
    {
        rememberChangedField("CustomerGroup", this.customerGroup);
        this.customerGroup = customerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierIndustry</b>
     * </p>
     *
     * @param customerSupplierIndustry
     *            Customer Supplier Industry
     */
    public void setCustomerSupplierIndustry( @Nullable final String customerSupplierIndustry )
    {
        rememberChangedField("CustomerSupplierIndustry", this.customerSupplierIndustry);
        this.customerSupplierIndustry = customerSupplierIndustry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CustomerSupplierCountry</b>
     * </p>
     *
     * @param customerSupplierCountry
     *            Customer or Supplier Country/Region
     */
    public void setCustomerSupplierCountry( @Nullable final String customerSupplierCountry )
    {
        rememberChangedField("CustomerSupplierCountry", this.customerSupplierCountry);
        this.customerSupplierCountry = customerSupplierCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict</b>
     * </p>
     *
     * @param salesDistrict
     *            Sales District
     */
    public void setSalesDistrict( @Nullable final String salesDistrict )
    {
        rememberChangedField("SalesDistrict", this.salesDistrict);
        this.salesDistrict = salesDistrict;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>SoldProduct</b>
     * </p>
     *
     * @param soldProduct
     *            Product Sold
     */
    public void setSoldProduct( @Nullable final String soldProduct )
    {
        rememberChangedField("SoldProduct", this.soldProduct);
        this.soldProduct = soldProduct;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>SoldProductGroup</b>
     * </p>
     *
     * @param soldProductGroup
     *            Product Sold Group
     */
    public void setSoldProductGroup( @Nullable final String soldProductGroup )
    {
        rememberChangedField("SoldProductGroup", this.soldProductGroup);
        this.soldProductGroup = soldProductGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @param organizationDivision
     *            Division
     */
    public void setOrganizationDivision( @Nullable final String organizationDivision )
    {
        rememberChangedField("OrganizationDivision", this.organizationDivision);
        this.organizationDivision = organizationDivision;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillToParty</b>
     * </p>
     *
     * @param billToParty
     *            Bill-to Party
     */
    public void setBillToParty( @Nullable final String billToParty )
    {
        rememberChangedField("BillToParty", this.billToParty);
        this.billToParty = billToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ShipToParty</b>
     * </p>
     *
     * @param shipToParty
     *            Ship-to Party
     */
    public void setShipToParty( @Nullable final String shipToParty )
    {
        rememberChangedField("ShipToParty", this.shipToParty);
        this.shipToParty = shipToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @param wBSElementExternalID
     *            WBS Element External ID
     */
    public void setWBSElementExternalID( @Nullable final String wBSElementExternalID )
    {
        rememberChangedField("WBSElementExternalID", this.wBSElementExternalID);
        this.wBSElementExternalID = wBSElementExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentType</b>
     * </p>
     *
     * @param serviceDocumentType
     *            Service Document Type
     */
    public void setServiceDocumentType( @Nullable final String serviceDocumentType )
    {
        rememberChangedField("ServiceDocumentType", this.serviceDocumentType);
        this.serviceDocumentType = serviceDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocument</b>
     * </p>
     *
     * @param serviceDocument
     *            Service Document ID
     */
    public void setServiceDocument( @Nullable final String serviceDocument )
    {
        rememberChangedField("ServiceDocument", this.serviceDocument);
        this.serviceDocument = serviceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ServiceDocumentItem</b>
     * </p>
     *
     * @param serviceDocumentItem
     *            Service Document Item ID
     */
    public void setServiceDocumentItem( @Nullable final String serviceDocumentItem )
    {
        rememberChangedField("ServiceDocumentItem", this.serviceDocumentItem);
        this.serviceDocumentItem = serviceDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CostRevnSndrPrftbltySegment";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("FiscalYear", getFiscalYear());
        result.put("ReferenceDocument", getReferenceDocument());
        result.put("ControllingArea", getControllingArea());
        result.put("LedgerGLLineItem", getLedgerGLLineItem());
        result.put("ReferenceDocumentItem", getReferenceDocumentItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("FiscalYear", getFiscalYear());
        values.put("ReferenceDocument", getReferenceDocument());
        values.put("ControllingArea", getControllingArea());
        values.put("LedgerGLLineItem", getLedgerGLLineItem());
        values.put("ReferenceDocumentItem", getReferenceDocumentItem());
        values.put("TransactionSubitem", getTransactionSubitem());
        values.put("CompanyCode", getCompanyCode());
        values.put("Customer", getCustomer());
        values.put("CustomerGroup", getCustomerGroup());
        values.put("CustomerSupplierIndustry", getCustomerSupplierIndustry());
        values.put("CustomerSupplierCountry", getCustomerSupplierCountry());
        values.put("SalesDistrict", getSalesDistrict());
        values.put("SoldProduct", getSoldProduct());
        values.put("SoldProductGroup", getSoldProductGroup());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("OrganizationDivision", getOrganizationDivision());
        values.put("BillToParty", getBillToParty());
        values.put("ShipToParty", getShipToParty());
        values.put("WBSElementExternalID", getWBSElementExternalID());
        values.put("ServiceDocumentType", getServiceDocumentType());
        values.put("ServiceDocument", getServiceDocument());
        values.put("ServiceDocumentItem", getServiceDocumentItem());
        values.put("FunctionalArea", getFunctionalArea());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("FiscalYear") ) {
                final Object value = values.remove("FiscalYear");
                if( (value == null) || (!value.equals(getFiscalYear())) ) {
                    setFiscalYear(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocument") ) {
                final Object value = values.remove("ReferenceDocument");
                if( (value == null) || (!value.equals(getReferenceDocument())) ) {
                    setReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("LedgerGLLineItem") ) {
                final Object value = values.remove("LedgerGLLineItem");
                if( (value == null) || (!value.equals(getLedgerGLLineItem())) ) {
                    setLedgerGLLineItem(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentItem") ) {
                final Object value = values.remove("ReferenceDocumentItem");
                if( (value == null) || (!value.equals(getReferenceDocumentItem())) ) {
                    setReferenceDocumentItem(((String) value));
                }
            }
            if( values.containsKey("TransactionSubitem") ) {
                final Object value = values.remove("TransactionSubitem");
                if( (value == null) || (!value.equals(getTransactionSubitem())) ) {
                    setTransactionSubitem(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("CustomerGroup") ) {
                final Object value = values.remove("CustomerGroup");
                if( (value == null) || (!value.equals(getCustomerGroup())) ) {
                    setCustomerGroup(((String) value));
                }
            }
            if( values.containsKey("CustomerSupplierIndustry") ) {
                final Object value = values.remove("CustomerSupplierIndustry");
                if( (value == null) || (!value.equals(getCustomerSupplierIndustry())) ) {
                    setCustomerSupplierIndustry(((String) value));
                }
            }
            if( values.containsKey("CustomerSupplierCountry") ) {
                final Object value = values.remove("CustomerSupplierCountry");
                if( (value == null) || (!value.equals(getCustomerSupplierCountry())) ) {
                    setCustomerSupplierCountry(((String) value));
                }
            }
            if( values.containsKey("SalesDistrict") ) {
                final Object value = values.remove("SalesDistrict");
                if( (value == null) || (!value.equals(getSalesDistrict())) ) {
                    setSalesDistrict(((String) value));
                }
            }
            if( values.containsKey("SoldProduct") ) {
                final Object value = values.remove("SoldProduct");
                if( (value == null) || (!value.equals(getSoldProduct())) ) {
                    setSoldProduct(((String) value));
                }
            }
            if( values.containsKey("SoldProductGroup") ) {
                final Object value = values.remove("SoldProductGroup");
                if( (value == null) || (!value.equals(getSoldProductGroup())) ) {
                    setSoldProductGroup(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("OrganizationDivision") ) {
                final Object value = values.remove("OrganizationDivision");
                if( (value == null) || (!value.equals(getOrganizationDivision())) ) {
                    setOrganizationDivision(((String) value));
                }
            }
            if( values.containsKey("BillToParty") ) {
                final Object value = values.remove("BillToParty");
                if( (value == null) || (!value.equals(getBillToParty())) ) {
                    setBillToParty(((String) value));
                }
            }
            if( values.containsKey("ShipToParty") ) {
                final Object value = values.remove("ShipToParty");
                if( (value == null) || (!value.equals(getShipToParty())) ) {
                    setShipToParty(((String) value));
                }
            }
            if( values.containsKey("WBSElementExternalID") ) {
                final Object value = values.remove("WBSElementExternalID");
                if( (value == null) || (!value.equals(getWBSElementExternalID())) ) {
                    setWBSElementExternalID(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentType") ) {
                final Object value = values.remove("ServiceDocumentType");
                if( (value == null) || (!value.equals(getServiceDocumentType())) ) {
                    setServiceDocumentType(((String) value));
                }
            }
            if( values.containsKey("ServiceDocument") ) {
                final Object value = values.remove("ServiceDocument");
                if( (value == null) || (!value.equals(getServiceDocument())) ) {
                    setServiceDocument(((String) value));
                }
            }
            if( values.containsKey("ServiceDocumentItem") ) {
                final Object value = values.remove("ServiceDocumentItem");
                if( (value == null) || (!value.equals(getServiceDocumentItem())) ) {
                    setServiceDocumentItem(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Item") ) {
                final Object value = (values).remove("to_Item");
                if( value instanceof Map ) {
                    if( toItem == null ) {
                        toItem = new CostRevenueReassignmentItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CostRevnSndrPrftbltySegmentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CostRevnSndrPrftbltySegmentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CostRevnSndrPrftbltySegmentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CostRevnSndrPrftbltySegmentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostControllingJournalEntryService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toItem != null ) {
            (values).put("to_Item", toItem);
        }
        return values;
    }

    /**
     * Fetches the <b>CostRevenueReassignmentItem</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Item</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CostRevenueReassignmentItem</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CostRevenueReassignmentItem fetchItem()
    {
        return fetchFieldAsSingle("to_Item", CostRevenueReassignmentItem.class);
    }

    /**
     * Retrieval of associated <b>CostRevenueReassignmentItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>CostRevnSndrPrftbltySegment</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CostRevenueReassignmentItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CostRevenueReassignmentItem getItemOrFetch()
    {
        if( toItem == null ) {
            toItem = fetchItem();
        }
        return toItem;
    }

    /**
     * Retrieval of associated <b>CostRevenueReassignmentItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property for an entity <b>CostRevnSndrPrftbltySegment</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Item</b> is already loaded, the result will contain the
     *         <b>CostRevenueReassignmentItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CostRevenueReassignmentItem> getItemIfPresent()
    {
        return Option.of(toItem);
    }

    /**
     * Overwrites the associated <b>CostRevenueReassignmentItem</b> entity for the loaded navigation property
     * <b>to_Item</b>.
     *
     * @param value
     *            New <b>CostRevenueReassignmentItem</b> entity.
     */
    public void setItem( final CostRevenueReassignmentItem value )
    {
        toItem = value;
    }

    /**
     * Helper class to allow for fluent creation of CostRevnSndrPrftbltySegment instances.
     *
     */
    public final static class CostRevnSndrPrftbltySegmentBuilder
    {

        private CostRevenueReassignmentItem toItem;

        private CostRevnSndrPrftbltySegment.CostRevnSndrPrftbltySegmentBuilder toItem(
            final CostRevenueReassignmentItem value )
        {
            toItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_Item</b> for <b>CostRevnSndrPrftbltySegment</b> to single
         * <b>CostRevenueReassignmentItem</b>.
         *
         * @param value
         *            The CostRevenueReassignmentItem to build this CostRevnSndrPrftbltySegment with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CostRevnSndrPrftbltySegment.CostRevnSndrPrftbltySegmentBuilder item(
            final CostRevenueReassignmentItem value )
        {
            return toItem(value);
        }

    }

}
