/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link CostControllingJournalEntryServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostControllingJournalEntryService
 * CostControllingJournalEntryService}, allowing you to create multiple changesets and finally execute the batch
 * request.
 *
 */
public class DefaultCostControllingJournalEntryServiceBatch
    extends
    BatchFluentHelperBasic<CostControllingJournalEntryServiceBatch, CostControllingJournalEntryServiceBatchChangeSet>
    implements
    CostControllingJournalEntryServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostControllingJournalEntryService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultCostControllingJournalEntryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCostControllingJournalEntryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostControllingJournalEntryService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostControllingJournalEntryService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultCostControllingJournalEntryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCostControllingJournalEntryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostControllingJournalEntryService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultCostControllingJournalEntryServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CostControllingJournalEntryServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultCostControllingJournalEntryServiceBatchChangeSet(this, service);
    }

}
