/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment;

/**
 * Implementation of the {@link CostControllingJournalEntryServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostControllingJournalEntryService
 * CostControllingJournalEntryService}.
 *
 */
public class DefaultCostControllingJournalEntryServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<CostControllingJournalEntryServiceBatch, CostControllingJournalEntryServiceBatchChangeSet>
    implements
    CostControllingJournalEntryServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostControllingJournalEntryService service;

    @SuppressWarnings( "deprecation" )
    DefaultCostControllingJournalEntryServiceBatchChangeSet(
        @Nonnull final DefaultCostControllingJournalEntryServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostControllingJournalEntryService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultCostControllingJournalEntryServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CostControllingJournalEntryServiceBatchChangeSet createCostRevenueReassignment(
        @Nonnull final CostRevenueReassignment costRevenueReassignment )
    {
        return addRequestCreate(service::createCostRevenueReassignment, costRevenueReassignment);
    }

}
