/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment
 * CostRevenueReassignment}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.field.CostRevenueReassignmentField
 * CostRevenueReassignmentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.link.CostRevenueReassignmentLink
 * CostRevenueReassignmentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#REFERENCE_DOCUMENT
 * REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#ACCOUNTING_DOCUMENT_HEADER_TEXT
 * ACCOUNTING_DOCUMENT_HEADER_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#DOCUMENT_DATE
 * DOCUMENT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#POSTING_DATE
 * POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#FISCAL_PERIOD
 * FISCAL_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#ACCOUNTING_DOCUMENT_CREATION_DATE
 * ACCOUNTING_DOCUMENT_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#ACCOUNTING_DOC_CREATED_BY_USER
 * ACCOUNTING_DOC_CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#REFERENCE_DOCUMENT_TYPE
 * REFERENCE_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#REFERENCE_DOCUMENT_TYPE_NAME
 * REFERENCE_DOCUMENT_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#COST_REVENUE_REASSIGNMENT_ACTION
 * COST_REVENUE_REASSIGNMENT_ACTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#POSTING_FISCAL_YEAR
 * POSTING_FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#EXCHANGE_RATE_DATE
 * EXCHANGE_RATE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#CONTROLLING_DOCUMENT_STATUS
 * CONTROLLING_DOCUMENT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#STATUS_NAME
 * STATUS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#ALLOCATION_POSTING_TYPE
 * ALLOCATION_POSTING_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#ALLOCATION_POSTING_TYPE_TEXT
 * ALLOCATION_POSTING_TYPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#REVERSAL_REFERENCE_DOCUMENT
 * REVERSAL_REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#REVERSED_REFERENCE_DOCUMENT
 * REVERSED_REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#COST_REVENUE_REASSIGNMENT_TYPE
 * COST_REVENUE_REASSIGNMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#COST_REVN_REASSIGNMENT_TYPE_NAME
 * COST_REVN_REASSIGNMENT_TYPE_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#GLOBAL_CURRENCY
 * GLOBAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#TOTAL_AMOUNT_IN_GLOBAL_CURRENCY
 * TOTAL_AMOUNT_IN_GLOBAL_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#WARNINGS_ARE_IGNORED
 * WARNINGS_ARE_IGNORED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevenueReassignment#TO_ITEM
 * TO_ITEM}</li>
 * </ul>
 *
 */
public interface CostRevenueReassignmentSelectable extends EntitySelectable<CostRevenueReassignment>
{

}
