/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment
 * CostRevnRcvrPrftbltySegment}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.field.CostRevnRcvrPrftbltySegmentField
 * CostRevnRcvrPrftbltySegmentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.link.CostRevnRcvrPrftbltySegmentLink
 * CostRevnRcvrPrftbltySegmentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment#REFERENCE_DOCUMENT
 * REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment#LEDGER_GL_LINE_ITEM
 * LEDGER_GL_LINE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment#REFERENCE_DOCUMENT_ITEM
 * REFERENCE_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment#TRANSACTION_SUBITEM
 * TRANSACTION_SUBITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment#CUSTOMER_GROUP
 * CUSTOMER_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment#CUSTOMER_SUPPLIER_INDUSTRY
 * CUSTOMER_SUPPLIER_INDUSTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment#CUSTOMER_SUPPLIER_COUNTRY
 * CUSTOMER_SUPPLIER_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment#SALES_DISTRICT
 * SALES_DISTRICT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment#SOLD_PRODUCT
 * SOLD_PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment#SOLD_PRODUCT_GROUP
 * SOLD_PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment#DISTRIBUTION_CHANNEL
 * DISTRIBUTION_CHANNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment#ORGANIZATION_DIVISION
 * ORGANIZATION_DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment#BILL_TO_PARTY
 * BILL_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment#SHIP_TO_PARTY
 * SHIP_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment#WBS_ELEMENT_EXTERNAL_ID
 * WBS_ELEMENT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment#SERVICE_DOCUMENT_TYPE
 * SERVICE_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment#SERVICE_DOCUMENT
 * SERVICE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment#SERVICE_DOCUMENT_ITEM
 * SERVICE_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnRcvrPrftbltySegment#TO_ITEM
 * TO_ITEM}</li>
 * </ul>
 *
 */
public interface CostRevnRcvrPrftbltySegmentSelectable extends EntitySelectable<CostRevnRcvrPrftbltySegment>
{

}
