/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment
 * CostRevnSndrPrftbltySegment}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.field.CostRevnSndrPrftbltySegmentField
 * CostRevnSndrPrftbltySegmentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.link.CostRevnSndrPrftbltySegmentLink
 * CostRevnSndrPrftbltySegmentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment#FISCAL_YEAR
 * FISCAL_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment#REFERENCE_DOCUMENT
 * REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment#CONTROLLING_AREA
 * CONTROLLING_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment#LEDGER_GL_LINE_ITEM
 * LEDGER_GL_LINE_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment#REFERENCE_DOCUMENT_ITEM
 * REFERENCE_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment#TRANSACTION_SUBITEM
 * TRANSACTION_SUBITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment#CUSTOMER_GROUP
 * CUSTOMER_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment#CUSTOMER_SUPPLIER_INDUSTRY
 * CUSTOMER_SUPPLIER_INDUSTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment#CUSTOMER_SUPPLIER_COUNTRY
 * CUSTOMER_SUPPLIER_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment#SALES_DISTRICT
 * SALES_DISTRICT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment#SOLD_PRODUCT
 * SOLD_PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment#SOLD_PRODUCT_GROUP
 * SOLD_PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment#DISTRIBUTION_CHANNEL
 * DISTRIBUTION_CHANNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment#ORGANIZATION_DIVISION
 * ORGANIZATION_DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment#BILL_TO_PARTY
 * BILL_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment#SHIP_TO_PARTY
 * SHIP_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment#WBS_ELEMENT_EXTERNAL_ID
 * WBS_ELEMENT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment#SERVICE_DOCUMENT_TYPE
 * SERVICE_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment#SERVICE_DOCUMENT
 * SERVICE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment#SERVICE_DOCUMENT_ITEM
 * SERVICE_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costcontrollingjournalentry.CostRevnSndrPrftbltySegment#TO_ITEM
 * TO_ITEM}</li>
 * </ul>
 *
 */
public interface CostRevnSndrPrftbltySegmentSelectable extends EntitySelectable<CostRevnSndrPrftbltySegment>
{

}
