/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate;

import java.math.BigDecimal;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.field.ActualCostRateField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.selectable.ActualCostRateSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Actual Cost Rate
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ActualCostRateType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ActualCostRate extends VdmEntity<ActualCostRate>
{

    /**
     * Selector for all available fields of ActualCostRate.
     *
     */
    public final static ActualCostRateSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>AccountingCostRateUUID</b>
     * </p>
     *
     * @return Cost Rate UUID
     */
    @Key
    @SerializedName( "AccountingCostRateUUID" )
    @JsonProperty( "AccountingCostRateUUID" )
    @Nullable
    @ODataField( odataName = "AccountingCostRateUUID" )
    private UUID accountingCostRateUUID;
    /**
     * Use with available fluent helpers to apply the <b>AccountingCostRateUUID</b> field to query operations.
     *
     */
    public final static ActualCostRateField<UUID> ACCOUNTING_COST_RATE_UUID =
        new ActualCostRateField<UUID>("AccountingCostRateUUID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static ActualCostRateField<String> COMPANY_CODE = new ActualCostRateField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static ActualCostRateField<String> COST_CENTER = new ActualCostRateField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ActivityType</b>
     * </p>
     *
     * @return Activity Type
     */
    @SerializedName( "ActivityType" )
    @JsonProperty( "ActivityType" )
    @Nullable
    @ODataField( odataName = "ActivityType" )
    private String activityType;
    /**
     * Use with available fluent helpers to apply the <b>ActivityType</b> field to query operations.
     *
     */
    public final static ActualCostRateField<String> ACTIVITY_TYPE = new ActualCostRateField<String>("ActivityType");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static ActualCostRateField<String> CURRENCY = new ActualCostRateField<String>("Currency");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartFiscalYearPeriod</b>
     * </p>
     *
     * @return Fiscal Year + Fiscal Period
     */
    @SerializedName( "ValidityStartFiscalYearPeriod" )
    @JsonProperty( "ValidityStartFiscalYearPeriod" )
    @Nullable
    @ODataField( odataName = "ValidityStartFiscalYearPeriod" )
    private String validityStartFiscalYearPeriod;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartFiscalYearPeriod</b> field to query operations.
     *
     */
    public final static ActualCostRateField<String> VALIDITY_START_FISCAL_YEAR_PERIOD =
        new ActualCostRateField<String>("ValidityStartFiscalYearPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndFiscalYearPeriod</b>
     * </p>
     *
     * @return Fiscal Year + Fiscal Period
     */
    @SerializedName( "ValidityEndFiscalYearPeriod" )
    @JsonProperty( "ValidityEndFiscalYearPeriod" )
    @Nullable
    @ODataField( odataName = "ValidityEndFiscalYearPeriod" )
    private String validityEndFiscalYearPeriod;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndFiscalYearPeriod</b> field to query operations.
     *
     */
    public final static ActualCostRateField<String> VALIDITY_END_FISCAL_YEAR_PERIOD =
        new ActualCostRateField<String>("ValidityEndFiscalYearPeriod");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostRateFixedAmount</b>
     * </p>
     *
     * @return Fixed Rate
     */
    @SerializedName( "CostRateFixedAmount" )
    @JsonProperty( "CostRateFixedAmount" )
    @Nullable
    @ODataField( odataName = "CostRateFixedAmount" )
    private BigDecimal costRateFixedAmount;
    /**
     * Use with available fluent helpers to apply the <b>CostRateFixedAmount</b> field to query operations.
     *
     */
    public final static ActualCostRateField<BigDecimal> COST_RATE_FIXED_AMOUNT =
        new ActualCostRateField<BigDecimal>("CostRateFixedAmount");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostRateVarblAmount</b>
     * </p>
     *
     * @return Variable Rate
     */
    @SerializedName( "CostRateVarblAmount" )
    @JsonProperty( "CostRateVarblAmount" )
    @Nullable
    @ODataField( odataName = "CostRateVarblAmount" )
    private BigDecimal costRateVarblAmount;
    /**
     * Use with available fluent helpers to apply the <b>CostRateVarblAmount</b> field to query operations.
     *
     */
    public final static ActualCostRateField<BigDecimal> COST_RATE_VARBL_AMOUNT =
        new ActualCostRateField<BigDecimal>("CostRateVarblAmount");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CostRateScaleFactor</b>
     * </p>
     *
     * @return Per
     */
    @SerializedName( "CostRateScaleFactor" )
    @JsonProperty( "CostRateScaleFactor" )
    @Nullable
    @ODataField( odataName = "CostRateScaleFactor" )
    private BigDecimal costRateScaleFactor;
    /**
     * Use with available fluent helpers to apply the <b>CostRateScaleFactor</b> field to query operations.
     *
     */
    public final static ActualCostRateField<BigDecimal> COST_RATE_SCALE_FACTOR =
        new ActualCostRateField<BigDecimal>("CostRateScaleFactor");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityTypeQtyUnit</b>
     * </p>
     *
     * @return Activity Unit
     */
    @SerializedName( "CostCtrActivityTypeQtyUnit" )
    @JsonProperty( "CostCtrActivityTypeQtyUnit" )
    @Nullable
    @ODataField( odataName = "CostCtrActivityTypeQtyUnit" )
    private String costCtrActivityTypeQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>CostCtrActivityTypeQtyUnit</b> field to query operations.
     *
     */
    public final static ActualCostRateField<String> COST_CTR_ACTIVITY_TYPE_QTY_UNIT =
        new ActualCostRateField<String>("CostCtrActivityTypeQtyUnit");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @return Ledger in General Ledger Accounting
     */
    @SerializedName( "Ledger" )
    @JsonProperty( "Ledger" )
    @Nullable
    @ODataField( odataName = "Ledger" )
    private String ledger;
    /**
     * Use with available fluent helpers to apply the <b>Ledger</b> field to query operations.
     *
     */
    public final static ActualCostRateField<String> LEDGER = new ActualCostRateField<String>("Ledger");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CostRateIsOverwriteMode</b>
     * </p>
     *
     * @return Truth Value: True/False
     */
    @SerializedName( "CostRateIsOverwriteMode" )
    @JsonProperty( "CostRateIsOverwriteMode" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CostRateIsOverwriteMode" )
    private Boolean costRateIsOverwriteMode;
    /**
     * Use with available fluent helpers to apply the <b>CostRateIsOverwriteMode</b> field to query operations.
     *
     */
    public final static ActualCostRateField<Boolean> COST_RATE_IS_OVERWRITE_MODE =
        new ActualCostRateField<Boolean>("CostRateIsOverwriteMode");

    @Nonnull
    @Override
    public Class<ActualCostRate> getType()
    {
        return ActualCostRate.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>AccountingCostRateUUID</b>
     * </p>
     *
     * @param accountingCostRateUUID
     *            Cost Rate UUID
     */
    public void setAccountingCostRateUUID( @Nullable final UUID accountingCostRateUUID )
    {
        rememberChangedField("AccountingCostRateUUID", this.accountingCostRateUUID);
        this.accountingCostRateUUID = accountingCostRateUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ActivityType</b>
     * </p>
     *
     * @param activityType
     *            Activity Type
     */
    public void setActivityType( @Nullable final String activityType )
    {
        rememberChangedField("ActivityType", this.activityType);
        this.activityType = activityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartFiscalYearPeriod</b>
     * </p>
     *
     * @param validityStartFiscalYearPeriod
     *            Fiscal Year + Fiscal Period
     */
    public void setValidityStartFiscalYearPeriod( @Nullable final String validityStartFiscalYearPeriod )
    {
        rememberChangedField("ValidityStartFiscalYearPeriod", this.validityStartFiscalYearPeriod);
        this.validityStartFiscalYearPeriod = validityStartFiscalYearPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndFiscalYearPeriod</b>
     * </p>
     *
     * @param validityEndFiscalYearPeriod
     *            Fiscal Year + Fiscal Period
     */
    public void setValidityEndFiscalYearPeriod( @Nullable final String validityEndFiscalYearPeriod )
    {
        rememberChangedField("ValidityEndFiscalYearPeriod", this.validityEndFiscalYearPeriod);
        this.validityEndFiscalYearPeriod = validityEndFiscalYearPeriod;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostRateFixedAmount</b>
     * </p>
     *
     * @param costRateFixedAmount
     *            Fixed Rate
     */
    public void setCostRateFixedAmount( @Nullable final BigDecimal costRateFixedAmount )
    {
        rememberChangedField("CostRateFixedAmount", this.costRateFixedAmount);
        this.costRateFixedAmount = costRateFixedAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostRateVarblAmount</b>
     * </p>
     *
     * @param costRateVarblAmount
     *            Variable Rate
     */
    public void setCostRateVarblAmount( @Nullable final BigDecimal costRateVarblAmount )
    {
        rememberChangedField("CostRateVarblAmount", this.costRateVarblAmount);
        this.costRateVarblAmount = costRateVarblAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>CostRateScaleFactor</b>
     * </p>
     *
     * @param costRateScaleFactor
     *            Per
     */
    public void setCostRateScaleFactor( @Nullable final BigDecimal costRateScaleFactor )
    {
        rememberChangedField("CostRateScaleFactor", this.costRateScaleFactor);
        this.costRateScaleFactor = costRateScaleFactor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostCtrActivityTypeQtyUnit</b>
     * </p>
     *
     * @param costCtrActivityTypeQtyUnit
     *            Activity Unit
     */
    public void setCostCtrActivityTypeQtyUnit( @Nullable final String costCtrActivityTypeQtyUnit )
    {
        rememberChangedField("CostCtrActivityTypeQtyUnit", this.costCtrActivityTypeQtyUnit);
        this.costCtrActivityTypeQtyUnit = costCtrActivityTypeQtyUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Ledger</b>
     * </p>
     *
     * @param ledger
     *            Ledger in General Ledger Accounting
     */
    public void setLedger( @Nullable final String ledger )
    {
        rememberChangedField("Ledger", this.ledger);
        this.ledger = ledger;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CostRateIsOverwriteMode</b>
     * </p>
     *
     * @param costRateIsOverwriteMode
     *            Truth Value: True/False
     */
    public void setCostRateIsOverwriteMode( @Nullable final Boolean costRateIsOverwriteMode )
    {
        rememberChangedField("CostRateIsOverwriteMode", this.costRateIsOverwriteMode);
        this.costRateIsOverwriteMode = costRateIsOverwriteMode;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ActualCostRate";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("AccountingCostRateUUID", getAccountingCostRateUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("AccountingCostRateUUID", getAccountingCostRateUUID());
        values.put("CompanyCode", getCompanyCode());
        values.put("CostCenter", getCostCenter());
        values.put("ActivityType", getActivityType());
        values.put("Currency", getCurrency());
        values.put("ValidityStartFiscalYearPeriod", getValidityStartFiscalYearPeriod());
        values.put("ValidityEndFiscalYearPeriod", getValidityEndFiscalYearPeriod());
        values.put("CostRateFixedAmount", getCostRateFixedAmount());
        values.put("CostRateVarblAmount", getCostRateVarblAmount());
        values.put("CostRateScaleFactor", getCostRateScaleFactor());
        values.put("CostCtrActivityTypeQtyUnit", getCostCtrActivityTypeQtyUnit());
        values.put("Ledger", getLedger());
        values.put("CostRateIsOverwriteMode", getCostRateIsOverwriteMode());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("AccountingCostRateUUID") ) {
                final Object value = values.remove("AccountingCostRateUUID");
                if( (value == null) || (!value.equals(getAccountingCostRateUUID())) ) {
                    setAccountingCostRateUUID(((UUID) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("ActivityType") ) {
                final Object value = values.remove("ActivityType");
                if( (value == null) || (!value.equals(getActivityType())) ) {
                    setActivityType(((String) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("ValidityStartFiscalYearPeriod") ) {
                final Object value = values.remove("ValidityStartFiscalYearPeriod");
                if( (value == null) || (!value.equals(getValidityStartFiscalYearPeriod())) ) {
                    setValidityStartFiscalYearPeriod(((String) value));
                }
            }
            if( values.containsKey("ValidityEndFiscalYearPeriod") ) {
                final Object value = values.remove("ValidityEndFiscalYearPeriod");
                if( (value == null) || (!value.equals(getValidityEndFiscalYearPeriod())) ) {
                    setValidityEndFiscalYearPeriod(((String) value));
                }
            }
            if( values.containsKey("CostRateFixedAmount") ) {
                final Object value = values.remove("CostRateFixedAmount");
                if( (value == null) || (!value.equals(getCostRateFixedAmount())) ) {
                    setCostRateFixedAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CostRateVarblAmount") ) {
                final Object value = values.remove("CostRateVarblAmount");
                if( (value == null) || (!value.equals(getCostRateVarblAmount())) ) {
                    setCostRateVarblAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CostRateScaleFactor") ) {
                final Object value = values.remove("CostRateScaleFactor");
                if( (value == null) || (!value.equals(getCostRateScaleFactor())) ) {
                    setCostRateScaleFactor(((BigDecimal) value));
                }
            }
            if( values.containsKey("CostCtrActivityTypeQtyUnit") ) {
                final Object value = values.remove("CostCtrActivityTypeQtyUnit");
                if( (value == null) || (!value.equals(getCostCtrActivityTypeQtyUnit())) ) {
                    setCostCtrActivityTypeQtyUnit(((String) value));
                }
            }
            if( values.containsKey("Ledger") ) {
                final Object value = values.remove("Ledger");
                if( (value == null) || (!value.equals(getLedger())) ) {
                    setLedger(((String) value));
                }
            }
            if( values.containsKey("CostRateIsOverwriteMode") ) {
                final Object value = values.remove("CostRateIsOverwriteMode");
                if( (value == null) || (!value.equals(getCostRateIsOverwriteMode())) ) {
                    setCostRateIsOverwriteMode(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ActualCostRateField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ActualCostRateField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ActualCostRateField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ActualCostRateField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostRateService.DEFAULT_SERVICE_PATH);
    }

}
