/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.selectable.PlanCostRateSelectable;

/**
 * Fluent helper to fetch a single {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRate
 * PlanCostRate} entity using key fields. This fluent helper allows methods which modify the underlying query to be
 * called before executing the query itself.
 *
 */
public class PlanCostRateByKeyFluentHelper
    extends
    FluentHelperByKey<PlanCostRateByKeyFluentHelper, PlanCostRate, PlanCostRateSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRate PlanCostRate} entity with the
     * provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method on the
     * fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PlanCostRate}
     * @param accountingCostRateUUID
     *            Cost Rate UUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code PlanCostRate}
     */
    public PlanCostRateByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID accountingCostRateUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("AccountingCostRateUUID", accountingCostRateUUID);
    }

    @Override
    @Nonnull
    protected Class<PlanCostRate> getEntityClass()
    {
        return PlanCostRate.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
