/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostRateService CostRateService}.
 *
 */
public interface CostRateServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<CostRateServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<CostRateServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate ActualCostRate}
     * entity and save it to the S/4HANA system.
     *
     * @param actualCostRate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate ActualCostRate}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CostRateServiceBatchChangeSet createActualCostRate( @Nonnull final ActualCostRate actualCostRate );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate
     * ActualCostRate} entity and save it to the S/4HANA system.
     *
     * @param actualCostRate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate ActualCostRate}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CostRateServiceBatchChangeSet updateActualCostRate( @Nonnull final ActualCostRate actualCostRate );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate
     * ActualCostRate} entity in the S/4HANA system.
     *
     * @param actualCostRate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate ActualCostRate}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CostRateServiceBatchChangeSet deleteActualCostRate( @Nonnull final ActualCostRate actualCostRate );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRate PlanCostRate}
     * entity and save it to the S/4HANA system.
     *
     * @param planCostRate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRate PlanCostRate} entity
     *            object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CostRateServiceBatchChangeSet createPlanCostRate( @Nonnull final PlanCostRate planCostRate );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRate PlanCostRate}
     * entity and save it to the S/4HANA system.
     *
     * @param planCostRate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRate PlanCostRate} entity
     *            object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CostRateServiceBatchChangeSet updatePlanCostRate( @Nonnull final PlanCostRate planCostRate );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRate
     * PlanCostRate} entity in the S/4HANA system.
     *
     * @param planCostRate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRate PlanCostRate} entity
     *            object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CostRateServiceBatchChangeSet deletePlanCostRate( @Nonnull final PlanCostRate planCostRate );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate ServiceCostRate}
     * entity and save it to the S/4HANA system.
     *
     * @param serviceCostRate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate ServiceCostRate}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CostRateServiceBatchChangeSet createServiceCostRate( @Nonnull final ServiceCostRate serviceCostRate );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate
     * ServiceCostRate} entity and save it to the S/4HANA system.
     *
     * @param serviceCostRate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate ServiceCostRate}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CostRateServiceBatchChangeSet updateServiceCostRate( @Nonnull final ServiceCostRate serviceCostRate );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate
     * ServiceCostRate} entity in the S/4HANA system.
     *
     * @param serviceCostRate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate ServiceCostRate}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CostRateServiceBatchChangeSet deleteServiceCostRate( @Nonnull final ServiceCostRate serviceCostRate );

}
