/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link CostRateServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostRateService CostRateService}, allowing you to create
 * multiple changesets and finally execute the batch request.
 *
 */
public class DefaultCostRateServiceBatch
    extends
    BatchFluentHelperBasic<CostRateServiceBatch, CostRateServiceBatchChangeSet>
    implements
    CostRateServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostRateService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultCostRateServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCostRateServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostRateService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostRateService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultCostRateServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCostRateServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostRateService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultCostRateServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CostRateServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultCostRateServiceBatchChangeSet(this, service);
    }

}
