/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.PlanCostRate;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate;

/**
 * Implementation of the {@link CostRateServiceBatchChangeSet} interface, enabling you to combine multiple operations
 * into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostRateService CostRateService}.
 *
 */
public class DefaultCostRateServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<CostRateServiceBatch, CostRateServiceBatchChangeSet>
    implements
    CostRateServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostRateService service;

    @SuppressWarnings( "deprecation" )
    DefaultCostRateServiceBatchChangeSet(
        @Nonnull final DefaultCostRateServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CostRateService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultCostRateServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CostRateServiceBatchChangeSet createActualCostRate( @Nonnull final ActualCostRate actualCostRate )
    {
        return addRequestCreate(service::createActualCostRate, actualCostRate);
    }

    @Nonnull
    @Override
    public CostRateServiceBatchChangeSet updateActualCostRate( @Nonnull final ActualCostRate actualCostRate )
    {
        return addRequestUpdate(service::updateActualCostRate, actualCostRate);
    }

    @Nonnull
    @Override
    public CostRateServiceBatchChangeSet deleteActualCostRate( @Nonnull final ActualCostRate actualCostRate )
    {
        return addRequestDelete(service::deleteActualCostRate, actualCostRate);
    }

    @Nonnull
    @Override
    public CostRateServiceBatchChangeSet createPlanCostRate( @Nonnull final PlanCostRate planCostRate )
    {
        return addRequestCreate(service::createPlanCostRate, planCostRate);
    }

    @Nonnull
    @Override
    public CostRateServiceBatchChangeSet updatePlanCostRate( @Nonnull final PlanCostRate planCostRate )
    {
        return addRequestUpdate(service::updatePlanCostRate, planCostRate);
    }

    @Nonnull
    @Override
    public CostRateServiceBatchChangeSet deletePlanCostRate( @Nonnull final PlanCostRate planCostRate )
    {
        return addRequestDelete(service::deletePlanCostRate, planCostRate);
    }

    @Nonnull
    @Override
    public CostRateServiceBatchChangeSet createServiceCostRate( @Nonnull final ServiceCostRate serviceCostRate )
    {
        return addRequestCreate(service::createServiceCostRate, serviceCostRate);
    }

    @Nonnull
    @Override
    public CostRateServiceBatchChangeSet updateServiceCostRate( @Nonnull final ServiceCostRate serviceCostRate )
    {
        return addRequestUpdate(service::updateServiceCostRate, serviceCostRate);
    }

    @Nonnull
    @Override
    public CostRateServiceBatchChangeSet deleteServiceCostRate( @Nonnull final ServiceCostRate serviceCostRate )
    {
        return addRequestDelete(service::deleteServiceCostRate, serviceCostRate);
    }

}
