/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate ActualCostRate}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.field.ActualCostRateField
 * ActualCostRateField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.link.ActualCostRateLink
 * ActualCostRateLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate#ACCOUNTING_COST_RATE_UUID
 * ACCOUNTING_COST_RATE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate#COST_CENTER COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate#ACTIVITY_TYPE
 * ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate#CURRENCY CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate#VALIDITY_START_FISCAL_YEAR_PERIOD
 * VALIDITY_START_FISCAL_YEAR_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate#VALIDITY_END_FISCAL_YEAR_PERIOD
 * VALIDITY_END_FISCAL_YEAR_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate#COST_RATE_FIXED_AMOUNT
 * COST_RATE_FIXED_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate#COST_RATE_VARBL_AMOUNT
 * COST_RATE_VARBL_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate#COST_RATE_SCALE_FACTOR
 * COST_RATE_SCALE_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate#COST_CTR_ACTIVITY_TYPE_QTY_UNIT
 * COST_CTR_ACTIVITY_TYPE_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate#LEDGER LEDGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ActualCostRate#COST_RATE_IS_OVERWRITE_MODE
 * COST_RATE_IS_OVERWRITE_MODE}</li>
 * </ul>
 *
 */
public interface ActualCostRateSelectable extends EntitySelectable<ActualCostRate>
{

}
