/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate ServiceCostRate}. This interface
 * is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.field.ServiceCostRateField
 * ServiceCostRateField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.link.ServiceCostRateLink ServiceCostRateLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate#ACCOUNTING_COST_RATE_UUID
 * ACCOUNTING_COST_RATE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate#RECEIVING_COMPANY_CODE
 * RECEIVING_COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate#IS_INTERCOMPANY_RATE
 * IS_INTERCOMPANY_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate#COST_CENTER COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate#TIME_SHEET_OVERTIME_CATEGORY
 * TIME_SHEET_OVERTIME_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate#ACTIVITY_TYPE
 * ACTIVITY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate#SERVICE_COST_LEVEL
 * SERVICE_COST_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate#PERSONNEL_NUMBER
 * PERSONNEL_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate#WORK_ITEM WORK_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate#WBS_ELEMENT_EXTERNAL_ID
 * WBS_ELEMENT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate#VALIDITY_START_FISCAL_YEAR_PERIOD
 * VALIDITY_START_FISCAL_YEAR_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate#VALIDITY_END_FISCAL_YEAR_PERIOD
 * VALIDITY_END_FISCAL_YEAR_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate#CURRENCY CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate#COST_RATE_VARBL_AMOUNT
 * COST_RATE_VARBL_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate#COST_RATE_SCALE_FACTOR
 * COST_RATE_SCALE_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate#COST_CTR_ACTIVITY_TYPE_QTY_UNIT
 * COST_CTR_ACTIVITY_TYPE_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate#LEDGER LEDGER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.costrate.ServiceCostRate#COST_RATE_IS_OVERWRITE_MODE
 * COST_RATE_IS_OVERWRITE_MODE}</li>
 * </ul>
 *
 */
public interface ServiceCostRateSelectable extends EntitySelectable<ServiceCostRate>
{

}
