/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.field.CountryField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.link.CountryLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.selectable.CountrySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Country/Region
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CountryType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Country extends VdmEntity<Country>
{

    /**
     * Selector for all available fields of Country.
     *
     */
    public final static CountrySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @return Country/Region Key
     */
    @Key
    @SerializedName( "Country" )
    @JsonProperty( "Country" )
    @Nullable
    @ODataField( odataName = "Country" )
    private String country;
    /**
     * Use with available fluent helpers to apply the <b>Country</b> field to query operations.
     *
     */
    public final static CountryField<String> COUNTRY = new CountryField<String>("Country");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CountryCurrency</b>
     * </p>
     *
     * @return Reporting Currency
     */
    @SerializedName( "CountryCurrency" )
    @JsonProperty( "CountryCurrency" )
    @Nullable
    @ODataField( odataName = "CountryCurrency" )
    private String countryCurrency;
    /**
     * Use with available fluent helpers to apply the <b>CountryCurrency</b> field to query operations.
     *
     */
    public final static CountryField<String> COUNTRY_CURRENCY = new CountryField<String>("CountryCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>IndexBasedCurrency</b>
     * </p>
     *
     * @return Currency Key of the Index-Based Currency
     */
    @SerializedName( "IndexBasedCurrency" )
    @JsonProperty( "IndexBasedCurrency" )
    @Nullable
    @ODataField( odataName = "IndexBasedCurrency" )
    private String indexBasedCurrency;
    /**
     * Use with available fluent helpers to apply the <b>IndexBasedCurrency</b> field to query operations.
     *
     */
    public final static CountryField<String> INDEX_BASED_CURRENCY = new CountryField<String>("IndexBasedCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HardCurrency</b>
     * </p>
     *
     * @return Currency Key of the Hard Currency
     */
    @SerializedName( "HardCurrency" )
    @JsonProperty( "HardCurrency" )
    @Nullable
    @ODataField( odataName = "HardCurrency" )
    private String hardCurrency;
    /**
     * Use with available fluent helpers to apply the <b>HardCurrency</b> field to query operations.
     *
     */
    public final static CountryField<String> HARD_CURRENCY = new CountryField<String>("HardCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaxCalculationProcedure</b>
     * </p>
     *
     * @return Procedure (Pricing, Output Control, Acct. Det., Costing,...)
     */
    @SerializedName( "TaxCalculationProcedure" )
    @JsonProperty( "TaxCalculationProcedure" )
    @Nullable
    @ODataField( odataName = "TaxCalculationProcedure" )
    private String taxCalculationProcedure;
    /**
     * Use with available fluent helpers to apply the <b>TaxCalculationProcedure</b> field to query operations.
     *
     */
    public final static CountryField<String> TAX_CALCULATION_PROCEDURE =
        new CountryField<String>("TaxCalculationProcedure");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CountryThreeLetterISOCode</b>
     * </p>
     *
     * @return ISO Country/Region Code 3 Characters
     */
    @SerializedName( "CountryThreeLetterISOCode" )
    @JsonProperty( "CountryThreeLetterISOCode" )
    @Nullable
    @ODataField( odataName = "CountryThreeLetterISOCode" )
    private String countryThreeLetterISOCode;
    /**
     * Use with available fluent helpers to apply the <b>CountryThreeLetterISOCode</b> field to query operations.
     *
     */
    public final static CountryField<String> COUNTRY_THREE_LETTER_ISO_CODE =
        new CountryField<String>("CountryThreeLetterISOCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CountryThreeDigitISOCode</b>
     * </p>
     *
     * @return ISO Country/Region Code Numeric 3-Characters
     */
    @SerializedName( "CountryThreeDigitISOCode" )
    @JsonProperty( "CountryThreeDigitISOCode" )
    @Nullable
    @ODataField( odataName = "CountryThreeDigitISOCode" )
    private String countryThreeDigitISOCode;
    /**
     * Use with available fluent helpers to apply the <b>CountryThreeDigitISOCode</b> field to query operations.
     *
     */
    public final static CountryField<String> COUNTRY_THREE_DIGIT_ISO_CODE =
        new CountryField<String>("CountryThreeDigitISOCode");
    /**
     * Navigation property <b>to_Text</b> for <b>Country</b> to multiple <b>CountryText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CountryText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static CountryLink<CountryText> TO_TEXT = new CountryLink<CountryText>("to_Text");

    @Nonnull
    @Override
    public Class<Country> getType()
    {
        return Country.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @param country
     *            Country/Region Key
     */
    public void setCountry( @Nullable final String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CountryCurrency</b>
     * </p>
     *
     * @param countryCurrency
     *            Reporting Currency
     */
    public void setCountryCurrency( @Nullable final String countryCurrency )
    {
        rememberChangedField("CountryCurrency", this.countryCurrency);
        this.countryCurrency = countryCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>IndexBasedCurrency</b>
     * </p>
     *
     * @param indexBasedCurrency
     *            Currency Key of the Index-Based Currency
     */
    public void setIndexBasedCurrency( @Nullable final String indexBasedCurrency )
    {
        rememberChangedField("IndexBasedCurrency", this.indexBasedCurrency);
        this.indexBasedCurrency = indexBasedCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>HardCurrency</b>
     * </p>
     *
     * @param hardCurrency
     *            Currency Key of the Hard Currency
     */
    public void setHardCurrency( @Nullable final String hardCurrency )
    {
        rememberChangedField("HardCurrency", this.hardCurrency);
        this.hardCurrency = hardCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>TaxCalculationProcedure</b>
     * </p>
     *
     * @param taxCalculationProcedure
     *            Procedure (Pricing, Output Control, Acct. Det., Costing,...)
     */
    public void setTaxCalculationProcedure( @Nullable final String taxCalculationProcedure )
    {
        rememberChangedField("TaxCalculationProcedure", this.taxCalculationProcedure);
        this.taxCalculationProcedure = taxCalculationProcedure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CountryThreeLetterISOCode</b>
     * </p>
     *
     * @param countryThreeLetterISOCode
     *            ISO Country/Region Code 3 Characters
     */
    public void setCountryThreeLetterISOCode( @Nullable final String countryThreeLetterISOCode )
    {
        rememberChangedField("CountryThreeLetterISOCode", this.countryThreeLetterISOCode);
        this.countryThreeLetterISOCode = countryThreeLetterISOCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CountryThreeDigitISOCode</b>
     * </p>
     *
     * @param countryThreeDigitISOCode
     *            ISO Country/Region Code Numeric 3-Characters
     */
    public void setCountryThreeDigitISOCode( @Nullable final String countryThreeDigitISOCode )
    {
        rememberChangedField("CountryThreeDigitISOCode", this.countryThreeDigitISOCode);
        this.countryThreeDigitISOCode = countryThreeDigitISOCode;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_Country";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Country", getCountry());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Country", getCountry());
        values.put("CountryCurrency", getCountryCurrency());
        values.put("IndexBasedCurrency", getIndexBasedCurrency());
        values.put("HardCurrency", getHardCurrency());
        values.put("TaxCalculationProcedure", getTaxCalculationProcedure());
        values.put("CountryThreeLetterISOCode", getCountryThreeLetterISOCode());
        values.put("CountryThreeDigitISOCode", getCountryThreeDigitISOCode());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((String) value));
                }
            }
            if( values.containsKey("CountryCurrency") ) {
                final Object value = values.remove("CountryCurrency");
                if( (value == null) || (!value.equals(getCountryCurrency())) ) {
                    setCountryCurrency(((String) value));
                }
            }
            if( values.containsKey("IndexBasedCurrency") ) {
                final Object value = values.remove("IndexBasedCurrency");
                if( (value == null) || (!value.equals(getIndexBasedCurrency())) ) {
                    setIndexBasedCurrency(((String) value));
                }
            }
            if( values.containsKey("HardCurrency") ) {
                final Object value = values.remove("HardCurrency");
                if( (value == null) || (!value.equals(getHardCurrency())) ) {
                    setHardCurrency(((String) value));
                }
            }
            if( values.containsKey("TaxCalculationProcedure") ) {
                final Object value = values.remove("TaxCalculationProcedure");
                if( (value == null) || (!value.equals(getTaxCalculationProcedure())) ) {
                    setTaxCalculationProcedure(((String) value));
                }
            }
            if( values.containsKey("CountryThreeLetterISOCode") ) {
                final Object value = values.remove("CountryThreeLetterISOCode");
                if( (value == null) || (!value.equals(getCountryThreeLetterISOCode())) ) {
                    setCountryThreeLetterISOCode(((String) value));
                }
            }
            if( values.containsKey("CountryThreeDigitISOCode") ) {
                final Object value = values.remove("CountryThreeDigitISOCode");
                if( (value == null) || (!value.equals(getCountryThreeDigitISOCode())) ) {
                    setCountryThreeDigitISOCode(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CountryText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new CountryText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CountryField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CountryField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CountryField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CountryField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CountryService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>CountryText</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CountryText</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CountryText> fetchText()
    {
        return fetchFieldAsList("to_Text", CountryText.class);
    }

    /**
     * Retrieval of associated <b>CountryText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>Country</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CountryText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CountryText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>CountryText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>Country</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>CountryText</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<CountryText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>CountryText</b> entities for the loaded navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>Country</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CountryText</b> entities.
     */
    public void setText( @Nonnull final List<CountryText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CountryText</b> entities. This corresponds to the OData navigation
     * property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>Country</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CountryText</b> entities.
     */
    public void addText( CountryText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of Country instances.
     *
     */
    public final static class CountryBuilder
    {

        private List<CountryText> toText = Lists.newArrayList();

        private Country.CountryBuilder toText( final List<CountryText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>Country</b> to multiple <b>CountryText</b>.
         *
         * @param value
         *            The CountryTexts to build this Country with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Country.CountryBuilder text( CountryText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
