/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.field.CountryTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.link.CountryTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.selectable.CountryTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Country/Region Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_CountryTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CountryText extends VdmEntity<CountryText>
{

    /**
     * Selector for all available fields of CountryText.
     *
     */
    public final static CountryTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @return Country/Region Key
     */
    @Key
    @SerializedName( "Country" )
    @JsonProperty( "Country" )
    @Nullable
    @ODataField( odataName = "Country" )
    private String country;
    /**
     * Use with available fluent helpers to apply the <b>Country</b> field to query operations.
     *
     */
    public final static CountryTextField<String> COUNTRY = new CountryTextField<String>("Country");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static CountryTextField<String> LANGUAGE = new CountryTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CountryName</b>
     * </p>
     *
     * @return Country/Region Name
     */
    @SerializedName( "CountryName" )
    @JsonProperty( "CountryName" )
    @Nullable
    @ODataField( odataName = "CountryName" )
    private String countryName;
    /**
     * Use with available fluent helpers to apply the <b>CountryName</b> field to query operations.
     *
     */
    public final static CountryTextField<String> COUNTRY_NAME = new CountryTextField<String>("CountryName");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>NationalityName</b>
     * </p>
     *
     * @return Nationality
     */
    @SerializedName( "NationalityName" )
    @JsonProperty( "NationalityName" )
    @Nullable
    @ODataField( odataName = "NationalityName" )
    private String nationalityName;
    /**
     * Use with available fluent helpers to apply the <b>NationalityName</b> field to query operations.
     *
     */
    public final static CountryTextField<String> NATIONALITY_NAME = new CountryTextField<String>("NationalityName");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>NationalityLongName</b>
     * </p>
     *
     * @return Nationality (Max. 50 Characters)
     */
    @SerializedName( "NationalityLongName" )
    @JsonProperty( "NationalityLongName" )
    @Nullable
    @ODataField( odataName = "NationalityLongName" )
    private String nationalityLongName;
    /**
     * Use with available fluent helpers to apply the <b>NationalityLongName</b> field to query operations.
     *
     */
    public final static CountryTextField<String> NATIONALITY_LONG_NAME =
        new CountryTextField<String>("NationalityLongName");
    /**
     * Navigation property <b>to_Country</b> for <b>CountryText</b> to single <b>Country</b>.
     *
     */
    @SerializedName( "to_Country" )
    @JsonProperty( "to_Country" )
    @ODataField( odataName = "to_Country" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Country toCountry;
    /**
     * Use with available fluent helpers to apply the <b>to_Country</b> navigation property to query operations.
     *
     */
    public final static CountryTextOneToOneLink<Country> TO_COUNTRY =
        new CountryTextOneToOneLink<Country>("to_Country");

    @Nonnull
    @Override
    public Class<CountryText> getType()
    {
        return CountryText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @param country
     *            Country/Region Key
     */
    public void setCountry( @Nullable final String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CountryName</b>
     * </p>
     *
     * @param countryName
     *            Country/Region Name
     */
    public void setCountryName( @Nullable final String countryName )
    {
        rememberChangedField("CountryName", this.countryName);
        this.countryName = countryName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>NationalityName</b>
     * </p>
     *
     * @param nationalityName
     *            Nationality
     */
    public void setNationalityName( @Nullable final String nationalityName )
    {
        rememberChangedField("NationalityName", this.nationalityName);
        this.nationalityName = nationalityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>NationalityLongName</b>
     * </p>
     *
     * @param nationalityLongName
     *            Nationality (Max. 50 Characters)
     */
    public void setNationalityLongName( @Nullable final String nationalityLongName )
    {
        rememberChangedField("NationalityLongName", this.nationalityLongName);
        this.nationalityLongName = nationalityLongName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_CountryText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Country", getCountry());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Country", getCountry());
        values.put("Language", getLanguage());
        values.put("CountryName", getCountryName());
        values.put("NationalityName", getNationalityName());
        values.put("NationalityLongName", getNationalityLongName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("CountryName") ) {
                final Object value = values.remove("CountryName");
                if( (value == null) || (!value.equals(getCountryName())) ) {
                    setCountryName(((String) value));
                }
            }
            if( values.containsKey("NationalityName") ) {
                final Object value = values.remove("NationalityName");
                if( (value == null) || (!value.equals(getNationalityName())) ) {
                    setNationalityName(((String) value));
                }
            }
            if( values.containsKey("NationalityLongName") ) {
                final Object value = values.remove("NationalityLongName");
                if( (value == null) || (!value.equals(getNationalityLongName())) ) {
                    setNationalityLongName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Country") ) {
                final Object value = (values).remove("to_Country");
                if( value instanceof Map ) {
                    if( toCountry == null ) {
                        toCountry = new Country();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCountry.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CountryTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CountryTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CountryTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CountryTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CountryService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCountry != null ) {
            (values).put("to_Country", toCountry);
        }
        return values;
    }

    /**
     * Fetches the <b>Country</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Country</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Country</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Country fetchCountry()
    {
        return fetchFieldAsSingle("to_Country", Country.class);
    }

    /**
     * Retrieval of associated <b>Country</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Country</b>.
     * <p>
     * If the navigation property <b>to_Country</b> of a queried <b>CountryText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Country</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Country getCountryOrFetch()
    {
        if( toCountry == null ) {
            toCountry = fetchCountry();
        }
        return toCountry;
    }

    /**
     * Retrieval of associated <b>Country</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Country</b>.
     * <p>
     * If the navigation property for an entity <b>CountryText</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Country</b> is already loaded, the result will contain
     *         the <b>Country</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<Country> getCountryIfPresent()
    {
        return Option.of(toCountry);
    }

    /**
     * Overwrites the associated <b>Country</b> entity for the loaded navigation property <b>to_Country</b>.
     *
     * @param value
     *            New <b>Country</b> entity.
     */
    public void setCountry( final Country value )
    {
        toCountry = value;
    }

    /**
     * Helper class to allow for fluent creation of CountryText instances.
     *
     */
    public final static class CountryTextBuilder
    {

        private Country toCountry;
        private String country = null;

        private CountryText.CountryTextBuilder toCountry( final Country value )
        {
            toCountry = value;
            return this;
        }

        /**
         * Navigation property <b>to_Country</b> for <b>CountryText</b> to single <b>Country</b>.
         *
         * @param value
         *            The Country to build this CountryText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CountryText.CountryTextBuilder country( final Country value )
        {
            return toCountry(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 3
         * <p>
         * Original property name from the Odata EDM: <b>Country</b>
         * </p>
         *
         * @param value
         *            The country to build this CountryText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CountryText.CountryTextBuilder country( final String value )
        {
            country = value;
            return this;
        }

    }

}
