/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link CountryServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CountryService CountryService}, allowing you to create
 * multiple changesets and finally execute the batch request.
 *
 */
public class DefaultCountryServiceBatch
    extends
    BatchFluentHelperBasic<CountryServiceBatch, CountryServiceBatchChangeSet>
    implements
    CountryServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CountryService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultCountryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCountryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CountryService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.CountryService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultCountryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultCountryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CountryService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultCountryServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CountryServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultCountryServiceBatchChangeSet(this, service);
    }

}
