/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link CountryServiceBatchChangeSet} interface, enabling you to combine multiple operations
 * into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CountryService CountryService}.
 *
 */
public class DefaultCountryServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<CountryServiceBatch, CountryServiceBatchChangeSet>
    implements
    CountryServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CountryService service;

    @SuppressWarnings( "deprecation" )
    DefaultCountryServiceBatchChangeSet(
        @Nonnull final DefaultCountryServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CountryService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultCountryServiceBatchChangeSet getThis()
    {
        return this;
    }

}
