/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.Country;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.Country Country}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.field.CountryField CountryField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.link.CountryLink CountryLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.Country#COUNTRY COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.Country#COUNTRY_CURRENCY
 * COUNTRY_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.Country#INDEX_BASED_CURRENCY
 * INDEX_BASED_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.Country#HARD_CURRENCY HARD_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.Country#TAX_CALCULATION_PROCEDURE
 * TAX_CALCULATION_PROCEDURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.Country#COUNTRY_THREE_LETTER_ISO_CODE
 * COUNTRY_THREE_LETTER_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.Country#COUNTRY_THREE_DIGIT_ISO_CODE
 * COUNTRY_THREE_DIGIT_ISO_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.Country#TO_TEXT TO_TEXT}</li>
 * </ul>
 *
 */
public interface CountrySelectable extends EntitySelectable<Country>
{

}
