/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.CountryText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.CountryText CountryText}. This interface is used
 * by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.field.CountryTextField CountryTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.link.CountryTextLink CountryTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.CountryText#COUNTRY COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.CountryText#LANGUAGE LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.CountryText#COUNTRY_NAME COUNTRY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.CountryText#NATIONALITY_NAME
 * NATIONALITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.CountryText#NATIONALITY_LONG_NAME
 * NATIONALITY_LONG_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.country.CountryText#TO_COUNTRY TO_COUNTRY}</li>
 * </ul>
 *
 */
public interface CountryTextSelectable extends EntitySelectable<CountryText>
{

}
