/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.field.CrdtMAcctCollateralField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.link.CrdtMAcctCollateralOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.selectable.CrdtMAcctCollateralSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Credit Account Collaterals
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CrdtMAcctCollateral_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CrdtMAcctCollateral extends VdmEntity<CrdtMAcctCollateral>
{

    /**
     * Selector for all available fields of CrdtMAcctCollateral.
     *
     */
    public final static CrdtMAcctCollateralSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @Key
    @SerializedName( "BusinessPartner" )
    @JsonProperty( "BusinessPartner" )
    @Nullable
    @ODataField( odataName = "BusinessPartner" )
    private String businessPartner;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartner</b> field to query operations.
     *
     */
    public final static CrdtMAcctCollateralField<String> BUSINESS_PARTNER =
        new CrdtMAcctCollateralField<String>("BusinessPartner");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CreditSegment</b>
     * </p>
     *
     * @return Credit Segment
     */
    @Key
    @SerializedName( "CreditSegment" )
    @JsonProperty( "CreditSegment" )
    @Nullable
    @ODataField( odataName = "CreditSegment" )
    private String creditSegment;
    /**
     * Use with available fluent helpers to apply the <b>CreditSegment</b> field to query operations.
     *
     */
    public final static CrdtMAcctCollateralField<String> CREDIT_SEGMENT =
        new CrdtMAcctCollateralField<String>("CreditSegment");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CrdtAcctInformationCategory</b>
     * </p>
     *
     * @return Information Category
     */
    @Key
    @SerializedName( "CrdtAcctInformationCategory" )
    @JsonProperty( "CrdtAcctInformationCategory" )
    @Nullable
    @ODataField( odataName = "CrdtAcctInformationCategory" )
    private String crdtAcctInformationCategory;
    /**
     * Use with available fluent helpers to apply the <b>CrdtAcctInformationCategory</b> field to query operations.
     *
     */
    public final static CrdtMAcctCollateralField<String> CRDT_ACCT_INFORMATION_CATEGORY =
        new CrdtMAcctCollateralField<String>("CrdtAcctInformationCategory");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CrdtAcctInformationType</b>
     * </p>
     *
     * @return Information Type
     */
    @Key
    @SerializedName( "CrdtAcctInformationType" )
    @JsonProperty( "CrdtAcctInformationType" )
    @Nullable
    @ODataField( odataName = "CrdtAcctInformationType" )
    private String crdtAcctInformationType;
    /**
     * Use with available fluent helpers to apply the <b>CrdtAcctInformationType</b> field to query operations.
     *
     */
    public final static CrdtMAcctCollateralField<String> CRDT_ACCT_INFORMATION_TYPE =
        new CrdtMAcctCollateralField<String>("CrdtAcctInformationType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCreditDocSequence</b>
     * </p>
     *
     * @return Counter
     */
    @Key
    @SerializedName( "AdditionalCreditDocSequence" )
    @JsonProperty( "AdditionalCreditDocSequence" )
    @Nullable
    @ODataField( odataName = "AdditionalCreditDocSequence" )
    private String additionalCreditDocSequence;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCreditDocSequence</b> field to query operations.
     *
     */
    public final static CrdtMAcctCollateralField<String> ADDITIONAL_CREDIT_DOC_SEQUENCE =
        new CrdtMAcctCollateralField<String>("AdditionalCreditDocSequence");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ExceptionIsCreditCheckRelevant</b>
     * </p>
     *
     * @return Relevance for Credit Check
     */
    @SerializedName( "ExceptionIsCreditCheckRelevant" )
    @JsonProperty( "ExceptionIsCreditCheckRelevant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ExceptionIsCreditCheckRelevant" )
    private Boolean exceptionIsCreditCheckRelevant;
    /**
     * Use with available fluent helpers to apply the <b>ExceptionIsCreditCheckRelevant</b> field to query operations.
     *
     */
    public final static CrdtMAcctCollateralField<Boolean> EXCEPTION_IS_CREDIT_CHECK_RELEVANT =
        new CrdtMAcctCollateralField<Boolean>("ExceptionIsCreditCheckRelevant");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AddlCreditDocAmtInTransacCrcy</b>
     * </p>
     *
     * @return Amount
     */
    @SerializedName( "AddlCreditDocAmtInTransacCrcy" )
    @JsonProperty( "AddlCreditDocAmtInTransacCrcy" )
    @Nullable
    @ODataField( odataName = "AddlCreditDocAmtInTransacCrcy" )
    private BigDecimal addlCreditDocAmtInTransacCrcy;
    /**
     * Use with available fluent helpers to apply the <b>AddlCreditDocAmtInTransacCrcy</b> field to query operations.
     *
     */
    public final static CrdtMAcctCollateralField<BigDecimal> ADDL_CREDIT_DOC_AMT_IN_TRANSAC_CRCY =
        new CrdtMAcctCollateralField<BigDecimal>("AddlCreditDocAmtInTransacCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static CrdtMAcctCollateralField<String> TRANSACTION_CURRENCY =
        new CrdtMAcctCollateralField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Start Date of Validity
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static CrdtMAcctCollateralField<LocalDateTime> VALIDITY_START_DATE =
        new CrdtMAcctCollateralField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return End Date of Validity
     */
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static CrdtMAcctCollateralField<LocalDateTime> VALIDITY_END_DATE =
        new CrdtMAcctCollateralField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCreditDocComment</b>
     * </p>
     *
     * @return Additional Information
     */
    @SerializedName( "AdditionalCreditDocComment" )
    @JsonProperty( "AdditionalCreditDocComment" )
    @Nullable
    @ODataField( odataName = "AdditionalCreditDocComment" )
    private String additionalCreditDocComment;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCreditDocComment</b> field to query operations.
     *
     */
    public final static CrdtMAcctCollateralField<String> ADDITIONAL_CREDIT_DOC_COMMENT =
        new CrdtMAcctCollateralField<String>("AdditionalCreditDocComment");
    /**
     * Navigation property <b>to_CrdtMBusinessPartnerTP</b> for <b>CrdtMAcctCollateral</b> to single
     * <b>CreditMgmtBusinessPartner</b>.
     *
     */
    @SerializedName( "to_CrdtMBusinessPartnerTP" )
    @JsonProperty( "to_CrdtMBusinessPartnerTP" )
    @ODataField( odataName = "to_CrdtMBusinessPartnerTP" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CreditMgmtBusinessPartner toCrdtMBusinessPartnerTP;
    /**
     * Navigation property <b>to_CreditMgmtAccountTP</b> for <b>CrdtMAcctCollateral</b> to single
     * <b>CreditManagementAccount</b>.
     *
     */
    @SerializedName( "to_CreditMgmtAccountTP" )
    @JsonProperty( "to_CreditMgmtAccountTP" )
    @ODataField( odataName = "to_CreditMgmtAccountTP" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CreditManagementAccount toCreditMgmtAccountTP;
    /**
     * Use with available fluent helpers to apply the <b>to_CrdtMBusinessPartnerTP</b> navigation property to query
     * operations.
     *
     */
    public final static CrdtMAcctCollateralOneToOneLink<CreditMgmtBusinessPartner> TO_CRDT_M_BUSINESS_PARTNER_TP =
        new CrdtMAcctCollateralOneToOneLink<CreditMgmtBusinessPartner>("to_CrdtMBusinessPartnerTP");
    /**
     * Use with available fluent helpers to apply the <b>to_CreditMgmtAccountTP</b> navigation property to query
     * operations.
     *
     */
    public final static CrdtMAcctCollateralOneToOneLink<CreditManagementAccount> TO_CREDIT_MGMT_ACCOUNT_TP =
        new CrdtMAcctCollateralOneToOneLink<CreditManagementAccount>("to_CreditMgmtAccountTP");

    @Nonnull
    @Override
    public Class<CrdtMAcctCollateral> getType()
    {
        return CrdtMAcctCollateral.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @param businessPartner
     *            Business Partner Number
     */
    public void setBusinessPartner( @Nullable final String businessPartner )
    {
        rememberChangedField("BusinessPartner", this.businessPartner);
        this.businessPartner = businessPartner;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CreditSegment</b>
     * </p>
     *
     * @param creditSegment
     *            Credit Segment
     */
    public void setCreditSegment( @Nullable final String creditSegment )
    {
        rememberChangedField("CreditSegment", this.creditSegment);
        this.creditSegment = creditSegment;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CrdtAcctInformationCategory</b>
     * </p>
     *
     * @param crdtAcctInformationCategory
     *            Information Category
     */
    public void setCrdtAcctInformationCategory( @Nullable final String crdtAcctInformationCategory )
    {
        rememberChangedField("CrdtAcctInformationCategory", this.crdtAcctInformationCategory);
        this.crdtAcctInformationCategory = crdtAcctInformationCategory;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CrdtAcctInformationType</b>
     * </p>
     *
     * @param crdtAcctInformationType
     *            Information Type
     */
    public void setCrdtAcctInformationType( @Nullable final String crdtAcctInformationType )
    {
        rememberChangedField("CrdtAcctInformationType", this.crdtAcctInformationType);
        this.crdtAcctInformationType = crdtAcctInformationType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCreditDocSequence</b>
     * </p>
     *
     * @param additionalCreditDocSequence
     *            Counter
     */
    public void setAdditionalCreditDocSequence( @Nullable final String additionalCreditDocSequence )
    {
        rememberChangedField("AdditionalCreditDocSequence", this.additionalCreditDocSequence);
        this.additionalCreditDocSequence = additionalCreditDocSequence;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ExceptionIsCreditCheckRelevant</b>
     * </p>
     *
     * @param exceptionIsCreditCheckRelevant
     *            Relevance for Credit Check
     */
    public void setExceptionIsCreditCheckRelevant( @Nullable final Boolean exceptionIsCreditCheckRelevant )
    {
        rememberChangedField("ExceptionIsCreditCheckRelevant", this.exceptionIsCreditCheckRelevant);
        this.exceptionIsCreditCheckRelevant = exceptionIsCreditCheckRelevant;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AddlCreditDocAmtInTransacCrcy</b>
     * </p>
     *
     * @param addlCreditDocAmtInTransacCrcy
     *            Amount
     */
    public void setAddlCreditDocAmtInTransacCrcy( @Nullable final BigDecimal addlCreditDocAmtInTransacCrcy )
    {
        rememberChangedField("AddlCreditDocAmtInTransacCrcy", this.addlCreditDocAmtInTransacCrcy);
        this.addlCreditDocAmtInTransacCrcy = addlCreditDocAmtInTransacCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Start Date of Validity
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            End Date of Validity
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCreditDocComment</b>
     * </p>
     *
     * @param additionalCreditDocComment
     *            Additional Information
     */
    public void setAdditionalCreditDocComment( @Nullable final String additionalCreditDocComment )
    {
        rememberChangedField("AdditionalCreditDocComment", this.additionalCreditDocComment);
        this.additionalCreditDocComment = additionalCreditDocComment;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CrdtMAcctCollateral";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessPartner", getBusinessPartner());
        result.put("CreditSegment", getCreditSegment());
        result.put("CrdtAcctInformationCategory", getCrdtAcctInformationCategory());
        result.put("CrdtAcctInformationType", getCrdtAcctInformationType());
        result.put("AdditionalCreditDocSequence", getAdditionalCreditDocSequence());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessPartner", getBusinessPartner());
        values.put("CreditSegment", getCreditSegment());
        values.put("CrdtAcctInformationCategory", getCrdtAcctInformationCategory());
        values.put("CrdtAcctInformationType", getCrdtAcctInformationType());
        values.put("AdditionalCreditDocSequence", getAdditionalCreditDocSequence());
        values.put("ExceptionIsCreditCheckRelevant", getExceptionIsCreditCheckRelevant());
        values.put("AddlCreditDocAmtInTransacCrcy", getAddlCreditDocAmtInTransacCrcy());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("AdditionalCreditDocComment", getAdditionalCreditDocComment());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessPartner") ) {
                final Object value = values.remove("BusinessPartner");
                if( (value == null) || (!value.equals(getBusinessPartner())) ) {
                    setBusinessPartner(((String) value));
                }
            }
            if( values.containsKey("CreditSegment") ) {
                final Object value = values.remove("CreditSegment");
                if( (value == null) || (!value.equals(getCreditSegment())) ) {
                    setCreditSegment(((String) value));
                }
            }
            if( values.containsKey("CrdtAcctInformationCategory") ) {
                final Object value = values.remove("CrdtAcctInformationCategory");
                if( (value == null) || (!value.equals(getCrdtAcctInformationCategory())) ) {
                    setCrdtAcctInformationCategory(((String) value));
                }
            }
            if( values.containsKey("CrdtAcctInformationType") ) {
                final Object value = values.remove("CrdtAcctInformationType");
                if( (value == null) || (!value.equals(getCrdtAcctInformationType())) ) {
                    setCrdtAcctInformationType(((String) value));
                }
            }
            if( values.containsKey("AdditionalCreditDocSequence") ) {
                final Object value = values.remove("AdditionalCreditDocSequence");
                if( (value == null) || (!value.equals(getAdditionalCreditDocSequence())) ) {
                    setAdditionalCreditDocSequence(((String) value));
                }
            }
            if( values.containsKey("ExceptionIsCreditCheckRelevant") ) {
                final Object value = values.remove("ExceptionIsCreditCheckRelevant");
                if( (value == null) || (!value.equals(getExceptionIsCreditCheckRelevant())) ) {
                    setExceptionIsCreditCheckRelevant(((Boolean) value));
                }
            }
            if( values.containsKey("AddlCreditDocAmtInTransacCrcy") ) {
                final Object value = values.remove("AddlCreditDocAmtInTransacCrcy");
                if( (value == null) || (!value.equals(getAddlCreditDocAmtInTransacCrcy())) ) {
                    setAddlCreditDocAmtInTransacCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("AdditionalCreditDocComment") ) {
                final Object value = values.remove("AdditionalCreditDocComment");
                if( (value == null) || (!value.equals(getAdditionalCreditDocComment())) ) {
                    setAdditionalCreditDocComment(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CrdtMBusinessPartnerTP") ) {
                final Object value = (values).remove("to_CrdtMBusinessPartnerTP");
                if( value instanceof Map ) {
                    if( toCrdtMBusinessPartnerTP == null ) {
                        toCrdtMBusinessPartnerTP = new CreditMgmtBusinessPartner();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCrdtMBusinessPartnerTP.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CreditMgmtAccountTP") ) {
                final Object value = (values).remove("to_CreditMgmtAccountTP");
                if( value instanceof Map ) {
                    if( toCreditMgmtAccountTP == null ) {
                        toCreditMgmtAccountTP = new CreditManagementAccount();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCreditMgmtAccountTP.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CrdtMAcctCollateralField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CrdtMAcctCollateralField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CrdtMAcctCollateralField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CrdtMAcctCollateralField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditManagementMasterDataService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCrdtMBusinessPartnerTP != null ) {
            (values).put("to_CrdtMBusinessPartnerTP", toCrdtMBusinessPartnerTP);
        }
        if( toCreditMgmtAccountTP != null ) {
            (values).put("to_CreditMgmtAccountTP", toCreditMgmtAccountTP);
        }
        return values;
    }

    /**
     * Fetches the <b>CreditMgmtBusinessPartner</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CrdtMBusinessPartnerTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CreditMgmtBusinessPartner</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CreditMgmtBusinessPartner fetchCrdtMBusinessPartnerTP()
    {
        return fetchFieldAsSingle("to_CrdtMBusinessPartnerTP", CreditMgmtBusinessPartner.class);
    }

    /**
     * Retrieval of associated <b>CreditMgmtBusinessPartner</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CrdtMBusinessPartnerTP</b>.
     * <p>
     * If the navigation property <b>to_CrdtMBusinessPartnerTP</b> of a queried <b>CrdtMAcctCollateral</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CreditMgmtBusinessPartner</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CreditMgmtBusinessPartner getCrdtMBusinessPartnerTPOrFetch()
    {
        if( toCrdtMBusinessPartnerTP == null ) {
            toCrdtMBusinessPartnerTP = fetchCrdtMBusinessPartnerTP();
        }
        return toCrdtMBusinessPartnerTP;
    }

    /**
     * Retrieval of associated <b>CreditMgmtBusinessPartner</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CrdtMBusinessPartnerTP</b>.
     * <p>
     * If the navigation property for an entity <b>CrdtMAcctCollateral</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CrdtMBusinessPartnerTP</b> is already loaded, the result
     *         will contain the <b>CreditMgmtBusinessPartner</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CreditMgmtBusinessPartner> getCrdtMBusinessPartnerTPIfPresent()
    {
        return Option.of(toCrdtMBusinessPartnerTP);
    }

    /**
     * Overwrites the associated <b>CreditMgmtBusinessPartner</b> entity for the loaded navigation property
     * <b>to_CrdtMBusinessPartnerTP</b>.
     *
     * @param value
     *            New <b>CreditMgmtBusinessPartner</b> entity.
     */
    public void setCrdtMBusinessPartnerTP( final CreditMgmtBusinessPartner value )
    {
        toCrdtMBusinessPartnerTP = value;
    }

    /**
     * Fetches the <b>CreditManagementAccount</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CreditMgmtAccountTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CreditManagementAccount</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CreditManagementAccount fetchCreditMgmtAccountTP()
    {
        return fetchFieldAsSingle("to_CreditMgmtAccountTP", CreditManagementAccount.class);
    }

    /**
     * Retrieval of associated <b>CreditManagementAccount</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CreditMgmtAccountTP</b>.
     * <p>
     * If the navigation property <b>to_CreditMgmtAccountTP</b> of a queried <b>CrdtMAcctCollateral</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CreditManagementAccount</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CreditManagementAccount getCreditMgmtAccountTPOrFetch()
    {
        if( toCreditMgmtAccountTP == null ) {
            toCreditMgmtAccountTP = fetchCreditMgmtAccountTP();
        }
        return toCreditMgmtAccountTP;
    }

    /**
     * Retrieval of associated <b>CreditManagementAccount</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CreditMgmtAccountTP</b>.
     * <p>
     * If the navigation property for an entity <b>CrdtMAcctCollateral</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CreditMgmtAccountTP</b> is already loaded, the result
     *         will contain the <b>CreditManagementAccount</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CreditManagementAccount> getCreditMgmtAccountTPIfPresent()
    {
        return Option.of(toCreditMgmtAccountTP);
    }

    /**
     * Overwrites the associated <b>CreditManagementAccount</b> entity for the loaded navigation property
     * <b>to_CreditMgmtAccountTP</b>.
     *
     * @param value
     *            New <b>CreditManagementAccount</b> entity.
     */
    public void setCreditMgmtAccountTP( final CreditManagementAccount value )
    {
        toCreditMgmtAccountTP = value;
    }

    /**
     * Helper class to allow for fluent creation of CrdtMAcctCollateral instances.
     *
     */
    public final static class CrdtMAcctCollateralBuilder
    {

        private CreditMgmtBusinessPartner toCrdtMBusinessPartnerTP;
        private CreditManagementAccount toCreditMgmtAccountTP;

        private CrdtMAcctCollateral.CrdtMAcctCollateralBuilder toCrdtMBusinessPartnerTP(
            final CreditMgmtBusinessPartner value )
        {
            toCrdtMBusinessPartnerTP = value;
            return this;
        }

        /**
         * Navigation property <b>to_CrdtMBusinessPartnerTP</b> for <b>CrdtMAcctCollateral</b> to single
         * <b>CreditMgmtBusinessPartner</b>.
         *
         * @param value
         *            The CreditMgmtBusinessPartner to build this CrdtMAcctCollateral with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CrdtMAcctCollateral.CrdtMAcctCollateralBuilder crdtMBusinessPartnerTP(
            final CreditMgmtBusinessPartner value )
        {
            return toCrdtMBusinessPartnerTP(value);
        }

        private CrdtMAcctCollateral.CrdtMAcctCollateralBuilder toCreditMgmtAccountTP(
            final CreditManagementAccount value )
        {
            toCreditMgmtAccountTP = value;
            return this;
        }

        /**
         * Navigation property <b>to_CreditMgmtAccountTP</b> for <b>CrdtMAcctCollateral</b> to single
         * <b>CreditManagementAccount</b>.
         *
         * @param value
         *            The CreditManagementAccount to build this CrdtMAcctCollateral with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CrdtMAcctCollateral.CrdtMAcctCollateralBuilder creditMgmtAccountTP( final CreditManagementAccount value )
        {
            return toCreditMgmtAccountTP(value);
        }

    }

}
