/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperDelete;

/**
 * Fluent helper to delete an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateral
 * CrdtMAcctCollateral} entity in the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class CrdtMAcctCollateralDeleteFluentHelper
    extends
    FluentHelperDelete<CrdtMAcctCollateralDeleteFluentHelper, CrdtMAcctCollateral>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateral
     * CrdtMAcctCollateral} entity object that will be deleted in the S/4HANA system.
     *
     */
    private final CrdtMAcctCollateral entity;

    /**
     * Creates a fluent helper object that will delete a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateral
     * CrdtMAcctCollateral} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            The entity collection to direct the update requests to.
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The CrdtMAcctCollateral to delete from the endpoint.
     */
    public CrdtMAcctCollateralDeleteFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final CrdtMAcctCollateral entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected CrdtMAcctCollateral getEntity()
    {
        return entity;
    }

}
