/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperUpdate;

/**
 * Fluent helper to update an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral
 * CrdtMgmtBPCollateral} entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class CrdtMgmtBPCollateralUpdateFluentHelper
    extends
    FluentHelperUpdate<CrdtMgmtBPCollateralUpdateFluentHelper, CrdtMgmtBPCollateral>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral
     * CrdtMgmtBPCollateral} entity object that will be updated in the S/4HANA system.
     *
     */
    private final CrdtMgmtBPCollateral entity;

    /**
     * Creates a fluent helper object that will update a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral
     * CrdtMgmtBPCollateral} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The CrdtMgmtBPCollateral to take the updated values from.
     */
    public CrdtMgmtBPCollateralUpdateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final CrdtMgmtBPCollateral entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected CrdtMgmtBPCollateral getEntity()
    {
        return entity;
    }

}
