/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.selectable.CrdtMgmtBPNegativeEventSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent
 * CrdtMgmtBPNegativeEvent} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class CrdtMgmtBPNegativeEventByKeyFluentHelper
    extends
    FluentHelperByKey<CrdtMgmtBPNegativeEventByKeyFluentHelper, CrdtMgmtBPNegativeEvent, CrdtMgmtBPNegativeEventSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent
     * CrdtMgmtBPNegativeEvent} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code CrdtMgmtBPNegativeEvent}
     * @param creditSegment
     *            Credit Segment
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param additionalCreditDocSequence
     *            Counter
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param businessPartner
     *            Business Partner Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param crdtAcctInformationType
     *            Information Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code CrdtMgmtBPNegativeEvent}
     * @param crdtAcctInformationCategory
     *            Information Category
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     */
    public CrdtMgmtBPNegativeEventByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String businessPartner,
        final String creditSegment,
        final String crdtAcctInformationCategory,
        final String crdtAcctInformationType,
        final String additionalCreditDocSequence )
    {
        super(servicePath, entityCollection);
        this.key.put("BusinessPartner", businessPartner);
        this.key.put("CreditSegment", creditSegment);
        this.key.put("CrdtAcctInformationCategory", crdtAcctInformationCategory);
        this.key.put("CrdtAcctInformationType", crdtAcctInformationType);
        this.key.put("AdditionalCreditDocSequence", additionalCreditDocSequence);
    }

    @Override
    @Nonnull
    protected Class<CrdtMgmtBPNegativeEvent> getEntityClass()
    {
        return CrdtMgmtBPNegativeEvent.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
