/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.field.CreditManagementAccountField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.link.CreditManagementAccountLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.link.CreditManagementAccountOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.selectable.CreditManagementAccountSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Credit Accounts
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CreditManagementAccountType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CreditManagementAccount extends VdmEntity<CreditManagementAccount>
{

    /**
     * Selector for all available fields of CreditManagementAccount.
     *
     */
    public final static CreditManagementAccountSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @Key
    @SerializedName( "BusinessPartner" )
    @JsonProperty( "BusinessPartner" )
    @Nullable
    @ODataField( odataName = "BusinessPartner" )
    private String businessPartner;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartner</b> field to query operations.
     *
     */
    public final static CreditManagementAccountField<String> BUSINESS_PARTNER =
        new CreditManagementAccountField<String>("BusinessPartner");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CreditSegment</b>
     * </p>
     *
     * @return Credit Segment
     */
    @Key
    @SerializedName( "CreditSegment" )
    @JsonProperty( "CreditSegment" )
    @Nullable
    @ODataField( odataName = "CreditSegment" )
    private String creditSegment;
    /**
     * Use with available fluent helpers to apply the <b>CreditSegment</b> field to query operations.
     *
     */
    public final static CreditManagementAccountField<String> CREDIT_SEGMENT =
        new CreditManagementAccountField<String>("CreditSegment");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerIsCritical</b>
     * </p>
     *
     * @return Special Attention Required
     */
    @SerializedName( "BusinessPartnerIsCritical" )
    @JsonProperty( "BusinessPartnerIsCritical" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BusinessPartnerIsCritical" )
    private Boolean businessPartnerIsCritical;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerIsCritical</b> field to query operations.
     *
     */
    public final static CreditManagementAccountField<Boolean> BUSINESS_PARTNER_IS_CRITICAL =
        new CreditManagementAccountField<Boolean>("BusinessPartnerIsCritical");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CreditAccountIsBlocked</b>
     * </p>
     *
     * @return Credit Checks Fail Due to Credit Block
     */
    @SerializedName( "CreditAccountIsBlocked" )
    @JsonProperty( "CreditAccountIsBlocked" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CreditAccountIsBlocked" )
    private Boolean creditAccountIsBlocked;
    /**
     * Use with available fluent helpers to apply the <b>CreditAccountIsBlocked</b> field to query operations.
     *
     */
    public final static CreditManagementAccountField<Boolean> CREDIT_ACCOUNT_IS_BLOCKED =
        new CreditManagementAccountField<Boolean>("CreditAccountIsBlocked");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAccountBlockReason</b>
     * </p>
     *
     * @return Reason for Block in Credit Management
     */
    @SerializedName( "CreditAccountBlockReason" )
    @JsonProperty( "CreditAccountBlockReason" )
    @Nullable
    @ODataField( odataName = "CreditAccountBlockReason" )
    private String creditAccountBlockReason;
    /**
     * Use with available fluent helpers to apply the <b>CreditAccountBlockReason</b> field to query operations.
     *
     */
    public final static CreditManagementAccountField<String> CREDIT_ACCOUNT_BLOCK_REASON =
        new CreditManagementAccountField<String>("CreditAccountBlockReason");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreditAccountResubmissionDate</b>
     * </p>
     *
     * @return Resubmission Date
     */
    @SerializedName( "CreditAccountResubmissionDate" )
    @JsonProperty( "CreditAccountResubmissionDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreditAccountResubmissionDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creditAccountResubmissionDate;
    /**
     * Use with available fluent helpers to apply the <b>CreditAccountResubmissionDate</b> field to query operations.
     *
     */
    public final static CreditManagementAccountField<LocalDateTime> CREDIT_ACCOUNT_RESUBMISSION_DATE =
        new CreditManagementAccountField<LocalDateTime>("CreditAccountResubmissionDate");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CreditLimitAmount</b>
     * </p>
     *
     * @return Credit Limit
     */
    @SerializedName( "CreditLimitAmount" )
    @JsonProperty( "CreditLimitAmount" )
    @Nullable
    @ODataField( odataName = "CreditLimitAmount" )
    private BigDecimal creditLimitAmount;
    /**
     * Use with available fluent helpers to apply the <b>CreditLimitAmount</b> field to query operations.
     *
     */
    public final static CreditManagementAccountField<BigDecimal> CREDIT_LIMIT_AMOUNT =
        new CreditManagementAccountField<BigDecimal>("CreditLimitAmount");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreditLimitValidityEndDate</b>
     * </p>
     *
     * @return Valid To Date
     */
    @SerializedName( "CreditLimitValidityEndDate" )
    @JsonProperty( "CreditLimitValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreditLimitValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creditLimitValidityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>CreditLimitValidityEndDate</b> field to query operations.
     *
     */
    public final static CreditManagementAccountField<LocalDateTime> CREDIT_LIMIT_VALIDITY_END_DATE =
        new CreditManagementAccountField<LocalDateTime>("CreditLimitValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreditLimitLastChangeDate</b>
     * </p>
     *
     * @return Change Date for Credit Limit
     */
    @SerializedName( "CreditLimitLastChangeDate" )
    @JsonProperty( "CreditLimitLastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreditLimitLastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creditLimitLastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>CreditLimitLastChangeDate</b> field to query operations.
     *
     */
    public final static CreditManagementAccountField<LocalDateTime> CREDIT_LIMIT_LAST_CHANGE_DATE =
        new CreditManagementAccountField<LocalDateTime>("CreditLimitLastChangeDate");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CreditLimitCalculatedAmount</b>
     * </p>
     *
     * @return Calculated Credit Limit
     */
    @SerializedName( "CreditLimitCalculatedAmount" )
    @JsonProperty( "CreditLimitCalculatedAmount" )
    @Nullable
    @ODataField( odataName = "CreditLimitCalculatedAmount" )
    private BigDecimal creditLimitCalculatedAmount;
    /**
     * Use with available fluent helpers to apply the <b>CreditLimitCalculatedAmount</b> field to query operations.
     *
     */
    public final static CreditManagementAccountField<BigDecimal> CREDIT_LIMIT_CALCULATED_AMOUNT =
        new CreditManagementAccountField<BigDecimal>("CreditLimitCalculatedAmount");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CreditLimitIsZero</b>
     * </p>
     *
     * @return Limit is Zero
     */
    @SerializedName( "CreditLimitIsZero" )
    @JsonProperty( "CreditLimitIsZero" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CreditLimitIsZero" )
    private Boolean creditLimitIsZero;
    /**
     * Use with available fluent helpers to apply the <b>CreditLimitIsZero</b> field to query operations.
     *
     */
    public final static CreditManagementAccountField<Boolean> CREDIT_LIMIT_IS_ZERO =
        new CreditManagementAccountField<Boolean>("CreditLimitIsZero");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CreditLimitRequestedAmount</b>
     * </p>
     *
     * @return Credit Limit Requested
     */
    @SerializedName( "CreditLimitRequestedAmount" )
    @JsonProperty( "CreditLimitRequestedAmount" )
    @Nullable
    @ODataField( odataName = "CreditLimitRequestedAmount" )
    private BigDecimal creditLimitRequestedAmount;
    /**
     * Use with available fluent helpers to apply the <b>CreditLimitRequestedAmount</b> field to query operations.
     *
     */
    public final static CreditManagementAccountField<BigDecimal> CREDIT_LIMIT_REQUESTED_AMOUNT =
        new CreditManagementAccountField<BigDecimal>("CreditLimitRequestedAmount");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CrdtLmtIsReqdFrmAutomCalc</b>
     * </p>
     *
     * @return Limit Request from Automatic Calculation
     */
    @SerializedName( "CrdtLmtIsReqdFrmAutomCalc" )
    @JsonProperty( "CrdtLmtIsReqdFrmAutomCalc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CrdtLmtIsReqdFrmAutomCalc" )
    private Boolean crdtLmtIsReqdFrmAutomCalc;
    /**
     * Use with available fluent helpers to apply the <b>CrdtLmtIsReqdFrmAutomCalc</b> field to query operations.
     *
     */
    public final static CreditManagementAccountField<Boolean> CRDT_LMT_IS_REQD_FRM_AUTOM_CALC =
        new CreditManagementAccountField<Boolean>("CrdtLmtIsReqdFrmAutomCalc");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreditLimitReqdValidityEndDate</b>
     * </p>
     *
     * @return Valid To Date (Requested)
     */
    @SerializedName( "CreditLimitReqdValidityEndDate" )
    @JsonProperty( "CreditLimitReqdValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreditLimitReqdValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creditLimitReqdValidityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>CreditLimitReqdValidityEndDate</b> field to query operations.
     *
     */
    public final static CreditManagementAccountField<LocalDateTime> CREDIT_LIMIT_REQD_VALIDITY_END_DATE =
        new CreditManagementAccountField<LocalDateTime>("CreditLimitReqdValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreditLimitRequestDate</b>
     * </p>
     *
     * @return Request Date
     */
    @SerializedName( "CreditLimitRequestDate" )
    @JsonProperty( "CreditLimitRequestDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreditLimitRequestDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creditLimitRequestDate;
    /**
     * Use with available fluent helpers to apply the <b>CreditLimitRequestDate</b> field to query operations.
     *
     */
    public final static CreditManagementAccountField<LocalDateTime> CREDIT_LIMIT_REQUEST_DATE =
        new CreditManagementAccountField<LocalDateTime>("CreditLimitRequestDate");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditSegmentCurrency</b>
     * </p>
     *
     * @return Credit Segment Currency
     */
    @SerializedName( "CreditSegmentCurrency" )
    @JsonProperty( "CreditSegmentCurrency" )
    @Nullable
    @ODataField( odataName = "CreditSegmentCurrency" )
    private String creditSegmentCurrency;
    /**
     * Use with available fluent helpers to apply the <b>CreditSegmentCurrency</b> field to query operations.
     *
     */
    public final static CreditManagementAccountField<String> CREDIT_SEGMENT_CURRENCY =
        new CreditManagementAccountField<String>("CreditSegmentCurrency");
    /**
     * Navigation property <b>to_CrdtMBusinessPartnerTP</b> for <b>CreditManagementAccount</b> to single
     * <b>CreditMgmtBusinessPartner</b>.
     *
     */
    @SerializedName( "to_CrdtMBusinessPartnerTP" )
    @JsonProperty( "to_CrdtMBusinessPartnerTP" )
    @ODataField( odataName = "to_CrdtMBusinessPartnerTP" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private CreditMgmtBusinessPartner toCrdtMBusinessPartnerTP;
    /**
     * Navigation property <b>to_CrdtMAcctCollateralTP</b> for <b>CreditManagementAccount</b> to multiple
     * <b>CrdtMAcctCollateral</b>.
     *
     */
    @SerializedName( "to_CrdtMAcctCollateralTP" )
    @JsonProperty( "to_CrdtMAcctCollateralTP" )
    @ODataField( odataName = "to_CrdtMAcctCollateralTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CrdtMAcctCollateral> toCrdtMAcctCollateralTP;
    /**
     * Navigation property <b>to_CrdtMAcctCrdtInsuranceTP</b> for <b>CreditManagementAccount</b> to multiple
     * <b>CrdtMAcctCrdtInsurance</b>.
     *
     */
    @SerializedName( "to_CrdtMAcctCrdtInsuranceTP" )
    @JsonProperty( "to_CrdtMAcctCrdtInsuranceTP" )
    @ODataField( odataName = "to_CrdtMAcctCrdtInsuranceTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CrdtMAcctCrdtInsurance> toCrdtMAcctCrdtInsuranceTP;
    /**
     * Use with available fluent helpers to apply the <b>to_CrdtMBusinessPartnerTP</b> navigation property to query
     * operations.
     *
     */
    public final static CreditManagementAccountOneToOneLink<CreditMgmtBusinessPartner> TO_CRDT_M_BUSINESS_PARTNER_TP =
        new CreditManagementAccountOneToOneLink<CreditMgmtBusinessPartner>("to_CrdtMBusinessPartnerTP");
    /**
     * Use with available fluent helpers to apply the <b>to_CrdtMAcctCollateralTP</b> navigation property to query
     * operations.
     *
     */
    public final static CreditManagementAccountLink<CrdtMAcctCollateral> TO_CRDT_M_ACCT_COLLATERAL_TP =
        new CreditManagementAccountLink<CrdtMAcctCollateral>("to_CrdtMAcctCollateralTP");
    /**
     * Use with available fluent helpers to apply the <b>to_CrdtMAcctCrdtInsuranceTP</b> navigation property to query
     * operations.
     *
     */
    public final static CreditManagementAccountLink<CrdtMAcctCrdtInsurance> TO_CRDT_M_ACCT_CRDT_INSURANCE_TP =
        new CreditManagementAccountLink<CrdtMAcctCrdtInsurance>("to_CrdtMAcctCrdtInsuranceTP");

    @Nonnull
    @Override
    public Class<CreditManagementAccount> getType()
    {
        return CreditManagementAccount.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @param businessPartner
     *            Business Partner Number
     */
    public void setBusinessPartner( @Nullable final String businessPartner )
    {
        rememberChangedField("BusinessPartner", this.businessPartner);
        this.businessPartner = businessPartner;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CreditSegment</b>
     * </p>
     *
     * @param creditSegment
     *            Credit Segment
     */
    public void setCreditSegment( @Nullable final String creditSegment )
    {
        rememberChangedField("CreditSegment", this.creditSegment);
        this.creditSegment = creditSegment;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerIsCritical</b>
     * </p>
     *
     * @param businessPartnerIsCritical
     *            Special Attention Required
     */
    public void setBusinessPartnerIsCritical( @Nullable final Boolean businessPartnerIsCritical )
    {
        rememberChangedField("BusinessPartnerIsCritical", this.businessPartnerIsCritical);
        this.businessPartnerIsCritical = businessPartnerIsCritical;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CreditAccountIsBlocked</b>
     * </p>
     *
     * @param creditAccountIsBlocked
     *            Credit Checks Fail Due to Credit Block
     */
    public void setCreditAccountIsBlocked( @Nullable final Boolean creditAccountIsBlocked )
    {
        rememberChangedField("CreditAccountIsBlocked", this.creditAccountIsBlocked);
        this.creditAccountIsBlocked = creditAccountIsBlocked;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CreditAccountBlockReason</b>
     * </p>
     *
     * @param creditAccountBlockReason
     *            Reason for Block in Credit Management
     */
    public void setCreditAccountBlockReason( @Nullable final String creditAccountBlockReason )
    {
        rememberChangedField("CreditAccountBlockReason", this.creditAccountBlockReason);
        this.creditAccountBlockReason = creditAccountBlockReason;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreditAccountResubmissionDate</b>
     * </p>
     *
     * @param creditAccountResubmissionDate
     *            Resubmission Date
     */
    public void setCreditAccountResubmissionDate( @Nullable final LocalDateTime creditAccountResubmissionDate )
    {
        rememberChangedField("CreditAccountResubmissionDate", this.creditAccountResubmissionDate);
        this.creditAccountResubmissionDate = creditAccountResubmissionDate;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CreditLimitAmount</b>
     * </p>
     *
     * @param creditLimitAmount
     *            Credit Limit
     */
    public void setCreditLimitAmount( @Nullable final BigDecimal creditLimitAmount )
    {
        rememberChangedField("CreditLimitAmount", this.creditLimitAmount);
        this.creditLimitAmount = creditLimitAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreditLimitValidityEndDate</b>
     * </p>
     *
     * @param creditLimitValidityEndDate
     *            Valid To Date
     */
    public void setCreditLimitValidityEndDate( @Nullable final LocalDateTime creditLimitValidityEndDate )
    {
        rememberChangedField("CreditLimitValidityEndDate", this.creditLimitValidityEndDate);
        this.creditLimitValidityEndDate = creditLimitValidityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreditLimitLastChangeDate</b>
     * </p>
     *
     * @param creditLimitLastChangeDate
     *            Change Date for Credit Limit
     */
    public void setCreditLimitLastChangeDate( @Nullable final LocalDateTime creditLimitLastChangeDate )
    {
        rememberChangedField("CreditLimitLastChangeDate", this.creditLimitLastChangeDate);
        this.creditLimitLastChangeDate = creditLimitLastChangeDate;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CreditLimitCalculatedAmount</b>
     * </p>
     *
     * @param creditLimitCalculatedAmount
     *            Calculated Credit Limit
     */
    public void setCreditLimitCalculatedAmount( @Nullable final BigDecimal creditLimitCalculatedAmount )
    {
        rememberChangedField("CreditLimitCalculatedAmount", this.creditLimitCalculatedAmount);
        this.creditLimitCalculatedAmount = creditLimitCalculatedAmount;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CreditLimitIsZero</b>
     * </p>
     *
     * @param creditLimitIsZero
     *            Limit is Zero
     */
    public void setCreditLimitIsZero( @Nullable final Boolean creditLimitIsZero )
    {
        rememberChangedField("CreditLimitIsZero", this.creditLimitIsZero);
        this.creditLimitIsZero = creditLimitIsZero;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CreditLimitRequestedAmount</b>
     * </p>
     *
     * @param creditLimitRequestedAmount
     *            Credit Limit Requested
     */
    public void setCreditLimitRequestedAmount( @Nullable final BigDecimal creditLimitRequestedAmount )
    {
        rememberChangedField("CreditLimitRequestedAmount", this.creditLimitRequestedAmount);
        this.creditLimitRequestedAmount = creditLimitRequestedAmount;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CrdtLmtIsReqdFrmAutomCalc</b>
     * </p>
     *
     * @param crdtLmtIsReqdFrmAutomCalc
     *            Limit Request from Automatic Calculation
     */
    public void setCrdtLmtIsReqdFrmAutomCalc( @Nullable final Boolean crdtLmtIsReqdFrmAutomCalc )
    {
        rememberChangedField("CrdtLmtIsReqdFrmAutomCalc", this.crdtLmtIsReqdFrmAutomCalc);
        this.crdtLmtIsReqdFrmAutomCalc = crdtLmtIsReqdFrmAutomCalc;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreditLimitReqdValidityEndDate</b>
     * </p>
     *
     * @param creditLimitReqdValidityEndDate
     *            Valid To Date (Requested)
     */
    public void setCreditLimitReqdValidityEndDate( @Nullable final LocalDateTime creditLimitReqdValidityEndDate )
    {
        rememberChangedField("CreditLimitReqdValidityEndDate", this.creditLimitReqdValidityEndDate);
        this.creditLimitReqdValidityEndDate = creditLimitReqdValidityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreditLimitRequestDate</b>
     * </p>
     *
     * @param creditLimitRequestDate
     *            Request Date
     */
    public void setCreditLimitRequestDate( @Nullable final LocalDateTime creditLimitRequestDate )
    {
        rememberChangedField("CreditLimitRequestDate", this.creditLimitRequestDate);
        this.creditLimitRequestDate = creditLimitRequestDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CreditSegmentCurrency</b>
     * </p>
     *
     * @param creditSegmentCurrency
     *            Credit Segment Currency
     */
    public void setCreditSegmentCurrency( @Nullable final String creditSegmentCurrency )
    {
        rememberChangedField("CreditSegmentCurrency", this.creditSegmentCurrency);
        this.creditSegmentCurrency = creditSegmentCurrency;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CreditManagementAccount";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessPartner", getBusinessPartner());
        result.put("CreditSegment", getCreditSegment());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessPartner", getBusinessPartner());
        values.put("CreditSegment", getCreditSegment());
        values.put("BusinessPartnerIsCritical", getBusinessPartnerIsCritical());
        values.put("CreditAccountIsBlocked", getCreditAccountIsBlocked());
        values.put("CreditAccountBlockReason", getCreditAccountBlockReason());
        values.put("CreditAccountResubmissionDate", getCreditAccountResubmissionDate());
        values.put("CreditLimitAmount", getCreditLimitAmount());
        values.put("CreditLimitValidityEndDate", getCreditLimitValidityEndDate());
        values.put("CreditLimitLastChangeDate", getCreditLimitLastChangeDate());
        values.put("CreditLimitCalculatedAmount", getCreditLimitCalculatedAmount());
        values.put("CreditLimitIsZero", getCreditLimitIsZero());
        values.put("CreditLimitRequestedAmount", getCreditLimitRequestedAmount());
        values.put("CrdtLmtIsReqdFrmAutomCalc", getCrdtLmtIsReqdFrmAutomCalc());
        values.put("CreditLimitReqdValidityEndDate", getCreditLimitReqdValidityEndDate());
        values.put("CreditLimitRequestDate", getCreditLimitRequestDate());
        values.put("CreditSegmentCurrency", getCreditSegmentCurrency());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessPartner") ) {
                final Object value = values.remove("BusinessPartner");
                if( (value == null) || (!value.equals(getBusinessPartner())) ) {
                    setBusinessPartner(((String) value));
                }
            }
            if( values.containsKey("CreditSegment") ) {
                final Object value = values.remove("CreditSegment");
                if( (value == null) || (!value.equals(getCreditSegment())) ) {
                    setCreditSegment(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerIsCritical") ) {
                final Object value = values.remove("BusinessPartnerIsCritical");
                if( (value == null) || (!value.equals(getBusinessPartnerIsCritical())) ) {
                    setBusinessPartnerIsCritical(((Boolean) value));
                }
            }
            if( values.containsKey("CreditAccountIsBlocked") ) {
                final Object value = values.remove("CreditAccountIsBlocked");
                if( (value == null) || (!value.equals(getCreditAccountIsBlocked())) ) {
                    setCreditAccountIsBlocked(((Boolean) value));
                }
            }
            if( values.containsKey("CreditAccountBlockReason") ) {
                final Object value = values.remove("CreditAccountBlockReason");
                if( (value == null) || (!value.equals(getCreditAccountBlockReason())) ) {
                    setCreditAccountBlockReason(((String) value));
                }
            }
            if( values.containsKey("CreditAccountResubmissionDate") ) {
                final Object value = values.remove("CreditAccountResubmissionDate");
                if( (value == null) || (!value.equals(getCreditAccountResubmissionDate())) ) {
                    setCreditAccountResubmissionDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreditLimitAmount") ) {
                final Object value = values.remove("CreditLimitAmount");
                if( (value == null) || (!value.equals(getCreditLimitAmount())) ) {
                    setCreditLimitAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CreditLimitValidityEndDate") ) {
                final Object value = values.remove("CreditLimitValidityEndDate");
                if( (value == null) || (!value.equals(getCreditLimitValidityEndDate())) ) {
                    setCreditLimitValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreditLimitLastChangeDate") ) {
                final Object value = values.remove("CreditLimitLastChangeDate");
                if( (value == null) || (!value.equals(getCreditLimitLastChangeDate())) ) {
                    setCreditLimitLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreditLimitCalculatedAmount") ) {
                final Object value = values.remove("CreditLimitCalculatedAmount");
                if( (value == null) || (!value.equals(getCreditLimitCalculatedAmount())) ) {
                    setCreditLimitCalculatedAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CreditLimitIsZero") ) {
                final Object value = values.remove("CreditLimitIsZero");
                if( (value == null) || (!value.equals(getCreditLimitIsZero())) ) {
                    setCreditLimitIsZero(((Boolean) value));
                }
            }
            if( values.containsKey("CreditLimitRequestedAmount") ) {
                final Object value = values.remove("CreditLimitRequestedAmount");
                if( (value == null) || (!value.equals(getCreditLimitRequestedAmount())) ) {
                    setCreditLimitRequestedAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CrdtLmtIsReqdFrmAutomCalc") ) {
                final Object value = values.remove("CrdtLmtIsReqdFrmAutomCalc");
                if( (value == null) || (!value.equals(getCrdtLmtIsReqdFrmAutomCalc())) ) {
                    setCrdtLmtIsReqdFrmAutomCalc(((Boolean) value));
                }
            }
            if( values.containsKey("CreditLimitReqdValidityEndDate") ) {
                final Object value = values.remove("CreditLimitReqdValidityEndDate");
                if( (value == null) || (!value.equals(getCreditLimitReqdValidityEndDate())) ) {
                    setCreditLimitReqdValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreditLimitRequestDate") ) {
                final Object value = values.remove("CreditLimitRequestDate");
                if( (value == null) || (!value.equals(getCreditLimitRequestDate())) ) {
                    setCreditLimitRequestDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreditSegmentCurrency") ) {
                final Object value = values.remove("CreditSegmentCurrency");
                if( (value == null) || (!value.equals(getCreditSegmentCurrency())) ) {
                    setCreditSegmentCurrency(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CrdtMBusinessPartnerTP") ) {
                final Object value = (values).remove("to_CrdtMBusinessPartnerTP");
                if( value instanceof Map ) {
                    if( toCrdtMBusinessPartnerTP == null ) {
                        toCrdtMBusinessPartnerTP = new CreditMgmtBusinessPartner();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCrdtMBusinessPartnerTP.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CrdtMAcctCollateralTP") ) {
                final Object value = (values).remove("to_CrdtMAcctCollateralTP");
                if( value instanceof Iterable ) {
                    if( toCrdtMAcctCollateralTP == null ) {
                        toCrdtMAcctCollateralTP = Lists.newArrayList();
                    } else {
                        toCrdtMAcctCollateralTP = Lists.newArrayList(toCrdtMAcctCollateralTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CrdtMAcctCollateral entity;
                        if( toCrdtMAcctCollateralTP.size() > i ) {
                            entity = toCrdtMAcctCollateralTP.get(i);
                        } else {
                            entity = new CrdtMAcctCollateral();
                            toCrdtMAcctCollateralTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CrdtMAcctCrdtInsuranceTP") ) {
                final Object value = (values).remove("to_CrdtMAcctCrdtInsuranceTP");
                if( value instanceof Iterable ) {
                    if( toCrdtMAcctCrdtInsuranceTP == null ) {
                        toCrdtMAcctCrdtInsuranceTP = Lists.newArrayList();
                    } else {
                        toCrdtMAcctCrdtInsuranceTP = Lists.newArrayList(toCrdtMAcctCrdtInsuranceTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CrdtMAcctCrdtInsurance entity;
                        if( toCrdtMAcctCrdtInsuranceTP.size() > i ) {
                            entity = toCrdtMAcctCrdtInsuranceTP.get(i);
                        } else {
                            entity = new CrdtMAcctCrdtInsurance();
                            toCrdtMAcctCrdtInsuranceTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CreditManagementAccountField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CreditManagementAccountField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CreditManagementAccountField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CreditManagementAccountField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditManagementMasterDataService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCrdtMBusinessPartnerTP != null ) {
            (values).put("to_CrdtMBusinessPartnerTP", toCrdtMBusinessPartnerTP);
        }
        if( toCrdtMAcctCollateralTP != null ) {
            (values).put("to_CrdtMAcctCollateralTP", toCrdtMAcctCollateralTP);
        }
        if( toCrdtMAcctCrdtInsuranceTP != null ) {
            (values).put("to_CrdtMAcctCrdtInsuranceTP", toCrdtMAcctCrdtInsuranceTP);
        }
        return values;
    }

    /**
     * Fetches the <b>CreditMgmtBusinessPartner</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CrdtMBusinessPartnerTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>CreditMgmtBusinessPartner</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CreditMgmtBusinessPartner fetchCrdtMBusinessPartnerTP()
    {
        return fetchFieldAsSingle("to_CrdtMBusinessPartnerTP", CreditMgmtBusinessPartner.class);
    }

    /**
     * Retrieval of associated <b>CreditMgmtBusinessPartner</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CrdtMBusinessPartnerTP</b>.
     * <p>
     * If the navigation property <b>to_CrdtMBusinessPartnerTP</b> of a queried <b>CreditManagementAccount</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CreditMgmtBusinessPartner</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public CreditMgmtBusinessPartner getCrdtMBusinessPartnerTPOrFetch()
    {
        if( toCrdtMBusinessPartnerTP == null ) {
            toCrdtMBusinessPartnerTP = fetchCrdtMBusinessPartnerTP();
        }
        return toCrdtMBusinessPartnerTP;
    }

    /**
     * Retrieval of associated <b>CreditMgmtBusinessPartner</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CrdtMBusinessPartnerTP</b>.
     * <p>
     * If the navigation property for an entity <b>CreditManagementAccount</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CrdtMBusinessPartnerTP</b> is already loaded, the result
     *         will contain the <b>CreditMgmtBusinessPartner</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<CreditMgmtBusinessPartner> getCrdtMBusinessPartnerTPIfPresent()
    {
        return Option.of(toCrdtMBusinessPartnerTP);
    }

    /**
     * Overwrites the associated <b>CreditMgmtBusinessPartner</b> entity for the loaded navigation property
     * <b>to_CrdtMBusinessPartnerTP</b>.
     *
     * @param value
     *            New <b>CreditMgmtBusinessPartner</b> entity.
     */
    public void setCrdtMBusinessPartnerTP( final CreditMgmtBusinessPartner value )
    {
        toCrdtMBusinessPartnerTP = value;
    }

    /**
     * Fetches the <b>CrdtMAcctCollateral</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CrdtMAcctCollateralTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CrdtMAcctCollateral</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CrdtMAcctCollateral> fetchCrdtMAcctCollateralTP()
    {
        return fetchFieldAsList("to_CrdtMAcctCollateralTP", CrdtMAcctCollateral.class);
    }

    /**
     * Retrieval of associated <b>CrdtMAcctCollateral</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CrdtMAcctCollateralTP</b>.
     * <p>
     * If the navigation property <b>to_CrdtMAcctCollateralTP</b> of a queried <b>CreditManagementAccount</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CrdtMAcctCollateral</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CrdtMAcctCollateral> getCrdtMAcctCollateralTPOrFetch()
    {
        if( toCrdtMAcctCollateralTP == null ) {
            toCrdtMAcctCollateralTP = fetchCrdtMAcctCollateralTP();
        }
        return toCrdtMAcctCollateralTP;
    }

    /**
     * Retrieval of associated <b>CrdtMAcctCollateral</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CrdtMAcctCollateralTP</b>.
     * <p>
     * If the navigation property for an entity <b>CreditManagementAccount</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CrdtMAcctCollateralTP</b> is already loaded, the result
     *         will contain the <b>CrdtMAcctCollateral</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CrdtMAcctCollateral>> getCrdtMAcctCollateralTPIfPresent()
    {
        return Option.of(toCrdtMAcctCollateralTP);
    }

    /**
     * Overwrites the list of associated <b>CrdtMAcctCollateral</b> entities for the loaded navigation property
     * <b>to_CrdtMAcctCollateralTP</b>.
     * <p>
     * If the navigation property <b>to_CrdtMAcctCollateralTP</b> of a queried <b>CreditManagementAccount</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CrdtMAcctCollateral</b> entities.
     */
    public void setCrdtMAcctCollateralTP( @Nonnull final List<CrdtMAcctCollateral> value )
    {
        if( toCrdtMAcctCollateralTP == null ) {
            toCrdtMAcctCollateralTP = Lists.newArrayList();
        }
        toCrdtMAcctCollateralTP.clear();
        toCrdtMAcctCollateralTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CrdtMAcctCollateral</b> entities. This corresponds to the OData
     * navigation property <b>to_CrdtMAcctCollateralTP</b>.
     * <p>
     * If the navigation property <b>to_CrdtMAcctCollateralTP</b> of a queried <b>CreditManagementAccount</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CrdtMAcctCollateral</b> entities.
     */
    public void addCrdtMAcctCollateralTP( CrdtMAcctCollateral... entity )
    {
        if( toCrdtMAcctCollateralTP == null ) {
            toCrdtMAcctCollateralTP = Lists.newArrayList();
        }
        toCrdtMAcctCollateralTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CrdtMAcctCrdtInsurance</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CrdtMAcctCrdtInsuranceTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CrdtMAcctCrdtInsurance</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CrdtMAcctCrdtInsurance> fetchCrdtMAcctCrdtInsuranceTP()
    {
        return fetchFieldAsList("to_CrdtMAcctCrdtInsuranceTP", CrdtMAcctCrdtInsurance.class);
    }

    /**
     * Retrieval of associated <b>CrdtMAcctCrdtInsurance</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CrdtMAcctCrdtInsuranceTP</b>.
     * <p>
     * If the navigation property <b>to_CrdtMAcctCrdtInsuranceTP</b> of a queried <b>CreditManagementAccount</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CrdtMAcctCrdtInsurance</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CrdtMAcctCrdtInsurance> getCrdtMAcctCrdtInsuranceTPOrFetch()
    {
        if( toCrdtMAcctCrdtInsuranceTP == null ) {
            toCrdtMAcctCrdtInsuranceTP = fetchCrdtMAcctCrdtInsuranceTP();
        }
        return toCrdtMAcctCrdtInsuranceTP;
    }

    /**
     * Retrieval of associated <b>CrdtMAcctCrdtInsurance</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CrdtMAcctCrdtInsuranceTP</b>.
     * <p>
     * If the navigation property for an entity <b>CreditManagementAccount</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CrdtMAcctCrdtInsuranceTP</b> is already loaded, the
     *         result will contain the <b>CrdtMAcctCrdtInsurance</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CrdtMAcctCrdtInsurance>> getCrdtMAcctCrdtInsuranceTPIfPresent()
    {
        return Option.of(toCrdtMAcctCrdtInsuranceTP);
    }

    /**
     * Overwrites the list of associated <b>CrdtMAcctCrdtInsurance</b> entities for the loaded navigation property
     * <b>to_CrdtMAcctCrdtInsuranceTP</b>.
     * <p>
     * If the navigation property <b>to_CrdtMAcctCrdtInsuranceTP</b> of a queried <b>CreditManagementAccount</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CrdtMAcctCrdtInsurance</b> entities.
     */
    public void setCrdtMAcctCrdtInsuranceTP( @Nonnull final List<CrdtMAcctCrdtInsurance> value )
    {
        if( toCrdtMAcctCrdtInsuranceTP == null ) {
            toCrdtMAcctCrdtInsuranceTP = Lists.newArrayList();
        }
        toCrdtMAcctCrdtInsuranceTP.clear();
        toCrdtMAcctCrdtInsuranceTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CrdtMAcctCrdtInsurance</b> entities. This corresponds to the OData
     * navigation property <b>to_CrdtMAcctCrdtInsuranceTP</b>.
     * <p>
     * If the navigation property <b>to_CrdtMAcctCrdtInsuranceTP</b> of a queried <b>CreditManagementAccount</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CrdtMAcctCrdtInsurance</b> entities.
     */
    public void addCrdtMAcctCrdtInsuranceTP( CrdtMAcctCrdtInsurance... entity )
    {
        if( toCrdtMAcctCrdtInsuranceTP == null ) {
            toCrdtMAcctCrdtInsuranceTP = Lists.newArrayList();
        }
        toCrdtMAcctCrdtInsuranceTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CreditManagementAccount instances.
     *
     */
    public final static class CreditManagementAccountBuilder
    {

        private CreditMgmtBusinessPartner toCrdtMBusinessPartnerTP;
        private List<CrdtMAcctCollateral> toCrdtMAcctCollateralTP = Lists.newArrayList();
        private List<CrdtMAcctCrdtInsurance> toCrdtMAcctCrdtInsuranceTP = Lists.newArrayList();

        private CreditManagementAccount.CreditManagementAccountBuilder toCrdtMBusinessPartnerTP(
            final CreditMgmtBusinessPartner value )
        {
            toCrdtMBusinessPartnerTP = value;
            return this;
        }

        /**
         * Navigation property <b>to_CrdtMBusinessPartnerTP</b> for <b>CreditManagementAccount</b> to single
         * <b>CreditMgmtBusinessPartner</b>.
         *
         * @param value
         *            The CreditMgmtBusinessPartner to build this CreditManagementAccount with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CreditManagementAccount.CreditManagementAccountBuilder crdtMBusinessPartnerTP(
            final CreditMgmtBusinessPartner value )
        {
            return toCrdtMBusinessPartnerTP(value);
        }

        private CreditManagementAccount.CreditManagementAccountBuilder toCrdtMAcctCollateralTP(
            final List<CrdtMAcctCollateral> value )
        {
            toCrdtMAcctCollateralTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CrdtMAcctCollateralTP</b> for <b>CreditManagementAccount</b> to multiple
         * <b>CrdtMAcctCollateral</b>.
         *
         * @param value
         *            The CrdtMAcctCollaterals to build this CreditManagementAccount with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CreditManagementAccount.CreditManagementAccountBuilder crdtMAcctCollateralTP(
            CrdtMAcctCollateral... value )
        {
            return toCrdtMAcctCollateralTP(Lists.newArrayList(value));
        }

        private CreditManagementAccount.CreditManagementAccountBuilder toCrdtMAcctCrdtInsuranceTP(
            final List<CrdtMAcctCrdtInsurance> value )
        {
            toCrdtMAcctCrdtInsuranceTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CrdtMAcctCrdtInsuranceTP</b> for <b>CreditManagementAccount</b> to multiple
         * <b>CrdtMAcctCrdtInsurance</b>.
         *
         * @param value
         *            The CrdtMAcctCrdtInsurances to build this CreditManagementAccount with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CreditManagementAccount.CreditManagementAccountBuilder crdtMAcctCrdtInsuranceTP(
            CrdtMAcctCrdtInsurance... value )
        {
            return toCrdtMAcctCrdtInsuranceTP(Lists.newArrayList(value));
        }

    }

}
