/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.field.CreditMgmtBusinessPartnerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.link.CreditMgmtBusinessPartnerLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.selectable.CreditMgmtBusinessPartnerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Business Partners
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>CreditMgmtBusinessPartnerType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CreditMgmtBusinessPartner extends VdmEntity<CreditMgmtBusinessPartner>
{

    /**
     * Selector for all available fields of CreditMgmtBusinessPartner.
     *
     */
    public final static CreditMgmtBusinessPartnerSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @Key
    @SerializedName( "BusinessPartner" )
    @JsonProperty( "BusinessPartner" )
    @Nullable
    @ODataField( odataName = "BusinessPartner" )
    private String businessPartner;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartner</b> field to query operations.
     *
     */
    public final static CreditMgmtBusinessPartnerField<String> BUSINESS_PARTNER =
        new CreditMgmtBusinessPartnerField<String>("BusinessPartner");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CrdtMgmtBusinessPartnerGroup</b>
     * </p>
     *
     * @return Customer Credit Group
     */
    @SerializedName( "CrdtMgmtBusinessPartnerGroup" )
    @JsonProperty( "CrdtMgmtBusinessPartnerGroup" )
    @Nullable
    @ODataField( odataName = "CrdtMgmtBusinessPartnerGroup" )
    private String crdtMgmtBusinessPartnerGroup;
    /**
     * Use with available fluent helpers to apply the <b>CrdtMgmtBusinessPartnerGroup</b> field to query operations.
     *
     */
    public final static CreditMgmtBusinessPartnerField<String> CRDT_MGMT_BUSINESS_PARTNER_GROUP =
        new CreditMgmtBusinessPartnerField<String>("CrdtMgmtBusinessPartnerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CreditWorthinessScoreValue</b>
     * </p>
     *
     * @return Score
     */
    @SerializedName( "CreditWorthinessScoreValue" )
    @JsonProperty( "CreditWorthinessScoreValue" )
    @Nullable
    @ODataField( odataName = "CreditWorthinessScoreValue" )
    private String creditWorthinessScoreValue;
    /**
     * Use with available fluent helpers to apply the <b>CreditWorthinessScoreValue</b> field to query operations.
     *
     */
    public final static CreditMgmtBusinessPartnerField<String> CREDIT_WORTHINESS_SCORE_VALUE =
        new CreditMgmtBusinessPartnerField<String>("CreditWorthinessScoreValue");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CrdtWrthnssScoreValdtyEndDate</b>
     * </p>
     *
     * @return Valid To Date
     */
    @SerializedName( "CrdtWrthnssScoreValdtyEndDate" )
    @JsonProperty( "CrdtWrthnssScoreValdtyEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CrdtWrthnssScoreValdtyEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime crdtWrthnssScoreValdtyEndDate;
    /**
     * Use with available fluent helpers to apply the <b>CrdtWrthnssScoreValdtyEndDate</b> field to query operations.
     *
     */
    public final static CreditMgmtBusinessPartnerField<LocalDateTime> CRDT_WRTHNSS_SCORE_VALDTY_END_DATE =
        new CreditMgmtBusinessPartnerField<LocalDateTime>("CrdtWrthnssScoreValdtyEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CrdtWorthinessScoreLastChgDate</b>
     * </p>
     *
     * @return Change Date for Score
     */
    @SerializedName( "CrdtWorthinessScoreLastChgDate" )
    @JsonProperty( "CrdtWorthinessScoreLastChgDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CrdtWorthinessScoreLastChgDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime crdtWorthinessScoreLastChgDate;
    /**
     * Use with available fluent helpers to apply the <b>CrdtWorthinessScoreLastChgDate</b> field to query operations.
     *
     */
    public final static CreditMgmtBusinessPartnerField<LocalDateTime> CRDT_WORTHINESS_SCORE_LAST_CHG_DATE =
        new CreditMgmtBusinessPartnerField<LocalDateTime>("CrdtWorthinessScoreLastChgDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CalcdCrdtWorthinessScoreValue</b>
     * </p>
     *
     * @return Calculated Score
     */
    @SerializedName( "CalcdCrdtWorthinessScoreValue" )
    @JsonProperty( "CalcdCrdtWorthinessScoreValue" )
    @Nullable
    @ODataField( odataName = "CalcdCrdtWorthinessScoreValue" )
    private String calcdCrdtWorthinessScoreValue;
    /**
     * Use with available fluent helpers to apply the <b>CalcdCrdtWorthinessScoreValue</b> field to query operations.
     *
     */
    public final static CreditMgmtBusinessPartnerField<String> CALCD_CRDT_WORTHINESS_SCORE_VALUE =
        new CreditMgmtBusinessPartnerField<String>("CalcdCrdtWorthinessScoreValue");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CreditRiskClass</b>
     * </p>
     *
     * @return Risk Class
     */
    @SerializedName( "CreditRiskClass" )
    @JsonProperty( "CreditRiskClass" )
    @Nullable
    @ODataField( odataName = "CreditRiskClass" )
    private String creditRiskClass;
    /**
     * Use with available fluent helpers to apply the <b>CreditRiskClass</b> field to query operations.
     *
     */
    public final static CreditMgmtBusinessPartnerField<String> CREDIT_RISK_CLASS =
        new CreditMgmtBusinessPartnerField<String>("CreditRiskClass");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CalculatedCreditRiskClass</b>
     * </p>
     *
     * @return Calculated Risk Class
     */
    @SerializedName( "CalculatedCreditRiskClass" )
    @JsonProperty( "CalculatedCreditRiskClass" )
    @Nullable
    @ODataField( odataName = "CalculatedCreditRiskClass" )
    private String calculatedCreditRiskClass;
    /**
     * Use with available fluent helpers to apply the <b>CalculatedCreditRiskClass</b> field to query operations.
     *
     */
    public final static CreditMgmtBusinessPartnerField<String> CALCULATED_CREDIT_RISK_CLASS =
        new CreditMgmtBusinessPartnerField<String>("CalculatedCreditRiskClass");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreditRiskClassLastChangeDate</b>
     * </p>
     *
     * @return Risk Class Changed On
     */
    @SerializedName( "CreditRiskClassLastChangeDate" )
    @JsonProperty( "CreditRiskClassLastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreditRiskClassLastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creditRiskClassLastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>CreditRiskClassLastChangeDate</b> field to query operations.
     *
     */
    public final static CreditMgmtBusinessPartnerField<LocalDateTime> CREDIT_RISK_CLASS_LAST_CHANGE_DATE =
        new CreditMgmtBusinessPartnerField<LocalDateTime>("CreditRiskClassLastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CreditCheckRule</b>
     * </p>
     *
     * @return Rule for Credit Check
     */
    @SerializedName( "CreditCheckRule" )
    @JsonProperty( "CreditCheckRule" )
    @Nullable
    @ODataField( odataName = "CreditCheckRule" )
    private String creditCheckRule;
    /**
     * Use with available fluent helpers to apply the <b>CreditCheckRule</b> field to query operations.
     *
     */
    public final static CreditMgmtBusinessPartnerField<String> CREDIT_CHECK_RULE =
        new CreditMgmtBusinessPartnerField<String>("CreditCheckRule");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CreditScoreAndLimitCalcRule</b>
     * </p>
     *
     * @return Rule for Calculating Score and Credit Limit
     */
    @SerializedName( "CreditScoreAndLimitCalcRule" )
    @JsonProperty( "CreditScoreAndLimitCalcRule" )
    @Nullable
    @ODataField( odataName = "CreditScoreAndLimitCalcRule" )
    private String creditScoreAndLimitCalcRule;
    /**
     * Use with available fluent helpers to apply the <b>CreditScoreAndLimitCalcRule</b> field to query operations.
     *
     */
    public final static CreditMgmtBusinessPartnerField<String> CREDIT_SCORE_AND_LIMIT_CALC_RULE =
        new CreditMgmtBusinessPartnerField<String>("CreditScoreAndLimitCalcRule");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustBusinessRelshpStartYear</b>
     * </p>
     *
     * @return First Year of Customer Relationship
     */
    @SerializedName( "CustBusinessRelshpStartYear" )
    @JsonProperty( "CustBusinessRelshpStartYear" )
    @Nullable
    @ODataField( odataName = "CustBusinessRelshpStartYear" )
    private String custBusinessRelshpStartYear;
    /**
     * Use with available fluent helpers to apply the <b>CustBusinessRelshpStartYear</b> field to query operations.
     *
     */
    public final static CreditMgmtBusinessPartnerField<String> CUST_BUSINESS_RELSHP_START_YEAR =
        new CreditMgmtBusinessPartnerField<String>("CustBusinessRelshpStartYear");
    /**
     * Navigation property <b>to_CrdtMBPCollateralTP</b> for <b>CreditMgmtBusinessPartner</b> to multiple
     * <b>CrdtMgmtBPCollateral</b>.
     *
     */
    @SerializedName( "to_CrdtMBPCollateralTP" )
    @JsonProperty( "to_CrdtMBPCollateralTP" )
    @ODataField( odataName = "to_CrdtMBPCollateralTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CrdtMgmtBPCollateral> toCrdtMBPCollateralTP;
    /**
     * Navigation property <b>to_CrdtMBPCreditInsuranceTP</b> for <b>CreditMgmtBusinessPartner</b> to multiple
     * <b>CrdtMgmtBPCreditInsurance</b>.
     *
     */
    @SerializedName( "to_CrdtMBPCreditInsuranceTP" )
    @JsonProperty( "to_CrdtMBPCreditInsuranceTP" )
    @ODataField( odataName = "to_CrdtMBPCreditInsuranceTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CrdtMgmtBPCreditInsurance> toCrdtMBPCreditInsuranceTP;
    /**
     * Navigation property <b>to_CrdtMBPNegativeEventTP</b> for <b>CreditMgmtBusinessPartner</b> to multiple
     * <b>CrdtMgmtBPNegativeEvent</b>.
     *
     */
    @SerializedName( "to_CrdtMBPNegativeEventTP" )
    @JsonProperty( "to_CrdtMBPNegativeEventTP" )
    @ODataField( odataName = "to_CrdtMBPNegativeEventTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CrdtMgmtBPNegativeEvent> toCrdtMBPNegativeEventTP;
    /**
     * Navigation property <b>to_CreditMgmtAccountTP</b> for <b>CreditMgmtBusinessPartner</b> to multiple
     * <b>CreditManagementAccount</b>.
     *
     */
    @SerializedName( "to_CreditMgmtAccountTP" )
    @JsonProperty( "to_CreditMgmtAccountTP" )
    @ODataField( odataName = "to_CreditMgmtAccountTP" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<CreditManagementAccount> toCreditMgmtAccountTP;
    /**
     * Use with available fluent helpers to apply the <b>to_CrdtMBPCollateralTP</b> navigation property to query
     * operations.
     *
     */
    public final static CreditMgmtBusinessPartnerLink<CrdtMgmtBPCollateral> TO_CRDT_MBP_COLLATERAL_TP =
        new CreditMgmtBusinessPartnerLink<CrdtMgmtBPCollateral>("to_CrdtMBPCollateralTP");
    /**
     * Use with available fluent helpers to apply the <b>to_CrdtMBPCreditInsuranceTP</b> navigation property to query
     * operations.
     *
     */
    public final static CreditMgmtBusinessPartnerLink<CrdtMgmtBPCreditInsurance> TO_CRDT_MBP_CREDIT_INSURANCE_TP =
        new CreditMgmtBusinessPartnerLink<CrdtMgmtBPCreditInsurance>("to_CrdtMBPCreditInsuranceTP");
    /**
     * Use with available fluent helpers to apply the <b>to_CrdtMBPNegativeEventTP</b> navigation property to query
     * operations.
     *
     */
    public final static CreditMgmtBusinessPartnerLink<CrdtMgmtBPNegativeEvent> TO_CRDT_MBP_NEGATIVE_EVENT_TP =
        new CreditMgmtBusinessPartnerLink<CrdtMgmtBPNegativeEvent>("to_CrdtMBPNegativeEventTP");
    /**
     * Use with available fluent helpers to apply the <b>to_CreditMgmtAccountTP</b> navigation property to query
     * operations.
     *
     */
    public final static CreditMgmtBusinessPartnerLink<CreditManagementAccount> TO_CREDIT_MGMT_ACCOUNT_TP =
        new CreditMgmtBusinessPartnerLink<CreditManagementAccount>("to_CreditMgmtAccountTP");

    @Nonnull
    @Override
    public Class<CreditMgmtBusinessPartner> getType()
    {
        return CreditMgmtBusinessPartner.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @param businessPartner
     *            Business Partner Number
     */
    public void setBusinessPartner( @Nullable final String businessPartner )
    {
        rememberChangedField("BusinessPartner", this.businessPartner);
        this.businessPartner = businessPartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CrdtMgmtBusinessPartnerGroup</b>
     * </p>
     *
     * @param crdtMgmtBusinessPartnerGroup
     *            Customer Credit Group
     */
    public void setCrdtMgmtBusinessPartnerGroup( @Nullable final String crdtMgmtBusinessPartnerGroup )
    {
        rememberChangedField("CrdtMgmtBusinessPartnerGroup", this.crdtMgmtBusinessPartnerGroup);
        this.crdtMgmtBusinessPartnerGroup = crdtMgmtBusinessPartnerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CreditWorthinessScoreValue</b>
     * </p>
     *
     * @param creditWorthinessScoreValue
     *            Score
     */
    public void setCreditWorthinessScoreValue( @Nullable final String creditWorthinessScoreValue )
    {
        rememberChangedField("CreditWorthinessScoreValue", this.creditWorthinessScoreValue);
        this.creditWorthinessScoreValue = creditWorthinessScoreValue;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CrdtWrthnssScoreValdtyEndDate</b>
     * </p>
     *
     * @param crdtWrthnssScoreValdtyEndDate
     *            Valid To Date
     */
    public void setCrdtWrthnssScoreValdtyEndDate( @Nullable final LocalDateTime crdtWrthnssScoreValdtyEndDate )
    {
        rememberChangedField("CrdtWrthnssScoreValdtyEndDate", this.crdtWrthnssScoreValdtyEndDate);
        this.crdtWrthnssScoreValdtyEndDate = crdtWrthnssScoreValdtyEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CrdtWorthinessScoreLastChgDate</b>
     * </p>
     *
     * @param crdtWorthinessScoreLastChgDate
     *            Change Date for Score
     */
    public void setCrdtWorthinessScoreLastChgDate( @Nullable final LocalDateTime crdtWorthinessScoreLastChgDate )
    {
        rememberChangedField("CrdtWorthinessScoreLastChgDate", this.crdtWorthinessScoreLastChgDate);
        this.crdtWorthinessScoreLastChgDate = crdtWorthinessScoreLastChgDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CalcdCrdtWorthinessScoreValue</b>
     * </p>
     *
     * @param calcdCrdtWorthinessScoreValue
     *            Calculated Score
     */
    public void setCalcdCrdtWorthinessScoreValue( @Nullable final String calcdCrdtWorthinessScoreValue )
    {
        rememberChangedField("CalcdCrdtWorthinessScoreValue", this.calcdCrdtWorthinessScoreValue);
        this.calcdCrdtWorthinessScoreValue = calcdCrdtWorthinessScoreValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CreditRiskClass</b>
     * </p>
     *
     * @param creditRiskClass
     *            Risk Class
     */
    public void setCreditRiskClass( @Nullable final String creditRiskClass )
    {
        rememberChangedField("CreditRiskClass", this.creditRiskClass);
        this.creditRiskClass = creditRiskClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CalculatedCreditRiskClass</b>
     * </p>
     *
     * @param calculatedCreditRiskClass
     *            Calculated Risk Class
     */
    public void setCalculatedCreditRiskClass( @Nullable final String calculatedCreditRiskClass )
    {
        rememberChangedField("CalculatedCreditRiskClass", this.calculatedCreditRiskClass);
        this.calculatedCreditRiskClass = calculatedCreditRiskClass;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreditRiskClassLastChangeDate</b>
     * </p>
     *
     * @param creditRiskClassLastChangeDate
     *            Risk Class Changed On
     */
    public void setCreditRiskClassLastChangeDate( @Nullable final LocalDateTime creditRiskClassLastChangeDate )
    {
        rememberChangedField("CreditRiskClassLastChangeDate", this.creditRiskClassLastChangeDate);
        this.creditRiskClassLastChangeDate = creditRiskClassLastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CreditCheckRule</b>
     * </p>
     *
     * @param creditCheckRule
     *            Rule for Credit Check
     */
    public void setCreditCheckRule( @Nullable final String creditCheckRule )
    {
        rememberChangedField("CreditCheckRule", this.creditCheckRule);
        this.creditCheckRule = creditCheckRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CreditScoreAndLimitCalcRule</b>
     * </p>
     *
     * @param creditScoreAndLimitCalcRule
     *            Rule for Calculating Score and Credit Limit
     */
    public void setCreditScoreAndLimitCalcRule( @Nullable final String creditScoreAndLimitCalcRule )
    {
        rememberChangedField("CreditScoreAndLimitCalcRule", this.creditScoreAndLimitCalcRule);
        this.creditScoreAndLimitCalcRule = creditScoreAndLimitCalcRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustBusinessRelshpStartYear</b>
     * </p>
     *
     * @param custBusinessRelshpStartYear
     *            First Year of Customer Relationship
     */
    public void setCustBusinessRelshpStartYear( @Nullable final String custBusinessRelshpStartYear )
    {
        rememberChangedField("CustBusinessRelshpStartYear", this.custBusinessRelshpStartYear);
        this.custBusinessRelshpStartYear = custBusinessRelshpStartYear;
    }

    @Override
    protected String getEntityCollection()
    {
        return "CreditMgmtBusinessPartner";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessPartner", getBusinessPartner());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessPartner", getBusinessPartner());
        values.put("CrdtMgmtBusinessPartnerGroup", getCrdtMgmtBusinessPartnerGroup());
        values.put("CreditWorthinessScoreValue", getCreditWorthinessScoreValue());
        values.put("CrdtWrthnssScoreValdtyEndDate", getCrdtWrthnssScoreValdtyEndDate());
        values.put("CrdtWorthinessScoreLastChgDate", getCrdtWorthinessScoreLastChgDate());
        values.put("CalcdCrdtWorthinessScoreValue", getCalcdCrdtWorthinessScoreValue());
        values.put("CreditRiskClass", getCreditRiskClass());
        values.put("CalculatedCreditRiskClass", getCalculatedCreditRiskClass());
        values.put("CreditRiskClassLastChangeDate", getCreditRiskClassLastChangeDate());
        values.put("CreditCheckRule", getCreditCheckRule());
        values.put("CreditScoreAndLimitCalcRule", getCreditScoreAndLimitCalcRule());
        values.put("CustBusinessRelshpStartYear", getCustBusinessRelshpStartYear());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessPartner") ) {
                final Object value = values.remove("BusinessPartner");
                if( (value == null) || (!value.equals(getBusinessPartner())) ) {
                    setBusinessPartner(((String) value));
                }
            }
            if( values.containsKey("CrdtMgmtBusinessPartnerGroup") ) {
                final Object value = values.remove("CrdtMgmtBusinessPartnerGroup");
                if( (value == null) || (!value.equals(getCrdtMgmtBusinessPartnerGroup())) ) {
                    setCrdtMgmtBusinessPartnerGroup(((String) value));
                }
            }
            if( values.containsKey("CreditWorthinessScoreValue") ) {
                final Object value = values.remove("CreditWorthinessScoreValue");
                if( (value == null) || (!value.equals(getCreditWorthinessScoreValue())) ) {
                    setCreditWorthinessScoreValue(((String) value));
                }
            }
            if( values.containsKey("CrdtWrthnssScoreValdtyEndDate") ) {
                final Object value = values.remove("CrdtWrthnssScoreValdtyEndDate");
                if( (value == null) || (!value.equals(getCrdtWrthnssScoreValdtyEndDate())) ) {
                    setCrdtWrthnssScoreValdtyEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CrdtWorthinessScoreLastChgDate") ) {
                final Object value = values.remove("CrdtWorthinessScoreLastChgDate");
                if( (value == null) || (!value.equals(getCrdtWorthinessScoreLastChgDate())) ) {
                    setCrdtWorthinessScoreLastChgDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CalcdCrdtWorthinessScoreValue") ) {
                final Object value = values.remove("CalcdCrdtWorthinessScoreValue");
                if( (value == null) || (!value.equals(getCalcdCrdtWorthinessScoreValue())) ) {
                    setCalcdCrdtWorthinessScoreValue(((String) value));
                }
            }
            if( values.containsKey("CreditRiskClass") ) {
                final Object value = values.remove("CreditRiskClass");
                if( (value == null) || (!value.equals(getCreditRiskClass())) ) {
                    setCreditRiskClass(((String) value));
                }
            }
            if( values.containsKey("CalculatedCreditRiskClass") ) {
                final Object value = values.remove("CalculatedCreditRiskClass");
                if( (value == null) || (!value.equals(getCalculatedCreditRiskClass())) ) {
                    setCalculatedCreditRiskClass(((String) value));
                }
            }
            if( values.containsKey("CreditRiskClassLastChangeDate") ) {
                final Object value = values.remove("CreditRiskClassLastChangeDate");
                if( (value == null) || (!value.equals(getCreditRiskClassLastChangeDate())) ) {
                    setCreditRiskClassLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreditCheckRule") ) {
                final Object value = values.remove("CreditCheckRule");
                if( (value == null) || (!value.equals(getCreditCheckRule())) ) {
                    setCreditCheckRule(((String) value));
                }
            }
            if( values.containsKey("CreditScoreAndLimitCalcRule") ) {
                final Object value = values.remove("CreditScoreAndLimitCalcRule");
                if( (value == null) || (!value.equals(getCreditScoreAndLimitCalcRule())) ) {
                    setCreditScoreAndLimitCalcRule(((String) value));
                }
            }
            if( values.containsKey("CustBusinessRelshpStartYear") ) {
                final Object value = values.remove("CustBusinessRelshpStartYear");
                if( (value == null) || (!value.equals(getCustBusinessRelshpStartYear())) ) {
                    setCustBusinessRelshpStartYear(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CrdtMBPCollateralTP") ) {
                final Object value = (values).remove("to_CrdtMBPCollateralTP");
                if( value instanceof Iterable ) {
                    if( toCrdtMBPCollateralTP == null ) {
                        toCrdtMBPCollateralTP = Lists.newArrayList();
                    } else {
                        toCrdtMBPCollateralTP = Lists.newArrayList(toCrdtMBPCollateralTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CrdtMgmtBPCollateral entity;
                        if( toCrdtMBPCollateralTP.size() > i ) {
                            entity = toCrdtMBPCollateralTP.get(i);
                        } else {
                            entity = new CrdtMgmtBPCollateral();
                            toCrdtMBPCollateralTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CrdtMBPCreditInsuranceTP") ) {
                final Object value = (values).remove("to_CrdtMBPCreditInsuranceTP");
                if( value instanceof Iterable ) {
                    if( toCrdtMBPCreditInsuranceTP == null ) {
                        toCrdtMBPCreditInsuranceTP = Lists.newArrayList();
                    } else {
                        toCrdtMBPCreditInsuranceTP = Lists.newArrayList(toCrdtMBPCreditInsuranceTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CrdtMgmtBPCreditInsurance entity;
                        if( toCrdtMBPCreditInsuranceTP.size() > i ) {
                            entity = toCrdtMBPCreditInsuranceTP.get(i);
                        } else {
                            entity = new CrdtMgmtBPCreditInsurance();
                            toCrdtMBPCreditInsuranceTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CrdtMBPNegativeEventTP") ) {
                final Object value = (values).remove("to_CrdtMBPNegativeEventTP");
                if( value instanceof Iterable ) {
                    if( toCrdtMBPNegativeEventTP == null ) {
                        toCrdtMBPNegativeEventTP = Lists.newArrayList();
                    } else {
                        toCrdtMBPNegativeEventTP = Lists.newArrayList(toCrdtMBPNegativeEventTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CrdtMgmtBPNegativeEvent entity;
                        if( toCrdtMBPNegativeEventTP.size() > i ) {
                            entity = toCrdtMBPNegativeEventTP.get(i);
                        } else {
                            entity = new CrdtMgmtBPNegativeEvent();
                            toCrdtMBPNegativeEventTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CreditMgmtAccountTP") ) {
                final Object value = (values).remove("to_CreditMgmtAccountTP");
                if( value instanceof Iterable ) {
                    if( toCreditMgmtAccountTP == null ) {
                        toCreditMgmtAccountTP = Lists.newArrayList();
                    } else {
                        toCreditMgmtAccountTP = Lists.newArrayList(toCreditMgmtAccountTP);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        CreditManagementAccount entity;
                        if( toCreditMgmtAccountTP.size() > i ) {
                            entity = toCreditMgmtAccountTP.get(i);
                        } else {
                            entity = new CreditManagementAccount();
                            toCreditMgmtAccountTP.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> CreditMgmtBusinessPartnerField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new CreditMgmtBusinessPartnerField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CreditMgmtBusinessPartnerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CreditMgmtBusinessPartnerField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditManagementMasterDataService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCrdtMBPCollateralTP != null ) {
            (values).put("to_CrdtMBPCollateralTP", toCrdtMBPCollateralTP);
        }
        if( toCrdtMBPCreditInsuranceTP != null ) {
            (values).put("to_CrdtMBPCreditInsuranceTP", toCrdtMBPCreditInsuranceTP);
        }
        if( toCrdtMBPNegativeEventTP != null ) {
            (values).put("to_CrdtMBPNegativeEventTP", toCrdtMBPNegativeEventTP);
        }
        if( toCreditMgmtAccountTP != null ) {
            (values).put("to_CreditMgmtAccountTP", toCreditMgmtAccountTP);
        }
        return values;
    }

    /**
     * Fetches the <b>CrdtMgmtBPCollateral</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CrdtMBPCollateralTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CrdtMgmtBPCollateral</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CrdtMgmtBPCollateral> fetchCrdtMBPCollateralTP()
    {
        return fetchFieldAsList("to_CrdtMBPCollateralTP", CrdtMgmtBPCollateral.class);
    }

    /**
     * Retrieval of associated <b>CrdtMgmtBPCollateral</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CrdtMBPCollateralTP</b>.
     * <p>
     * If the navigation property <b>to_CrdtMBPCollateralTP</b> of a queried <b>CreditMgmtBusinessPartner</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CrdtMgmtBPCollateral</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CrdtMgmtBPCollateral> getCrdtMBPCollateralTPOrFetch()
    {
        if( toCrdtMBPCollateralTP == null ) {
            toCrdtMBPCollateralTP = fetchCrdtMBPCollateralTP();
        }
        return toCrdtMBPCollateralTP;
    }

    /**
     * Retrieval of associated <b>CrdtMgmtBPCollateral</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CrdtMBPCollateralTP</b>.
     * <p>
     * If the navigation property for an entity <b>CreditMgmtBusinessPartner</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CrdtMBPCollateralTP</b> is already loaded, the result
     *         will contain the <b>CrdtMgmtBPCollateral</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CrdtMgmtBPCollateral>> getCrdtMBPCollateralTPIfPresent()
    {
        return Option.of(toCrdtMBPCollateralTP);
    }

    /**
     * Overwrites the list of associated <b>CrdtMgmtBPCollateral</b> entities for the loaded navigation property
     * <b>to_CrdtMBPCollateralTP</b>.
     * <p>
     * If the navigation property <b>to_CrdtMBPCollateralTP</b> of a queried <b>CreditMgmtBusinessPartner</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CrdtMgmtBPCollateral</b> entities.
     */
    public void setCrdtMBPCollateralTP( @Nonnull final List<CrdtMgmtBPCollateral> value )
    {
        if( toCrdtMBPCollateralTP == null ) {
            toCrdtMBPCollateralTP = Lists.newArrayList();
        }
        toCrdtMBPCollateralTP.clear();
        toCrdtMBPCollateralTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CrdtMgmtBPCollateral</b> entities. This corresponds to the OData
     * navigation property <b>to_CrdtMBPCollateralTP</b>.
     * <p>
     * If the navigation property <b>to_CrdtMBPCollateralTP</b> of a queried <b>CreditMgmtBusinessPartner</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CrdtMgmtBPCollateral</b> entities.
     */
    public void addCrdtMBPCollateralTP( CrdtMgmtBPCollateral... entity )
    {
        if( toCrdtMBPCollateralTP == null ) {
            toCrdtMBPCollateralTP = Lists.newArrayList();
        }
        toCrdtMBPCollateralTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CrdtMgmtBPCreditInsurance</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CrdtMBPCreditInsuranceTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CrdtMgmtBPCreditInsurance</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CrdtMgmtBPCreditInsurance> fetchCrdtMBPCreditInsuranceTP()
    {
        return fetchFieldAsList("to_CrdtMBPCreditInsuranceTP", CrdtMgmtBPCreditInsurance.class);
    }

    /**
     * Retrieval of associated <b>CrdtMgmtBPCreditInsurance</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CrdtMBPCreditInsuranceTP</b>.
     * <p>
     * If the navigation property <b>to_CrdtMBPCreditInsuranceTP</b> of a queried <b>CreditMgmtBusinessPartner</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CrdtMgmtBPCreditInsurance</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CrdtMgmtBPCreditInsurance> getCrdtMBPCreditInsuranceTPOrFetch()
    {
        if( toCrdtMBPCreditInsuranceTP == null ) {
            toCrdtMBPCreditInsuranceTP = fetchCrdtMBPCreditInsuranceTP();
        }
        return toCrdtMBPCreditInsuranceTP;
    }

    /**
     * Retrieval of associated <b>CrdtMgmtBPCreditInsurance</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CrdtMBPCreditInsuranceTP</b>.
     * <p>
     * If the navigation property for an entity <b>CreditMgmtBusinessPartner</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CrdtMBPCreditInsuranceTP</b> is already loaded, the
     *         result will contain the <b>CrdtMgmtBPCreditInsurance</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CrdtMgmtBPCreditInsurance>> getCrdtMBPCreditInsuranceTPIfPresent()
    {
        return Option.of(toCrdtMBPCreditInsuranceTP);
    }

    /**
     * Overwrites the list of associated <b>CrdtMgmtBPCreditInsurance</b> entities for the loaded navigation property
     * <b>to_CrdtMBPCreditInsuranceTP</b>.
     * <p>
     * If the navigation property <b>to_CrdtMBPCreditInsuranceTP</b> of a queried <b>CreditMgmtBusinessPartner</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CrdtMgmtBPCreditInsurance</b> entities.
     */
    public void setCrdtMBPCreditInsuranceTP( @Nonnull final List<CrdtMgmtBPCreditInsurance> value )
    {
        if( toCrdtMBPCreditInsuranceTP == null ) {
            toCrdtMBPCreditInsuranceTP = Lists.newArrayList();
        }
        toCrdtMBPCreditInsuranceTP.clear();
        toCrdtMBPCreditInsuranceTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CrdtMgmtBPCreditInsurance</b> entities. This corresponds to the OData
     * navigation property <b>to_CrdtMBPCreditInsuranceTP</b>.
     * <p>
     * If the navigation property <b>to_CrdtMBPCreditInsuranceTP</b> of a queried <b>CreditMgmtBusinessPartner</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CrdtMgmtBPCreditInsurance</b> entities.
     */
    public void addCrdtMBPCreditInsuranceTP( CrdtMgmtBPCreditInsurance... entity )
    {
        if( toCrdtMBPCreditInsuranceTP == null ) {
            toCrdtMBPCreditInsuranceTP = Lists.newArrayList();
        }
        toCrdtMBPCreditInsuranceTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CrdtMgmtBPNegativeEvent</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CrdtMBPNegativeEventTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CrdtMgmtBPNegativeEvent</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CrdtMgmtBPNegativeEvent> fetchCrdtMBPNegativeEventTP()
    {
        return fetchFieldAsList("to_CrdtMBPNegativeEventTP", CrdtMgmtBPNegativeEvent.class);
    }

    /**
     * Retrieval of associated <b>CrdtMgmtBPNegativeEvent</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CrdtMBPNegativeEventTP</b>.
     * <p>
     * If the navigation property <b>to_CrdtMBPNegativeEventTP</b> of a queried <b>CreditMgmtBusinessPartner</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CrdtMgmtBPNegativeEvent</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CrdtMgmtBPNegativeEvent> getCrdtMBPNegativeEventTPOrFetch()
    {
        if( toCrdtMBPNegativeEventTP == null ) {
            toCrdtMBPNegativeEventTP = fetchCrdtMBPNegativeEventTP();
        }
        return toCrdtMBPNegativeEventTP;
    }

    /**
     * Retrieval of associated <b>CrdtMgmtBPNegativeEvent</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CrdtMBPNegativeEventTP</b>.
     * <p>
     * If the navigation property for an entity <b>CreditMgmtBusinessPartner</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CrdtMBPNegativeEventTP</b> is already loaded, the result
     *         will contain the <b>CrdtMgmtBPNegativeEvent</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CrdtMgmtBPNegativeEvent>> getCrdtMBPNegativeEventTPIfPresent()
    {
        return Option.of(toCrdtMBPNegativeEventTP);
    }

    /**
     * Overwrites the list of associated <b>CrdtMgmtBPNegativeEvent</b> entities for the loaded navigation property
     * <b>to_CrdtMBPNegativeEventTP</b>.
     * <p>
     * If the navigation property <b>to_CrdtMBPNegativeEventTP</b> of a queried <b>CreditMgmtBusinessPartner</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CrdtMgmtBPNegativeEvent</b> entities.
     */
    public void setCrdtMBPNegativeEventTP( @Nonnull final List<CrdtMgmtBPNegativeEvent> value )
    {
        if( toCrdtMBPNegativeEventTP == null ) {
            toCrdtMBPNegativeEventTP = Lists.newArrayList();
        }
        toCrdtMBPNegativeEventTP.clear();
        toCrdtMBPNegativeEventTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CrdtMgmtBPNegativeEvent</b> entities. This corresponds to the OData
     * navigation property <b>to_CrdtMBPNegativeEventTP</b>.
     * <p>
     * If the navigation property <b>to_CrdtMBPNegativeEventTP</b> of a queried <b>CreditMgmtBusinessPartner</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CrdtMgmtBPNegativeEvent</b> entities.
     */
    public void addCrdtMBPNegativeEventTP( CrdtMgmtBPNegativeEvent... entity )
    {
        if( toCrdtMBPNegativeEventTP == null ) {
            toCrdtMBPNegativeEventTP = Lists.newArrayList();
        }
        toCrdtMBPNegativeEventTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>CreditManagementAccount</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CreditMgmtAccountTP</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>CreditManagementAccount</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CreditManagementAccount> fetchCreditMgmtAccountTP()
    {
        return fetchFieldAsList("to_CreditMgmtAccountTP", CreditManagementAccount.class);
    }

    /**
     * Retrieval of associated <b>CreditManagementAccount</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CreditMgmtAccountTP</b>.
     * <p>
     * If the navigation property <b>to_CreditMgmtAccountTP</b> of a queried <b>CreditMgmtBusinessPartner</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>CreditManagementAccount</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<CreditManagementAccount> getCreditMgmtAccountTPOrFetch()
    {
        if( toCreditMgmtAccountTP == null ) {
            toCreditMgmtAccountTP = fetchCreditMgmtAccountTP();
        }
        return toCreditMgmtAccountTP;
    }

    /**
     * Retrieval of associated <b>CreditManagementAccount</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CreditMgmtAccountTP</b>.
     * <p>
     * If the navigation property for an entity <b>CreditMgmtBusinessPartner</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CreditMgmtAccountTP</b> is already loaded, the result
     *         will contain the <b>CreditManagementAccount</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<CreditManagementAccount>> getCreditMgmtAccountTPIfPresent()
    {
        return Option.of(toCreditMgmtAccountTP);
    }

    /**
     * Overwrites the list of associated <b>CreditManagementAccount</b> entities for the loaded navigation property
     * <b>to_CreditMgmtAccountTP</b>.
     * <p>
     * If the navigation property <b>to_CreditMgmtAccountTP</b> of a queried <b>CreditMgmtBusinessPartner</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>CreditManagementAccount</b> entities.
     */
    public void setCreditMgmtAccountTP( @Nonnull final List<CreditManagementAccount> value )
    {
        if( toCreditMgmtAccountTP == null ) {
            toCreditMgmtAccountTP = Lists.newArrayList();
        }
        toCreditMgmtAccountTP.clear();
        toCreditMgmtAccountTP.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>CreditManagementAccount</b> entities. This corresponds to the OData
     * navigation property <b>to_CreditMgmtAccountTP</b>.
     * <p>
     * If the navigation property <b>to_CreditMgmtAccountTP</b> of a queried <b>CreditMgmtBusinessPartner</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>CreditManagementAccount</b> entities.
     */
    public void addCreditMgmtAccountTP( CreditManagementAccount... entity )
    {
        if( toCreditMgmtAccountTP == null ) {
            toCreditMgmtAccountTP = Lists.newArrayList();
        }
        toCreditMgmtAccountTP.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of CreditMgmtBusinessPartner instances.
     *
     */
    public final static class CreditMgmtBusinessPartnerBuilder
    {

        private List<CrdtMgmtBPCollateral> toCrdtMBPCollateralTP = Lists.newArrayList();
        private List<CrdtMgmtBPCreditInsurance> toCrdtMBPCreditInsuranceTP = Lists.newArrayList();
        private List<CrdtMgmtBPNegativeEvent> toCrdtMBPNegativeEventTP = Lists.newArrayList();
        private List<CreditManagementAccount> toCreditMgmtAccountTP = Lists.newArrayList();

        private CreditMgmtBusinessPartner.CreditMgmtBusinessPartnerBuilder toCrdtMBPCollateralTP(
            final List<CrdtMgmtBPCollateral> value )
        {
            toCrdtMBPCollateralTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CrdtMBPCollateralTP</b> for <b>CreditMgmtBusinessPartner</b> to multiple
         * <b>CrdtMgmtBPCollateral</b>.
         *
         * @param value
         *            The CrdtMgmtBPCollaterals to build this CreditMgmtBusinessPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CreditMgmtBusinessPartner.CreditMgmtBusinessPartnerBuilder crdtMBPCollateralTP(
            CrdtMgmtBPCollateral... value )
        {
            return toCrdtMBPCollateralTP(Lists.newArrayList(value));
        }

        private CreditMgmtBusinessPartner.CreditMgmtBusinessPartnerBuilder toCrdtMBPCreditInsuranceTP(
            final List<CrdtMgmtBPCreditInsurance> value )
        {
            toCrdtMBPCreditInsuranceTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CrdtMBPCreditInsuranceTP</b> for <b>CreditMgmtBusinessPartner</b> to multiple
         * <b>CrdtMgmtBPCreditInsurance</b>.
         *
         * @param value
         *            The CrdtMgmtBPCreditInsurances to build this CreditMgmtBusinessPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CreditMgmtBusinessPartner.CreditMgmtBusinessPartnerBuilder crdtMBPCreditInsuranceTP(
            CrdtMgmtBPCreditInsurance... value )
        {
            return toCrdtMBPCreditInsuranceTP(Lists.newArrayList(value));
        }

        private CreditMgmtBusinessPartner.CreditMgmtBusinessPartnerBuilder toCrdtMBPNegativeEventTP(
            final List<CrdtMgmtBPNegativeEvent> value )
        {
            toCrdtMBPNegativeEventTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CrdtMBPNegativeEventTP</b> for <b>CreditMgmtBusinessPartner</b> to multiple
         * <b>CrdtMgmtBPNegativeEvent</b>.
         *
         * @param value
         *            The CrdtMgmtBPNegativeEvents to build this CreditMgmtBusinessPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CreditMgmtBusinessPartner.CreditMgmtBusinessPartnerBuilder crdtMBPNegativeEventTP(
            CrdtMgmtBPNegativeEvent... value )
        {
            return toCrdtMBPNegativeEventTP(Lists.newArrayList(value));
        }

        private CreditMgmtBusinessPartner.CreditMgmtBusinessPartnerBuilder toCreditMgmtAccountTP(
            final List<CreditManagementAccount> value )
        {
            toCreditMgmtAccountTP.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CreditMgmtAccountTP</b> for <b>CreditMgmtBusinessPartner</b> to multiple
         * <b>CreditManagementAccount</b>.
         *
         * @param value
         *            The CreditManagementAccounts to build this CreditMgmtBusinessPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public CreditMgmtBusinessPartner.CreditMgmtBusinessPartnerBuilder creditMgmtAccountTP(
            CreditManagementAccount... value )
        {
            return toCreditMgmtAccountTP(Lists.newArrayList(value));
        }

    }

}
