/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateral;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsurance;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditManagementMasterDataService
 * CreditManagementMasterDataService}.
 *
 */
public interface CreditManagementMasterDataServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<CreditManagementMasterDataServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<CreditManagementMasterDataServiceBatch>
{

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateral
     * CrdtMAcctCollateral} entity and save it to the S/4HANA system.
     *
     * @param crdtMAcctCollateral
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateral
     *            CrdtMAcctCollateral} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditManagementMasterDataServiceBatchChangeSet
        updateCrdtMAcctCollateral( @Nonnull final CrdtMAcctCollateral crdtMAcctCollateral );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateral
     * CrdtMAcctCollateral} entity in the S/4HANA system.
     *
     * @param crdtMAcctCollateral
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateral
     *            CrdtMAcctCollateral} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditManagementMasterDataServiceBatchChangeSet
        deleteCrdtMAcctCollateral( @Nonnull final CrdtMAcctCollateral crdtMAcctCollateral );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsurance
     * CrdtMAcctCrdtInsurance} entity and save it to the S/4HANA system.
     *
     * @param crdtMAcctCrdtInsurance
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsurance
     *            CrdtMAcctCrdtInsurance} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditManagementMasterDataServiceBatchChangeSet
        updateCrdtMAcctCrdtInsurance( @Nonnull final CrdtMAcctCrdtInsurance crdtMAcctCrdtInsurance );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsurance
     * CrdtMAcctCrdtInsurance} entity in the S/4HANA system.
     *
     * @param crdtMAcctCrdtInsurance
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsurance
     *            CrdtMAcctCrdtInsurance} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditManagementMasterDataServiceBatchChangeSet
        deleteCrdtMAcctCrdtInsurance( @Nonnull final CrdtMAcctCrdtInsurance crdtMAcctCrdtInsurance );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner
     * CreditMgmtBusinessPartner} entity and save it to the S/4HANA system.
     *
     * @param creditMgmtBusinessPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner
     *            CreditMgmtBusinessPartner} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditManagementMasterDataServiceBatchChangeSet
        createCreditMgmtBusinessPartner( @Nonnull final CreditMgmtBusinessPartner creditMgmtBusinessPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner
     * CreditMgmtBusinessPartner} entity and save it to the S/4HANA system.
     *
     * @param creditMgmtBusinessPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner
     *            CreditMgmtBusinessPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditManagementMasterDataServiceBatchChangeSet
        updateCreditMgmtBusinessPartner( @Nonnull final CreditMgmtBusinessPartner creditMgmtBusinessPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral
     * CrdtMgmtBPCollateral} entity and save it to the S/4HANA system.
     *
     * @param crdtMgmtBPCollateral
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral
     *            CrdtMgmtBPCollateral} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditManagementMasterDataServiceBatchChangeSet
        updateCrdtMgmtBPCollateral( @Nonnull final CrdtMgmtBPCollateral crdtMgmtBPCollateral );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral
     * CrdtMgmtBPCollateral} entity in the S/4HANA system.
     *
     * @param crdtMgmtBPCollateral
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral
     *            CrdtMgmtBPCollateral} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditManagementMasterDataServiceBatchChangeSet
        deleteCrdtMgmtBPCollateral( @Nonnull final CrdtMgmtBPCollateral crdtMgmtBPCollateral );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance
     * CrdtMgmtBPCreditInsurance} entity and save it to the S/4HANA system.
     *
     * @param crdtMgmtBPCreditInsurance
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance
     *            CrdtMgmtBPCreditInsurance} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditManagementMasterDataServiceBatchChangeSet
        updateCrdtMgmtBPCreditInsurance( @Nonnull final CrdtMgmtBPCreditInsurance crdtMgmtBPCreditInsurance );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance
     * CrdtMgmtBPCreditInsurance} entity in the S/4HANA system.
     *
     * @param crdtMgmtBPCreditInsurance
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance
     *            CrdtMgmtBPCreditInsurance} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditManagementMasterDataServiceBatchChangeSet
        deleteCrdtMgmtBPCreditInsurance( @Nonnull final CrdtMgmtBPCreditInsurance crdtMgmtBPCreditInsurance );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent
     * CrdtMgmtBPNegativeEvent} entity and save it to the S/4HANA system.
     *
     * @param crdtMgmtBPNegativeEvent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent
     *            CrdtMgmtBPNegativeEvent} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditManagementMasterDataServiceBatchChangeSet
        updateCrdtMgmtBPNegativeEvent( @Nonnull final CrdtMgmtBPNegativeEvent crdtMgmtBPNegativeEvent );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent
     * CrdtMgmtBPNegativeEvent} entity in the S/4HANA system.
     *
     * @param crdtMgmtBPNegativeEvent
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent
     *            CrdtMgmtBPNegativeEvent} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditManagementMasterDataServiceBatchChangeSet
        deleteCrdtMgmtBPNegativeEvent( @Nonnull final CrdtMgmtBPNegativeEvent crdtMgmtBPNegativeEvent );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount
     * CreditManagementAccount} entity and save it to the S/4HANA system.
     *
     * @param creditManagementAccount
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount
     *            CreditManagementAccount} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditManagementMasterDataServiceBatchChangeSet
        createCreditManagementAccount( @Nonnull final CreditManagementAccount creditManagementAccount );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount
     * CreditManagementAccount} entity and save it to the S/4HANA system.
     *
     * @param creditManagementAccount
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount
     *            CreditManagementAccount} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditManagementMasterDataServiceBatchChangeSet
        updateCreditManagementAccount( @Nonnull final CreditManagementAccount creditManagementAccount );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount
     * CreditManagementAccount} entity in the S/4HANA system.
     *
     * @param creditManagementAccount
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount
     *            CreditManagementAccount} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    CreditManagementMasterDataServiceBatchChangeSet
        deleteCreditManagementAccount( @Nonnull final CreditManagementAccount creditManagementAccount );

}
