/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCollateral;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMAcctCrdtInsurance;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner;

/**
 * Implementation of the {@link CreditManagementMasterDataServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditManagementMasterDataService
 * CreditManagementMasterDataService}.
 *
 */
public class DefaultCreditManagementMasterDataServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<CreditManagementMasterDataServiceBatch, CreditManagementMasterDataServiceBatchChangeSet>
    implements
    CreditManagementMasterDataServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditManagementMasterDataService service;

    @SuppressWarnings( "deprecation" )
    DefaultCreditManagementMasterDataServiceBatchChangeSet(
        @Nonnull final DefaultCreditManagementMasterDataServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.CreditManagementMasterDataService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultCreditManagementMasterDataServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public CreditManagementMasterDataServiceBatchChangeSet updateCrdtMAcctCollateral(
        @Nonnull final CrdtMAcctCollateral crdtMAcctCollateral )
    {
        return addRequestUpdate(service::updateCrdtMAcctCollateral, crdtMAcctCollateral);
    }

    @Nonnull
    @Override
    public CreditManagementMasterDataServiceBatchChangeSet deleteCrdtMAcctCollateral(
        @Nonnull final CrdtMAcctCollateral crdtMAcctCollateral )
    {
        return addRequestDelete(service::deleteCrdtMAcctCollateral, crdtMAcctCollateral);
    }

    @Nonnull
    @Override
    public CreditManagementMasterDataServiceBatchChangeSet updateCrdtMAcctCrdtInsurance(
        @Nonnull final CrdtMAcctCrdtInsurance crdtMAcctCrdtInsurance )
    {
        return addRequestUpdate(service::updateCrdtMAcctCrdtInsurance, crdtMAcctCrdtInsurance);
    }

    @Nonnull
    @Override
    public CreditManagementMasterDataServiceBatchChangeSet deleteCrdtMAcctCrdtInsurance(
        @Nonnull final CrdtMAcctCrdtInsurance crdtMAcctCrdtInsurance )
    {
        return addRequestDelete(service::deleteCrdtMAcctCrdtInsurance, crdtMAcctCrdtInsurance);
    }

    @Nonnull
    @Override
    public CreditManagementMasterDataServiceBatchChangeSet createCreditMgmtBusinessPartner(
        @Nonnull final CreditMgmtBusinessPartner creditMgmtBusinessPartner )
    {
        return addRequestCreate(service::createCreditMgmtBusinessPartner, creditMgmtBusinessPartner);
    }

    @Nonnull
    @Override
    public CreditManagementMasterDataServiceBatchChangeSet updateCreditMgmtBusinessPartner(
        @Nonnull final CreditMgmtBusinessPartner creditMgmtBusinessPartner )
    {
        return addRequestUpdate(service::updateCreditMgmtBusinessPartner, creditMgmtBusinessPartner);
    }

    @Nonnull
    @Override
    public CreditManagementMasterDataServiceBatchChangeSet updateCrdtMgmtBPCollateral(
        @Nonnull final CrdtMgmtBPCollateral crdtMgmtBPCollateral )
    {
        return addRequestUpdate(service::updateCrdtMgmtBPCollateral, crdtMgmtBPCollateral);
    }

    @Nonnull
    @Override
    public CreditManagementMasterDataServiceBatchChangeSet deleteCrdtMgmtBPCollateral(
        @Nonnull final CrdtMgmtBPCollateral crdtMgmtBPCollateral )
    {
        return addRequestDelete(service::deleteCrdtMgmtBPCollateral, crdtMgmtBPCollateral);
    }

    @Nonnull
    @Override
    public CreditManagementMasterDataServiceBatchChangeSet updateCrdtMgmtBPCreditInsurance(
        @Nonnull final CrdtMgmtBPCreditInsurance crdtMgmtBPCreditInsurance )
    {
        return addRequestUpdate(service::updateCrdtMgmtBPCreditInsurance, crdtMgmtBPCreditInsurance);
    }

    @Nonnull
    @Override
    public CreditManagementMasterDataServiceBatchChangeSet deleteCrdtMgmtBPCreditInsurance(
        @Nonnull final CrdtMgmtBPCreditInsurance crdtMgmtBPCreditInsurance )
    {
        return addRequestDelete(service::deleteCrdtMgmtBPCreditInsurance, crdtMgmtBPCreditInsurance);
    }

    @Nonnull
    @Override
    public CreditManagementMasterDataServiceBatchChangeSet updateCrdtMgmtBPNegativeEvent(
        @Nonnull final CrdtMgmtBPNegativeEvent crdtMgmtBPNegativeEvent )
    {
        return addRequestUpdate(service::updateCrdtMgmtBPNegativeEvent, crdtMgmtBPNegativeEvent);
    }

    @Nonnull
    @Override
    public CreditManagementMasterDataServiceBatchChangeSet deleteCrdtMgmtBPNegativeEvent(
        @Nonnull final CrdtMgmtBPNegativeEvent crdtMgmtBPNegativeEvent )
    {
        return addRequestDelete(service::deleteCrdtMgmtBPNegativeEvent, crdtMgmtBPNegativeEvent);
    }

    @Nonnull
    @Override
    public CreditManagementMasterDataServiceBatchChangeSet createCreditManagementAccount(
        @Nonnull final CreditManagementAccount creditManagementAccount )
    {
        return addRequestCreate(service::createCreditManagementAccount, creditManagementAccount);
    }

    @Nonnull
    @Override
    public CreditManagementMasterDataServiceBatchChangeSet updateCreditManagementAccount(
        @Nonnull final CreditManagementAccount creditManagementAccount )
    {
        return addRequestUpdate(service::updateCreditManagementAccount, creditManagementAccount);
    }

    @Nonnull
    @Override
    public CreditManagementMasterDataServiceBatchChangeSet deleteCreditManagementAccount(
        @Nonnull final CreditManagementAccount creditManagementAccount )
    {
        return addRequestDelete(service::deleteCreditManagementAccount, creditManagementAccount);
    }

}
