/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral
 * CrdtMgmtBPCollateral}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.field.CrdtMgmtBPCollateralField
 * CrdtMgmtBPCollateralField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.link.CrdtMgmtBPCollateralLink
 * CrdtMgmtBPCollateralLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral#BUSINESS_PARTNER
 * BUSINESS_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral#CREDIT_SEGMENT
 * CREDIT_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral#CRDT_ACCT_INFORMATION_CATEGORY
 * CRDT_ACCT_INFORMATION_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral#CRDT_ACCT_INFORMATION_TYPE
 * CRDT_ACCT_INFORMATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral#ADDITIONAL_CREDIT_DOC_SEQUENCE
 * ADDITIONAL_CREDIT_DOC_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral#EXCEPTION_IS_CREDIT_CHECK_RELEVANT
 * EXCEPTION_IS_CREDIT_CHECK_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral#ADDL_CREDIT_DOC_AMT_IN_TRANSAC_CRCY
 * ADDL_CREDIT_DOC_AMT_IN_TRANSAC_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral#ADDITIONAL_CREDIT_DOC_COMMENT
 * ADDITIONAL_CREDIT_DOC_COMMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCollateral#TO_CRDT_M_BUSINESS_PARTNER_TP
 * TO_CRDT_M_BUSINESS_PARTNER_TP}</li>
 * </ul>
 *
 */
public interface CrdtMgmtBPCollateralSelectable extends EntitySelectable<CrdtMgmtBPCollateral>
{

}
