/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance
 * CrdtMgmtBPCreditInsurance}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.field.CrdtMgmtBPCreditInsuranceField
 * CrdtMgmtBPCreditInsuranceField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.link.CrdtMgmtBPCreditInsuranceLink
 * CrdtMgmtBPCreditInsuranceLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance#BUSINESS_PARTNER
 * BUSINESS_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance#CREDIT_SEGMENT
 * CREDIT_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance#CRDT_ACCT_INFORMATION_CATEGORY
 * CRDT_ACCT_INFORMATION_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance#CRDT_ACCT_INFORMATION_TYPE
 * CRDT_ACCT_INFORMATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance#ADDITIONAL_CREDIT_DOC_SEQUENCE
 * ADDITIONAL_CREDIT_DOC_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance#EXCEPTION_IS_CREDIT_CHECK_RELEVANT
 * EXCEPTION_IS_CREDIT_CHECK_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance#ADDL_CREDIT_DOC_AMT_IN_TRANSAC_CRCY
 * ADDL_CREDIT_DOC_AMT_IN_TRANSAC_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance#ADDITIONAL_CREDIT_DOC_COMMENT
 * ADDITIONAL_CREDIT_DOC_COMMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPCreditInsurance#TO_CRDT_M_BUSINESS_PARTNER_TP
 * TO_CRDT_M_BUSINESS_PARTNER_TP}</li>
 * </ul>
 *
 */
public interface CrdtMgmtBPCreditInsuranceSelectable extends EntitySelectable<CrdtMgmtBPCreditInsurance>
{

}
