/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent
 * CrdtMgmtBPNegativeEvent}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.field.CrdtMgmtBPNegativeEventField
 * CrdtMgmtBPNegativeEventField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.link.CrdtMgmtBPNegativeEventLink
 * CrdtMgmtBPNegativeEventLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent#BUSINESS_PARTNER
 * BUSINESS_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent#CREDIT_SEGMENT
 * CREDIT_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent#CRDT_ACCT_INFORMATION_CATEGORY
 * CRDT_ACCT_INFORMATION_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent#CRDT_ACCT_INFORMATION_TYPE
 * CRDT_ACCT_INFORMATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent#ADDITIONAL_CREDIT_DOC_SEQUENCE
 * ADDITIONAL_CREDIT_DOC_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent#VALIDITY_END_DATE
 * VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent#ADDITIONAL_CREDIT_DOC_COMMENT
 * ADDITIONAL_CREDIT_DOC_COMMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CrdtMgmtBPNegativeEvent#TO_CRDT_M_BUSINESS_PARTNER_TP
 * TO_CRDT_M_BUSINESS_PARTNER_TP}</li>
 * </ul>
 *
 */
public interface CrdtMgmtBPNegativeEventSelectable extends EntitySelectable<CrdtMgmtBPNegativeEvent>
{

}
