/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount
 * CreditManagementAccount}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.field.CreditManagementAccountField
 * CreditManagementAccountField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.link.CreditManagementAccountLink
 * CreditManagementAccountLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount#BUSINESS_PARTNER
 * BUSINESS_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount#CREDIT_SEGMENT
 * CREDIT_SEGMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount#BUSINESS_PARTNER_IS_CRITICAL
 * BUSINESS_PARTNER_IS_CRITICAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount#CREDIT_ACCOUNT_IS_BLOCKED
 * CREDIT_ACCOUNT_IS_BLOCKED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount#CREDIT_ACCOUNT_BLOCK_REASON
 * CREDIT_ACCOUNT_BLOCK_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount#CREDIT_ACCOUNT_RESUBMISSION_DATE
 * CREDIT_ACCOUNT_RESUBMISSION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount#CREDIT_LIMIT_AMOUNT
 * CREDIT_LIMIT_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount#CREDIT_LIMIT_VALIDITY_END_DATE
 * CREDIT_LIMIT_VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount#CREDIT_LIMIT_LAST_CHANGE_DATE
 * CREDIT_LIMIT_LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount#CREDIT_LIMIT_CALCULATED_AMOUNT
 * CREDIT_LIMIT_CALCULATED_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount#CREDIT_LIMIT_IS_ZERO
 * CREDIT_LIMIT_IS_ZERO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount#CREDIT_LIMIT_REQUESTED_AMOUNT
 * CREDIT_LIMIT_REQUESTED_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount#CRDT_LMT_IS_REQD_FRM_AUTOM_CALC
 * CRDT_LMT_IS_REQD_FRM_AUTOM_CALC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount#CREDIT_LIMIT_REQD_VALIDITY_END_DATE
 * CREDIT_LIMIT_REQD_VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount#CREDIT_LIMIT_REQUEST_DATE
 * CREDIT_LIMIT_REQUEST_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount#CREDIT_SEGMENT_CURRENCY
 * CREDIT_SEGMENT_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount#TO_CRDT_M_BUSINESS_PARTNER_TP
 * TO_CRDT_M_BUSINESS_PARTNER_TP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount#TO_CRDT_M_ACCT_COLLATERAL_TP
 * TO_CRDT_M_ACCT_COLLATERAL_TP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditManagementAccount#TO_CRDT_M_ACCT_CRDT_INSURANCE_TP
 * TO_CRDT_M_ACCT_CRDT_INSURANCE_TP}</li>
 * </ul>
 *
 */
public interface CreditManagementAccountSelectable extends EntitySelectable<CreditManagementAccount>
{

}
