/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner
 * CreditMgmtBusinessPartner}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.field.CreditMgmtBusinessPartnerField
 * CreditMgmtBusinessPartnerField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.link.CreditMgmtBusinessPartnerLink
 * CreditMgmtBusinessPartnerLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner#BUSINESS_PARTNER
 * BUSINESS_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner#CRDT_MGMT_BUSINESS_PARTNER_GROUP
 * CRDT_MGMT_BUSINESS_PARTNER_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner#CREDIT_WORTHINESS_SCORE_VALUE
 * CREDIT_WORTHINESS_SCORE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner#CRDT_WRTHNSS_SCORE_VALDTY_END_DATE
 * CRDT_WRTHNSS_SCORE_VALDTY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner#CRDT_WORTHINESS_SCORE_LAST_CHG_DATE
 * CRDT_WORTHINESS_SCORE_LAST_CHG_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner#CALCD_CRDT_WORTHINESS_SCORE_VALUE
 * CALCD_CRDT_WORTHINESS_SCORE_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner#CREDIT_RISK_CLASS
 * CREDIT_RISK_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner#CALCULATED_CREDIT_RISK_CLASS
 * CALCULATED_CREDIT_RISK_CLASS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner#CREDIT_RISK_CLASS_LAST_CHANGE_DATE
 * CREDIT_RISK_CLASS_LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner#CREDIT_CHECK_RULE
 * CREDIT_CHECK_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner#CREDIT_SCORE_AND_LIMIT_CALC_RULE
 * CREDIT_SCORE_AND_LIMIT_CALC_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner#CUST_BUSINESS_RELSHP_START_YEAR
 * CUST_BUSINESS_RELSHP_START_YEAR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner#TO_CRDT_MBP_COLLATERAL_TP
 * TO_CRDT_MBP_COLLATERAL_TP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner#TO_CRDT_MBP_CREDIT_INSURANCE_TP
 * TO_CRDT_MBP_CREDIT_INSURANCE_TP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner#TO_CRDT_MBP_NEGATIVE_EVENT_TP
 * TO_CRDT_MBP_NEGATIVE_EVENT_TP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.creditmanagementmasterdata.CreditMgmtBusinessPartner#TO_CREDIT_MGMT_ACCOUNT_TP
 * TO_CREDIT_MGMT_ACCOUNT_TP}</li>
 * </ul>
 *
 */
public interface CreditMgmtBusinessPartnerSelectable extends EntitySelectable<CreditMgmtBusinessPartner>
{

}
